/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.net.UnknownHostException;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.jmx.CacheJmxWrapper;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.tcp.TcpCacheServer;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class TcpCacheServerTest {
    private static final String CONFIG_FILE = "META-INF/local-service.xml";
    static TcpCacheServer cache_server = null;
    private CacheSPI<Object, Object> cache;
    private CacheLoader loader;

    private void createCacheAndLoader() throws Exception {
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.LOCAL);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        c.setCacheLoaderConfig(this.getCacheLoaderConfig());
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(c);
        this.cache.start();
        this.loader = this.cache.getCacheLoaderManager().getCacheLoader();
    }

    protected CacheLoaderConfig getCacheLoaderConfig() throws Exception {
        String xml = "<config>\n<passivation>false</passivation>\n<preload></preload>\n<cacheloader>\n<class>org.jboss.cache.loader.TcpDelegatingCacheLoader</class>\n<properties>host=127.0.0.1\nport=12121</properties>\n<async>false</async>\n<shared>true</shared>\n<fetchPersistentState>true</fetchPersistentState>\n<purgeOnStartup>false</purgeOnStartup>\n</cacheloader>\n</config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            this.cache.stop();
            this.cache.destroy();
            this.cache = null;
        }
        if (cache_server != null) {
            System.out.println("Stopping TcpCacheServer");
            cache_server.stop();
            cache_server = null;
        }
    }

    private static void createTcpCacheServer() throws UnknownHostException {
        cache_server = new TcpCacheServer();
        cache_server.setBindAddress("127.0.0.1");
        cache_server.setPort(12121);
    }

    private void startTcpCacheServer() {
        Thread runner = new Thread(){

            public void run() {
                try {
                    System.out.println("Starting TcpCacheServer");
                    cache_server.create();
                    cache_server.start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        runner.setDaemon(true);
        runner.start();
        TestingUtil.sleepThread(2000L);
    }

    public void testInjectConfigFilePath() throws Exception {
        TcpCacheServerTest.createTcpCacheServer();
        cache_server.setConfig(CONFIG_FILE);
        this.startTcpCacheServer();
        this.createCacheAndLoader();
        this.cacheCheck();
        this.usabilityCheck();
    }

    public void testInjectCache() throws Exception {
        TcpCacheServerTest.createTcpCacheServer();
        CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(CONFIG_FILE, false);
        cache.start();
        cache_server.setCache(cache);
        this.startTcpCacheServer();
        this.createCacheAndLoader();
        this.cacheCheck();
        this.usabilityCheck();
    }

    public void testInjectCacheJmxWrapper() throws Exception {
        TcpCacheServerTest.createTcpCacheServer();
        CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(CONFIG_FILE, false);
        CacheJmxWrapper wrapper = new CacheJmxWrapper((Cache)cache);
        wrapper.start();
        cache_server.setCacheJmxWrapper((CacheJmxWrapperMBean)wrapper);
        this.startTcpCacheServer();
        this.createCacheAndLoader();
        this.cacheCheck();
        this.usabilityCheck();
    }

    private void cacheCheck() {
        Cache c = cache_server.getCache();
        AssertJUnit.assertNotNull((String)"Cache exists", (Object)c);
        Configuration config = c.getConfiguration();
        AssertJUnit.assertEquals((String)"Correct mode", (Object)Configuration.CacheMode.LOCAL, (Object)config.getCacheMode());
        AssertJUnit.assertEquals((String)"Correct cluster name", (String)"JBossCache-Cluster", (String)config.getClusterName());
    }

    private void usabilityCheck() throws Exception {
        Fqn fqn = new Fqn((Object[])new String[]{"key"});
        AssertJUnit.assertFalse((String)"Fqn does not exist in loader", (boolean)this.loader.exists(fqn));
        Object oldVal = this.loader.put(fqn, (Object)"one", (Object)"two");
        AssertJUnit.assertNull((String)"oldVal is null", (Object)oldVal);
        AssertJUnit.assertEquals((String)"Got value from cache", (Object)"two", (Object)this.cache.get(fqn, (Object)"one"));
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (cache_server != null) {
                    System.out.println("Stopping TcpCacheServer");
                    cache_server.stop();
                }
            }
        });
    }
}

