/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.Transaction;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class OptimisticWithCacheLoaderTest
extends AbstractOptimisticTestCase {
    public void testLoaderIndependently() throws Exception {
        CacheSPI<Object, Object> cache = this.createCacheWithLoader();
        CacheLoader loader = cache.getCacheLoaderManager().getCacheLoader();
        loader.remove(this.fqn);
        assert (loader.get(this.fqn) == null);
        loader.put(this.fqn, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, loader.get(this.fqn).get(this.key));
        loader.remove(this.fqn);
        AssertJUnit.assertNull((Object)loader.get(this.fqn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheLoadOnTree() throws Exception {
        CacheLoader loader = null;
        try {
            CacheSPI<Object, Object> cache = this.createCacheWithLoader();
            loader = cache.getCacheLoaderManager().getCacheLoader();
            DummyTransactionManager mgr = DummyTransactionManager.getInstance();
            AssertJUnit.assertNull((Object)cache.getNode(this.fqn));
            loader.put(this.fqn, (Object)this.key, (Object)this.value);
            mgr.begin();
            Transaction tx = mgr.getTransaction();
            AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
            mgr.suspend();
            mgr.begin();
            AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
            mgr.commit();
            mgr.resume(tx);
            AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
            mgr.commit();
        }
        finally {
            if (loader != null) {
                loader.remove(this.fqn);
            }
        }
    }

    public void testCacheStoring() throws Exception {
        CacheSPI<Object, Object> cache = this.createCacheWithLoader();
        CacheLoader loader = cache.getCacheLoaderManager().getCacheLoader();
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        cache.put(this.fqn, (Object)this.key, (Object)this.value);
        mgr.commit();
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, loader.get(this.fqn).get(this.key));
        mgr.begin();
        cache.removeNode(this.fqn);
        mgr.commit();
        AssertJUnit.assertNull((Object)cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)loader.get(this.fqn));
        mgr.begin();
        cache.put(this.fqn, (Object)this.key, (Object)this.value);
        Transaction tx = mgr.getTransaction();
        mgr.suspend();
        AssertJUnit.assertNull((Object)cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)loader.get(this.fqn));
        mgr.resume(tx);
        mgr.commit();
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, loader.get(this.fqn).get(this.key));
        loader.remove(this.fqn);
    }

    public void testCacheLoading() throws Exception {
        CacheSPI<Object, Object> cache = this.createCacheWithLoader();
        CacheLoader loader = cache.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertNull((Object)cache.get(this.fqn, (Object)this.key));
        loader.put(this.fqn, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, loader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        loader.remove(this.fqn);
        AssertJUnit.assertNotNull((Object)cache.get(this.fqn, (Object)this.key));
    }

    public void testCacheLoadingWithReplication() throws Exception {
        CacheSPI<Object, Object> cache1 = this.createReplicatedCacheWithLoader(false);
        CacheLoader loader1 = cache1.getCacheLoaderManager().getCacheLoader();
        CacheSPI<Object, Object> cache2 = this.createReplicatedCacheWithLoader(false);
        CacheLoader loader2 = cache2.getCacheLoaderManager().getCacheLoader();
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        cache1.put(this.fqn, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, (Object)cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)loader1.get(this.fqn));
        AssertJUnit.assertNull((Object)loader2.get(this.fqn));
        AssertJUnit.assertNull((Object)cache2.get(this.fqn, (Object)this.key));
        mgr.commit();
        AssertJUnit.assertEquals((Object)this.value, (Object)cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, loader2.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)cache2.get(this.fqn, (Object)this.key));
        mgr.begin();
        cache2.removeNode(this.fqn);
        AssertJUnit.assertNull((Object)cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, loader2.get(this.fqn).get(this.key));
        mgr.commit();
        AssertJUnit.assertNull((Object)cache1.getNode(this.fqn));
        AssertJUnit.assertNull((Object)loader1.get(this.fqn));
        AssertJUnit.assertNull((Object)loader2.get(this.fqn));
        AssertJUnit.assertNull((Object)cache2.getNode(this.fqn));
    }

    public void testSharedCacheLoadingWithReplication() throws Exception {
        CacheSPI<Object, Object> cache1 = this.createReplicatedCacheWithLoader(true);
        CacheLoader loader1 = cache1.getCacheLoaderManager().getCacheLoader();
        CacheSPI<Object, Object> cache2 = this.createReplicatedCacheWithLoader(true);
        CacheLoader loader2 = cache2.getCacheLoaderManager().getCacheLoader();
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        cache1.put(this.fqn, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, (Object)cache1.get(this.fqn, (Object)this.key));
        System.out.println("*** " + loader1.get(this.fqn));
        AssertJUnit.assertNull((Object)loader1.get(this.fqn));
        AssertJUnit.assertNull((Object)loader2.get(this.fqn));
        AssertJUnit.assertNull((Object)cache2.get(this.fqn, (Object)this.key));
        mgr.commit();
        AssertJUnit.assertEquals((Object)this.value, (Object)cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, loader2.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)cache2.get(this.fqn, (Object)this.key));
        mgr.begin();
        cache2.removeNode(this.fqn);
        AssertJUnit.assertNull((Object)cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, loader2.get(this.fqn).get(this.key));
        mgr.commit();
        AssertJUnit.assertNull((Object)cache1.getNode(this.fqn));
        AssertJUnit.assertNull((Object)loader1.get(this.fqn));
        AssertJUnit.assertNull((Object)loader2.get(this.fqn));
        AssertJUnit.assertNull((Object)cache2.getNode(this.fqn));
    }
}

