/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ParentVersionTest
extends AbstractOptimisticTestCase {
    private Cache<Object, Object> cache;
    private TransactionManager tm;
    protected boolean lockParentForChildInsertRemove = false;
    private Fqn parent = Fqn.fromString((String)"/parent");
    private Fqn child1 = Fqn.fromString((String)"/parent/child1");
    private Fqn child2 = Fqn.fromString((String)"/parent/child2");
    private Fqn deepchild = Fqn.fromString((String)"/parent/deep/child");

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        if (this.lockParentForChildInsertRemove) {
            this.cache = this.createCacheUnstarted();
            this.cache.getConfiguration().setLockParentForChildInsertRemove(true);
            this.cache.start();
        } else {
            this.cache = this.createCache();
        }
        this.tm = ((CacheSPI)this.cache).getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.destroyCache(this.cache);
    }

    private long getVersion(Node n) {
        return ((DefaultDataVersion)((NodeSPI)n).getVersion()).getRawVersion();
    }

    public void testSimpleAdd() {
        this.cache.put(this.parent, (Object)"k", (Object)"v");
        long parentVersion = this.getVersion(this.cache.getRoot().getChild(this.parent));
        this.cache.put(this.child1, (Object)"k", (Object)"v");
        if (this.lockParentForChildInsertRemove) {
            AssertJUnit.assertEquals((long)(parentVersion + 1L), (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        } else {
            AssertJUnit.assertEquals((long)parentVersion, (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        }
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.child1));
    }

    public void testSimpleRemove() {
        this.cache.put(this.parent, (Object)"k", (Object)"v");
        this.cache.put(this.child1, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.child1));
        long parentVersion = this.getVersion(this.cache.getRoot().getChild(this.parent));
        this.cache.removeNode(this.child1);
        if (this.lockParentForChildInsertRemove) {
            AssertJUnit.assertEquals((long)(parentVersion + 1L), (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        } else {
            AssertJUnit.assertEquals((long)parentVersion, (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        }
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertFalse((String)"Should have removed child1", (boolean)this.cache.getRoot().hasChild(this.child1));
    }

    public void testAddAndRemove() throws Exception {
        this.cache.put(this.parent, (Object)"k", (Object)"v");
        this.cache.put(this.child1, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.child1));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(this.child2));
        long parentVersion = this.getVersion(this.cache.getRoot().getChild(this.parent));
        this.tm.begin();
        this.cache.put(this.child2, (Object)"k", (Object)"v");
        this.cache.removeNode(this.child1);
        this.tm.commit();
        if (this.lockParentForChildInsertRemove) {
            AssertJUnit.assertEquals((long)(parentVersion + 1L), (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        } else {
            AssertJUnit.assertEquals((long)parentVersion, (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        }
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertFalse((String)"Should have removed child1", (boolean)this.cache.getRoot().hasChild(this.child1));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.child2));
    }

    public void testAddAndRemoveOverlap() throws Exception {
        this.cache.put(this.parent, (Object)"k", (Object)"v");
        this.cache.put(this.child1, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.child1));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(this.child2));
        long parentVersion = this.getVersion(this.cache.getRoot().getChild(this.parent));
        this.tm.begin();
        this.cache.put(this.child2, (Object)"k", (Object)"v");
        this.cache.removeNode(this.child1);
        this.cache.removeNode(this.child2);
        this.cache.removeNode(this.child1);
        this.cache.put(this.child1, (Object)"k", (Object)"v");
        this.cache.removeNode(this.child1);
        this.cache.removeNode(this.child2);
        this.cache.put(this.child2, (Object)"k", (Object)"v");
        this.tm.commit();
        if (this.lockParentForChildInsertRemove) {
            AssertJUnit.assertEquals((long)(parentVersion + 1L), (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        } else {
            AssertJUnit.assertEquals((long)parentVersion, (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        }
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertFalse((String)"Should have removed child1", (boolean)this.cache.getRoot().hasChild(this.child1));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.child2));
    }

    public void testRemoveAndAdd() throws Exception {
        this.cache.put(this.parent, (Object)"k", (Object)"v");
        this.cache.put(this.child1, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.child1));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(this.child2));
        long parentVersion = this.getVersion(this.cache.getRoot().getChild(this.parent));
        this.tm.begin();
        this.cache.removeNode(this.child1);
        this.cache.put(this.child2, (Object)"k", (Object)"v");
        this.tm.commit();
        if (this.lockParentForChildInsertRemove) {
            AssertJUnit.assertEquals((long)(parentVersion + 1L), (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        } else {
            AssertJUnit.assertEquals((long)parentVersion, (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        }
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertFalse((String)"Should have removed child1", (boolean)this.cache.getRoot().hasChild(this.child1));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.child2));
    }

    public void testDeepRemove() {
        this.cache.put(this.parent, (Object)"k", (Object)"v");
        this.cache.put(this.deepchild, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.deepchild));
        long parentVersion = this.getVersion(this.cache.getRoot().getChild(this.parent));
        this.cache.removeNode(this.deepchild);
        AssertJUnit.assertEquals((long)parentVersion, (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertFalse((String)"Should have removed deepchild", (boolean)this.cache.getRoot().hasChild(this.deepchild));
    }

    public void testDeepAdd() {
        this.cache.put(this.parent, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(this.deepchild));
        long parentVersion = this.getVersion(this.cache.getRoot().getChild(this.parent));
        this.cache.put(this.deepchild, (Object)"k", (Object)"v");
        if (this.lockParentForChildInsertRemove) {
            AssertJUnit.assertEquals((long)(parentVersion + 1L), (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        } else {
            AssertJUnit.assertEquals((long)parentVersion, (long)this.getVersion(this.cache.getRoot().getChild(this.parent)));
        }
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.parent));
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.deepchild));
    }
}

