/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.event.NodeEvent;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"})
public class ReplicatedPassivationIntegrationTest {
    private CacheSPI<String, String> cache_;
    private CacheSPI<String, String> cache1_;
    protected static final Log log = LogFactory.getLog(ReplicatedPassivationIntegrationTest.class);
    int wakeupIntervalMillis_ = 0;
    PassivationListener listener_ = new PassivationListener();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        DefaultCacheFactory instance = new DefaultCacheFactory();
        this.cache_ = (CacheSPI)instance.createCache(this.getCfg(), false);
        this.cache_.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache_.start();
        this.cache1_ = (CacheSPI)instance.createCache(this.getCfg(), false);
        this.cache1_.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache1_.start();
        this.cache1_.getNotifier().addCacheListener((Object)this.listener_);
        this.listener_.resetCounter();
        this.wakeupIntervalMillis_ = this.cache1_.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        this.log("wakeupInterval is " + this.wakeupIntervalMillis_);
        if (this.wakeupIntervalMillis_ <= 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis_));
        }
    }

    Configuration getCfg() throws Exception {
        Configuration cfg = new XmlConfigurationParser().parseFile("META-INF/replSync-passivation-service.xml");
        cfg.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        cfg.getCacheLoaderConfig().getFirstCacheLoaderConfig().setClassName(DummyInMemoryCacheLoader.class.getName());
        return cfg;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache_.stop();
        this.cache1_.stop();
    }

    public void testActivationEvent() throws Exception {
        String rootStr = "/org/jboss/test/data/";
        String rootStr1 = "/__JBossInternal__/5c4o12-pzhlhj-esnuy3sg-1-esnuy3sg-2";
        String str = rootStr + "0";
        this.cache_.removeNode(Fqn.ROOT);
        this.cache_.put(str, (Object)str, (Object)str);
        this.cache_.put(rootStr1, (Object)str, (Object)str);
        TestingUtil.sleepThread(11000L);
        NodeSPI n = this.cache1_.peek(Fqn.fromString((String)str), false, false);
        assert (n == null || !n.getKeys().contains(str)) : "UnversionedNode should not exist";
        String val = (String)this.cache1_.get(str, (Object)str);
        val = (String)this.cache1_.get(rootStr1, (Object)str);
        AssertJUnit.assertNotNull((String)"DataNode should be activated ", (Object)val);
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }

    @CacheListener
    public class PassivationListener {
        int counter = 0;
        int loadedCounter = 0;

        public int getCounter() {
            return this.counter;
        }

        public void resetCounter() {
            this.counter = 0;
            this.loadedCounter = 0;
        }

        @NodeActivated
        public void nodeActivated(NodeEvent ne) {
            if (!ne.isPre()) {
                ++this.counter;
                System.out.println("nodeActivate(): counter: " + this.counter);
                System.out.println("nodeActivate(): " + ne.getFqn());
            }
        }

        @NodePassivated
        public void nodePassivated(NodeEvent ne) {
            if (ne.isPre()) {
                System.out.println("nodePassivate(): " + ne.getFqn());
            }
        }

        @NodeLoaded
        public void nodeLoaded(NodeEvent ne) {
            if (!ne.isPre()) {
                ++this.loadedCounter;
            }
        }
    }
}

