/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.profiling;

import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.profiling.AbstractProfileTest;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.annotations.Test;

@Test(groups={"profiling"})
public class ProfileSlaveTest
extends AbstractProfileTest {
    private void waitForTest() throws Exception {
        System.out.println("Slave listening for remote connections.  Hit Enter when done.");
        System.in.read();
    }

    public void testReplSync() throws Exception {
        this.cache.start();
        this.waitForTest();
    }

    public void testReplAsync() throws Exception {
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.start();
        this.waitForTest();
    }

    public void testReplSyncOptimistic() throws Exception {
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.start();
        this.waitForTest();
    }

    public void testReplAsyncOptimistic() throws Exception {
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.start();
        this.waitForTest();
    }

    public void testReplSyncBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplSync();
    }

    public void testReplAsyncBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplAsync();
    }

    public void testReplSyncOptBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplSyncOptimistic();
    }

    public void testReplAsyncOptBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplAsyncOptimistic();
    }
}

