/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public class SuspendTxTest {
    CacheSPI<String, String> cache;
    TransactionManager mgr;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        DefaultCacheFactory instance = new DefaultCacheFactory();
        this.cache = (CacheSPI)instance.createCache(false);
        this.cache.getConfiguration().setCacheMode("local");
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache.start();
        this.mgr = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
        if (this.mgr.getTransaction() != null) {
            this.mgr.rollback();
        }
        this.mgr = null;
    }

    public void testSuspendedLocks() throws Exception {
        this.cache.put("/one", null);
        this.cache.put("/a", null);
        this.mgr.begin();
        this.cache.put("/one/two", (Object)"key1", (Object)"val1");
        int numLocksBefore = this.cache.getNumberOfLocksHeld();
        Transaction tx = this.mgr.suspend();
        this.cache.put("/a/b", (Object)"key1", (Object)"val1");
        this.mgr.resume(tx);
        AssertJUnit.assertEquals((int)numLocksBefore, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testSuspendedUsingOptionsLocks() throws Exception {
        this.mgr.begin();
        this.cache.put("/one/two", (Object)"key1", (Object)"val1");
        int numLocksBefore = this.cache.getNumberOfLocksHeld();
        this.cache.getInvocationContext().getOptionOverrides().setFailSilently(true);
        this.cache.put(Fqn.fromString((String)"/a/b"), (Object)"key1", (Object)"val1");
        AssertJUnit.assertEquals((int)numLocksBefore, (int)this.cache.getNumberOfLocksHeld());
    }
}

