/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.util;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.pojo.impl.InternalConstant;
import org.jboss.cache.pojo.interceptors.dynamic.BaseInterceptor;
import org.jboss.cache.pojo.interceptors.dynamic.CacheFieldInterceptor;
import org.jboss.util.id.GUID;

public final class AopUtil {
    static final Log log = LogFactory.getLog((String)AopUtil.class.getName());
    public static final String SEPARATOR = "/";

    public static Interceptor findCacheInterceptor(InstanceAdvisor advisor, Fqn fqn) {
        Interceptor[] interceptors = advisor.getInterceptors();
        for (int i = 0; i < interceptors.length; ++i) {
            CacheFieldInterceptor inter;
            Interceptor interceptor = interceptors[i];
            if (!(interceptor instanceof CacheFieldInterceptor) || (inter = (CacheFieldInterceptor)interceptor) == null || !inter.getFqn().equals((Object)fqn)) continue;
            return interceptor;
        }
        return null;
    }

    public static Interceptor findCacheInterceptor(InstanceAdvisor advisor) {
        Interceptor[] interceptors = advisor.getInterceptors();
        for (int i = 0; i < interceptors.length; ++i) {
            Interceptor interceptor = interceptors[i];
            if (!(interceptor instanceof CacheFieldInterceptor)) continue;
            return interceptor;
        }
        return null;
    }

    public static Interceptor findCollectionInterceptor(InstanceAdvisor advisor) {
        Interceptor[] interceptors = advisor.getInterceptors();
        for (int i = 0; i < interceptors.length; ++i) {
            Interceptor interceptor = interceptors[i];
            if (!(interceptor instanceof BaseInterceptor)) continue;
            return interceptor;
        }
        return null;
    }

    public static void checkObjectType(Object obj) {
        if (obj == null) {
            return;
        }
        if (!(obj instanceof Advised)) {
            boolean allowedType;
            boolean bl = allowedType = obj instanceof Serializable || obj.getClass().isArray() && obj.getClass().getComponentType().isPrimitive();
            if (!allowedType) {
                throw new IllegalArgumentException("PojoCache.putObject(): Object type is neither  aspectized nor Serializable nor an array of primitives. Object class name is " + obj.getClass().getName());
            }
        }
    }

    public static Fqn constructFqn(Fqn baseFqn, Object relative) {
        return new Fqn(baseFqn, new Object[]{relative.toString()});
    }

    public static Fqn createInternalFqn(Fqn fqn, Cache cache) {
        Fqn trueId = null;
        if (fqn.hasElement((Object)"_ID_")) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < fqn.size(); ++i) {
                if (fqn.get(i).equals("__JBossInternal__")) continue;
                if (fqn.get(i).equals("_ID_")) break;
                list.add(fqn.get(i));
            }
            trueId = new Fqn(list);
        } else {
            trueId = fqn;
        }
        boolean createIfAbsent = false;
        Region region = cache.getRegion(trueId, createIfAbsent);
        GUID guid = new GUID();
        if (region == null || region.getFqn().equals((Object)Fqn.ROOT)) {
            Fqn f0 = new Fqn(InternalConstant.JBOSS_INTERNAL, trueId);
            Fqn f = new Fqn(f0, InternalConstant.JBOSS_INTERNAL_ID_SEP);
            return new Fqn(f, Fqn.fromString((String)guid.toString()));
        }
        Fqn rf = region.getFqn();
        Fqn childf = trueId.getSubFqn(rf.size(), trueId.size());
        Fqn f0 = new Fqn(InternalConstant.JBOSS_INTERNAL, childf);
        Fqn f = new Fqn(f0, InternalConstant.JBOSS_INTERNAL_ID_SEP);
        Fqn f1 = new Fqn(rf, f);
        return new Fqn(f1, Fqn.fromString((String)guid.toString()));
    }
}

