/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jgroups.Address;
import org.jgroups.blocks.RspFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGravitatorInterceptor
extends BaseRpcInterceptor {
    private BuddyManager buddyManager;
    private boolean syncCommunications = false;
    private Map<GlobalTransaction, MethodCall> transactionMods = new ConcurrentHashMap<GlobalTransaction, MethodCall>();

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.buddyManager = cache.getBuddyManager();
        this.syncCommunications = this.configuration.getCacheMode() == Configuration.CacheMode.REPL_SYNC || this.configuration.getCacheMode() == Configuration.CacheMode.INVALIDATION_SYNC;
    }

    public DataGravitatorInterceptor() {
        this.initLogger();
    }

    @Override
    protected boolean skipMethodCall(InvocationContext ctx) {
        return MethodDeclarations.isBlockUnblockMethod(ctx.getMethodCall().getMethodId()) || ctx.getOptionOverrides().isSkipDataGravitation();
    }

    @Override
    protected Object handleGetChildrenNamesMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.handleGetMethod(ctx, fqn);
    }

    @Override
    protected Object handleGetDataMapMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.handleGetMethod(ctx, fqn);
    }

    @Override
    protected Object handleExistsMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.handleGetMethod(ctx, fqn);
    }

    @Override
    protected Object handleGetKeysMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.handleGetMethod(ctx, fqn);
    }

    @Override
    protected Object handleGetKeyValueMethod(InvocationContext ctx, Fqn fqn, Object key, boolean sendNodeEvent) throws Throwable {
        return this.handleGetMethod(ctx, fqn);
    }

    @Override
    protected Object handleGetNodeMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        return this.handleGetMethod(ctx, fqn);
    }

    @Override
    protected Object handlePrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modification, Address coordinator, boolean onePhaseCommit) throws Throwable {
        try {
            Object returnValue = this.nextInterceptor(ctx);
            this.doPrepare(ctx.getGlobalTransaction(), ctx);
            return returnValue;
        }
        catch (Throwable throwable) {
            this.transactionMods.remove(ctx.getGlobalTransaction());
            throw throwable;
        }
    }

    @Override
    protected Object handleOptimisticPrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modifications, Map data, Address address, boolean onePhaseCommit) throws Throwable {
        return this.handlePrepareMethod(ctx, gtx, modifications, address, onePhaseCommit);
    }

    @Override
    protected Object handleRollbackMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        try {
            this.transactionMods.remove(ctx.getGlobalTransaction());
            return this.nextInterceptor(ctx);
        }
        catch (Throwable throwable) {
            this.transactionMods.remove(ctx.getGlobalTransaction());
            throw throwable;
        }
    }

    @Override
    protected Object handleCommitMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        try {
            this.doCommit(ctx.getGlobalTransaction(), ctx);
            this.transactionMods.remove(ctx.getGlobalTransaction());
            return this.nextInterceptor(ctx);
        }
        catch (Throwable throwable) {
            this.transactionMods.remove(ctx.getGlobalTransaction());
            throw throwable;
        }
    }

    private Object handleGetMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        if (this.isGravitationEnabled(ctx)) {
            if (this.trace) {
                this.log.trace((Object)("Checking local existence of fqn " + fqn));
            }
            if (BuddyManager.isBackupFqn(fqn)) {
                this.log.info((Object)"Is call for a backup Fqn, not performing any gravitation.  Direct calls on internal backup nodes are *not* supported.");
            } else if (this.peekNode(ctx, fqn, false, false, false) == null) {
                BackupData data;
                if (this.trace) {
                    this.log.trace((Object)"Gravitating from local backup tree");
                }
                if ((data = this.localBackupGet(fqn, ctx)) == null) {
                    if (this.trace) {
                        this.log.trace((Object)"Gravitating from remote backup tree");
                    }
                    data = this.remoteBackupGet(fqn);
                }
                if (data != null) {
                    if (this.trace) {
                        this.log.trace((Object)"Passing the put call locally to make sure state is persisted and ownership is correctly established.");
                    }
                    this.createNode(ctx, data.backupData, false);
                    this.cleanBackupData(data, ctx.getGlobalTransaction(), ctx);
                }
            } else if (this.trace) {
                this.log.trace((Object)"No need to gravitate; have this already.");
            }
        } else if (this.trace) {
            this.log.trace((Object)"Suppressing data gravitation for this call.");
        }
        return this.nextInterceptor(ctx);
    }

    private boolean isGravitationEnabled(InvocationContext ctx) {
        boolean enabled = ctx.isOriginLocal();
        if (enabled && !this.buddyManager.isAutoDataGravitation()) {
            enabled = ctx.getOptionOverrides().getForceDataGravitation();
        }
        return enabled;
    }

    private void doPrepare(GlobalTransaction gtx, InvocationContext ctx) throws Throwable {
        MethodCall cleanup = this.transactionMods.get(gtx);
        if (this.trace) {
            this.log.trace((Object)("Broadcasting prepare for cleanup ops " + (Object)((Object)cleanup)));
        }
        if (cleanup != null) {
            ArrayList<MethodCall> mods = new ArrayList<MethodCall>(1);
            mods.add(cleanup);
            MethodCall prepare = this.configuration.isNodeLockingOptimistic() ? MethodCallFactory.create(18, gtx, mods, null, this.cache.getLocalAddress(), false) : MethodCallFactory.create(10, gtx, mods, this.cache.getLocalAddress(), this.syncCommunications);
            this.replicateCall(ctx, this.getMembersOutsideBuddyGroup(), prepare, this.syncCommunications, ctx.getOptionOverrides());
        } else if (this.trace) {
            this.log.trace((Object)("Nothing to broadcast in prepare phase for gtx " + gtx));
        }
    }

    private void doCommit(GlobalTransaction gtx, InvocationContext ctx) throws Throwable {
        if (this.transactionMods.containsKey(gtx)) {
            if (this.trace) {
                this.log.trace((Object)("Broadcasting commit for gtx " + gtx));
            }
            this.replicateCall(ctx, this.getMembersOutsideBuddyGroup(), MethodCallFactory.create(11, gtx), this.syncCommunications, ctx.getOptionOverrides());
        } else if (this.trace) {
            this.log.trace((Object)("Nothing to broadcast in commit phase for gtx " + gtx));
        }
    }

    private List<Address> getMembersOutsideBuddyGroup() {
        ArrayList<Address> members = new ArrayList<Address>(this.cache.getMembers());
        members.remove(this.cache.getLocalAddress());
        members.removeAll(this.buddyManager.getBuddyAddresses());
        return members;
    }

    private BackupData remoteBackupGet(Fqn name) throws Exception {
        BackupData result = null;
        GravitateResult gr = this.gravitateData(name);
        if (gr.isDataFound()) {
            if (this.trace) {
                this.log.trace((Object)("Got response " + gr));
            }
            result = new BackupData(name, gr);
        }
        return result;
    }

    private void cleanBackupData(BackupData backup, GlobalTransaction gtx, InvocationContext ctx) throws Throwable {
        MethodCall cleanup = MethodCallFactory.create(34, backup.primaryFqn, backup.backupFqn);
        if (this.trace) {
            this.log.trace((Object)("Performing cleanup on [" + backup.primaryFqn + "]"));
        }
        if (gtx == null) {
            if (this.trace) {
                this.log.trace((Object)("Performing cleanup on [" + backup.backupFqn + "]"));
            }
            this.replicateCall(ctx, this.cache.getMembers(), cleanup, this.syncCommunications, ctx.getOptionOverrides(), false);
        } else {
            if (this.trace) {
                this.log.trace((Object)("Data gravitation performed under global transaction " + gtx + ".  Not broadcasting cleanups until the tx commits.  Adding to tx mod list instead."));
            }
            this.transactionMods.put(gtx, cleanup);
            TransactionEntry te = this.getTransactionEntry(gtx);
            te.addModification(cleanup);
        }
    }

    private GravitateResult gravitateData(Fqn fqn) throws Exception {
        if (this.trace) {
            this.log.trace((Object)("cache=" + this.cache.getLocalAddress() + "; requesting data gravitation for Fqn " + fqn));
        }
        List<Address> mbrs = this.cache.getMembers();
        Boolean searchSubtrees = this.buddyManager.isDataGravitationSearchBackupTrees() ? Boolean.TRUE : Boolean.FALSE;
        MethodCall dGrav = MethodCallFactory.create(35, fqn, searchSubtrees);
        List resps = this.cache.getRPCManager().callRemoteMethods(mbrs, dGrav, 2, true, this.buddyManager.getBuddyCommunicationTimeout(), new ResponseValidityFilter(mbrs, this.cache.getLocalAddress()));
        if (this.trace) {
            this.log.trace((Object)("got responses " + resps));
        }
        if (resps == null) {
            if (mbrs.size() > 1) {
                this.log.error((Object)("No replies to call " + (Object)((Object)dGrav)));
            }
            return GravitateResult.noDataFound();
        }
        GravitateResult result = GravitateResult.noDataFound();
        for (Object o : resps) {
            if (o instanceof Throwable) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)"Found remote Throwable among responses - removing from responses list", (Throwable)((Exception)o));
                continue;
            }
            if (o != null) {
                result = (GravitateResult)o;
                if (!result.isDataFound()) continue;
                break;
            }
            if (this.configuration.isUseRegionBasedMarshalling()) continue;
            this.log.error((Object)("Unexpected null response to call " + (Object)((Object)dGrav) + "."));
        }
        return result;
    }

    private void createNode(InvocationContext ctx, List<NodeData> nodeData, boolean localOnly) throws CacheException {
        for (NodeData data : nodeData) {
            if (localOnly) {
                if (this.peekNode(ctx, data.getFqn(), false, false, false) != null) continue;
                this.createNodesLocally(data.getFqn(), data.getAttributes());
                continue;
            }
            this.cache.put(data.getFqn(), data.getAttributes());
        }
    }

    private void createNodesLocally(Fqn<?> fqn, Map<?, ?> data) throws CacheException {
        int treeNodeSize = fqn.size();
        if (treeNodeSize == 0) {
            return;
        }
        NodeSPI n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize; ++i) {
            Object child_name = fqn.get(i);
            NodeSPI<?, ?> child_node = n.addChildDirect(new Fqn<Object>(child_name));
            if (child_node == null) {
                if (this.trace) {
                    this.log.trace((Object)("failed to find or create child " + child_name + " of node " + n.getFqn()));
                }
                return;
            }
            if (i == treeNodeSize - 1) {
                child_node.putAllDirect(data);
            }
            n = child_node;
        }
    }

    private TransactionEntry getTransactionEntry(GlobalTransaction gtx) {
        return this.cache.getTransactionTable().get(gtx);
    }

    private BackupData localBackupGet(Fqn fqn, InvocationContext ctx) throws CacheException {
        GravitateResult result = this.cache.gravitateData(fqn, true);
        boolean found = result.isDataFound();
        BackupData data = null;
        if (found) {
            Fqn backupFqn = result.getBuddyBackupFqn();
            data = new BackupData(fqn, result);
            if (this.buddyManager.isDataGravitationRemoveOnFind()) {
                ctx.getOptionOverrides().setCacheModeLocal(true);
                this.cache.removeNode(backupFqn);
            } else {
                this.cache.evict(backupFqn, true);
            }
        }
        return data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResponseValidityFilter
    implements RspFilter {
        private int numValidResponses = 0;
        private List<Address> pendingResponders;

        public ResponseValidityFilter(List<Address> expected, Address localAddress) {
            this.pendingResponders = new ArrayList<Address>(expected);
            this.pendingResponders.remove(localAddress);
        }

        public boolean isAcceptable(Object object, Address address) {
            GravitateResult response;
            this.pendingResponders.remove(address);
            if (object instanceof GravitateResult && (response = (GravitateResult)object).isDataFound()) {
                ++this.numValidResponses;
            }
            return true;
        }

        public boolean needMoreResponses() {
            return this.numValidResponses < 1 && this.pendingResponders.size() > 0;
        }
    }

    private static class BackupData {
        Fqn primaryFqn;
        Fqn backupFqn;
        List<NodeData> backupData;

        public BackupData(Fqn primaryFqn, GravitateResult gr) {
            this.primaryFqn = primaryFqn;
            this.backupFqn = gr.getBuddyBackupFqn();
            this.backupData = gr.getNodeData();
        }
    }
}

