/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.interceptors.InvalidationInterceptorMBean;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidationInterceptor
extends BaseRpcInterceptor
implements InvalidationInterceptorMBean {
    private long m_invalidations = 0L;
    protected TransactionTable txTable;
    protected Map<GlobalTransaction, List<MethodCall>> txMods;
    protected boolean optimistic;

    public InvalidationInterceptor() {
        this.initLogger();
    }

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.optimistic = this.configuration.isNodeLockingOptimistic();
        if (this.optimistic) {
            this.txMods = new ConcurrentHashMap<GlobalTransaction, List<MethodCall>>();
        }
    }

    @Inject
    private void injectDependencies(TransactionTable txTable) {
        this.txTable = txTable;
    }

    @Override
    protected boolean skipMethodCall(InvocationContext ctx) {
        Option optionOverride = ctx.getOptionOverrides();
        if (optionOverride != null && optionOverride.isCacheModeLocal() && (ctx.getTransaction() == null || MethodDeclarations.isTransactionLifecycleMethod(ctx.getMethodCall().getMethodId()))) {
            return true;
        }
        if (this.trace) {
            this.log.trace((Object)("(" + this.cache.getLocalAddress() + ") method call " + (Object)((Object)ctx.getMethodCall())));
        }
        return false;
    }

    @Override
    protected Object handlePutDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Map data, boolean createUndoOps) throws Throwable {
        return this.handleCrudMethod(ctx, fqn, null);
    }

    @Override
    protected Object handlePutDataEraseMethod(InvocationContext ctx, GlobalTransaction gt, Fqn fqn, Map newData, boolean createUndoOps, boolean eraseContents) throws Throwable {
        return this.handleCrudMethod(ctx, fqn, null);
    }

    @Override
    protected Object handlePutKeyValueMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps) throws Throwable {
        return this.handleCrudMethod(ctx, fqn, null);
    }

    @Override
    protected Object handlePutDataEraseVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Map data, boolean createUndoOps, boolean eraseContent, DataVersion dv) throws Throwable {
        return this.handleCrudMethod(ctx, fqn, null);
    }

    @Override
    protected Object handlePutDataVersionedMethod(InvocationContext ctx, GlobalTransaction globalTransaction, Fqn fqn, Map map, Boolean createUndoOps, DataVersion dataVersion) throws Throwable {
        return this.handleCrudMethod(ctx, fqn, null);
    }

    @Override
    protected Object handlePutKeyValueVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps, DataVersion dv) throws Throwable {
        return this.handleCrudMethod(ctx, fqn, null);
    }

    @Override
    protected Object handleRemoveNodeMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        return this.handleCrudMethod(ctx, fqn, null);
    }

    @Override
    protected Object handleRemoveKeyMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, boolean createUndoOps) throws Throwable {
        return this.handleCrudMethod(ctx, fqn, null);
    }

    @Override
    protected Object handleRemoveDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        return this.handleCrudMethod(ctx, fqn, null);
    }

    @Override
    protected Object handleDataGravitationCleanupMethod(InvocationContext ctx, Fqn primary, Fqn backup) throws Throwable {
        return this.handleCrudMethod(ctx, primary, null);
    }

    @Override
    protected Object handleMoveMethod(InvocationContext ctx, Fqn from, Fqn to) throws Throwable {
        return this.handleCrudMethod(ctx, to, from);
    }

    @Override
    protected Object handleRemoveKeyVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, boolean createUndoOps, DataVersion dv) throws Throwable {
        return this.handleCrudMethod(ctx, fqn, null);
    }

    @Override
    protected Object handleRemoveNodeVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, boolean createUndoOps, DataVersion dv) throws Throwable {
        return this.handleCrudMethod(ctx, fqn, null);
    }

    @Override
    protected Object handleRemoveDataVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, boolean createUndoOps, DataVersion dv) throws Throwable {
        return this.handleCrudMethod(ctx, fqn, null);
    }

    @Override
    protected Object handlePrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modification, Address coordinator, boolean onePhaseCommit) throws Throwable {
        Object retval = this.nextInterceptor(ctx);
        Transaction tx = ctx.getTransaction();
        if (tx != null && !this.optimistic) {
            this.log.debug((Object)"Entering InvalidationInterceptor's prepare phase");
            gtx = ctx.getGlobalTransaction();
            TransactionEntry entry = this.txTable.get(gtx);
            if (entry == null) {
                throw new IllegalStateException("cannot find transaction entry for " + gtx);
            }
            LinkedList<MethodCall> modifications = new LinkedList<MethodCall>(entry.getModifications());
            if (modifications.size() > 0) {
                this.broadcastInvalidate(modifications, gtx, tx, ctx);
            } else {
                this.log.debug((Object)"Nothing to invalidate - no modifications in the transaction.");
            }
        }
        return retval;
    }

    @Override
    protected Object handleOptimisticPrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modifications, Map data, Address address, boolean onePhaseCommit) throws Throwable {
        Object retval = this.nextInterceptor(ctx);
        Transaction tx = ctx.getTransaction();
        if (tx != null) {
            gtx = ctx.getGlobalTransaction();
            TransactionEntry entry = this.txTable.get(gtx);
            if (entry == null) {
                throw new IllegalStateException("cannot find transaction entry for " + gtx);
            }
            modifications = new LinkedList<MethodCall>(entry.getModifications());
            if (modifications.size() > 0) {
                this.txMods.put(gtx, modifications);
            }
        }
        return retval;
    }

    @Override
    protected Object handleCommitMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        Object retval = this.nextInterceptor(ctx);
        Transaction tx = ctx.getTransaction();
        if (tx != null && this.optimistic) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            List<MethodCall> modifications = this.txMods.remove(gtx);
            this.broadcastInvalidate(modifications, gtx, tx, ctx);
            this.log.debug((Object)"Committing.  Broadcasting invalidations.");
        }
        return retval;
    }

    @Override
    protected Object handleRollbackMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        Object retval = this.nextInterceptor(ctx);
        Transaction tx = ctx.getTransaction();
        if (tx != null && this.optimistic) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            this.txMods.remove(gtx);
            this.log.debug((Object)"Caught a rollback.  Clearing modification in txMods");
        }
        return retval;
    }

    private Object handleCrudMethod(InvocationContext ctx, Fqn targetFqn, Fqn from) throws Throwable {
        Object retval = this.nextInterceptor(ctx);
        Transaction tx = ctx.getTransaction();
        Option optionOverride = ctx.getOptionOverrides();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Is a CRUD method");
        }
        HashSet<Fqn> fqns = new HashSet<Fqn>();
        if (from != null) {
            fqns.add(from);
        }
        fqns.add(targetFqn);
        if (!(fqns.isEmpty() || tx != null && this.isValid(tx))) {
            for (Fqn fqn : fqns) {
                this.invalidateAcrossCluster(fqn, null, this.isSynchronous(optionOverride), ctx);
            }
        }
        return retval;
    }

    private void broadcastInvalidate(List<MethodCall> modifications, GlobalTransaction gtx, Transaction tx, InvocationContext ctx) {
        if (this.containsPutForExternalRead(modifications)) {
            this.log.debug((Object)"Modification list contains a putForExternalRead operation.  Not invalidating.");
        } else {
            try {
                this.invalidateModifications(modifications, this.configuration.isNodeLockingOptimistic() ? this.getWorkspace(gtx) : null, this.defaultSynchronous, ctx);
            }
            catch (Throwable t) {
                this.log.warn((Object)"Unable to broadcast evicts as a part of the prepare phase.  Rolling back.", t);
                try {
                    tx.setRollbackOnly();
                }
                catch (SystemException se) {
                    throw new RuntimeException("setting tx rollback failed ", se);
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException("Unable to broadcast invalidation messages", t);
            }
        }
    }

    private boolean containsPutForExternalRead(List<MethodCall> l) {
        if (l == null) {
            return false;
        }
        for (MethodCall m : l) {
            if (m.getMethodId() != 45 && m.getMethodId() != 46) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getInvalidations() {
        return this.m_invalidations;
    }

    @Override
    public void resetStatistics() {
        this.m_invalidations = 0L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("Invalidations", this.m_invalidations);
        return retval;
    }

    protected void invalidateAcrossCluster(Fqn fqn, TransactionWorkspace workspace, InvocationContext ctx) throws Throwable {
        this.invalidateAcrossCluster(fqn, workspace, this.defaultSynchronous, ctx);
    }

    protected void invalidateAcrossCluster(Fqn fqn, TransactionWorkspace workspace, boolean synchronous, InvocationContext ctx) throws Throwable {
        if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
            ++this.m_invalidations;
        }
        MethodCall call = MethodCallFactory.create(47, fqn, this.getNodeVersion(workspace, fqn));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cache [" + this.cache.getLocalAddress() + "] replicating " + (Object)((Object)call)));
        }
        this.replicateCall(ctx, call, synchronous, ctx.getOptionOverrides());
    }

    protected DataVersion getNodeVersion(TransactionWorkspace w, Fqn f) {
        if (w == null) {
            return null;
        }
        WorkspaceNode wn = w.getNode(f);
        DataVersion v = wn.getVersion();
        if (wn.isVersioningImplicit()) {
            v = ((DefaultDataVersion)v).increment();
        }
        return v;
    }

    protected void invalidateModifications(List<MethodCall> modifications, TransactionWorkspace workspace, InvocationContext ctx) throws Throwable {
        this.invalidateModifications(modifications, workspace, this.defaultSynchronous, ctx);
    }

    protected void invalidateModifications(List<MethodCall> modifications, TransactionWorkspace workspace, boolean synchronous, InvocationContext ctx) throws Throwable {
        Set<Fqn> modifiedFqns = this.optimisedIterator(modifications);
        for (Fqn fqn : modifiedFqns) {
            this.invalidateAcrossCluster(fqn, workspace, synchronous, ctx);
        }
    }

    protected TransactionWorkspace getWorkspace(GlobalTransaction gtx) {
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)this.txTable.get(gtx);
        return entry.getTransactionWorkSpace();
    }

    @Deprecated
    protected void findAndAddFqns(Object[] objects, Set<Fqn> fqns, boolean isMove) {
        if (isMove) {
            Fqn f = (Fqn)objects[0];
            fqns.add(f);
            Object le = f.getLastElement();
            Fqn parent = (Fqn)objects[1];
            fqns.add(new Fqn<Object>(parent, le));
        } else {
            fqns.add((Fqn)objects[1]);
        }
    }

    protected Set<Fqn> optimisedIterator(List<MethodCall> list) {
        HashSet<Fqn> fqns = new HashSet<Fqn>();
        if (list != null) {
            for (MethodCall mc : list) {
                if (!MethodDeclarations.isCrudMethod(mc.getMethodId())) continue;
                this.findAndAddFqns(mc.getArgs(), fqns, 36 == mc.getMethodId());
            }
        }
        return fqns;
    }
}

