/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.util.concurrent.ConcurrentHashSet;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticReplicationInterceptor
extends BaseRpcInterceptor {
    private final Set<GlobalTransaction> broadcastTxs = new ConcurrentHashSet<GlobalTransaction>();

    public OptimisticReplicationInterceptor() {
        this.initLogger();
    }

    @Override
    protected boolean skipMethodCall(InvocationContext ctx) {
        if (MethodDeclarations.isBuddyGroupOrganisationMethod(ctx.getMethodCall().getMethodId())) {
            return true;
        }
        Option optionOverride = ctx.getOptionOverrides();
        if (optionOverride != null && optionOverride.isCacheModeLocal() && ctx.getTransaction() == null) {
            this.log.debug((Object)"Skipping replication for this call as cache mode is local, forced via an option override.");
            return true;
        }
        return false;
    }

    @Override
    protected Object handleOptimisticPrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modifications, Map data, Address address, boolean onePhaseCommit) throws Throwable {
        Object retval = this.nextInterceptor(ctx);
        gtx = this.getGlobalTransaction(ctx);
        if (!gtx.isRemote() && ctx.isOriginLocal()) {
            this.broadcastPrepare(ctx.getMethodCall(), gtx, ctx);
        }
        return retval;
    }

    @Override
    protected Object handleCommitMethod(InvocationContext ctx, GlobalTransaction gtx) throws Throwable {
        Throwable remoteCommitException = null;
        gtx = this.getGlobalTransaction(ctx);
        if (!gtx.isRemote() && ctx.isOriginLocal() && this.broadcastTxs.contains(gtx)) {
            try {
                this.broadcastCommit(gtx, ctx);
            }
            catch (Throwable t) {
                this.log.error((Object)"A problem occurred with remote commit", t);
                remoteCommitException = t;
            }
        }
        Object retval = this.nextInterceptor(ctx);
        if (remoteCommitException != null) {
            throw remoteCommitException;
        }
        return retval;
    }

    @Override
    protected Object handleRollbackMethod(InvocationContext ctx, GlobalTransaction gtx) throws Throwable {
        gtx = this.getGlobalTransaction(ctx);
        Throwable remoteRollbackException = null;
        if (!gtx.isRemote() && ctx.isOriginLocal() && this.broadcastTxs.contains(gtx)) {
            try {
                this.broadcastRollback(gtx, ctx);
            }
            catch (Throwable t) {
                this.log.error((Object)" a problem occurred with remote rollback", t);
                remoteRollbackException = t;
            }
        }
        Object retval = this.nextInterceptor(ctx);
        if (remoteRollbackException != null) {
            throw remoteRollbackException;
        }
        return retval;
    }

    @Override
    protected Object handlePutForExternalReadVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, DataVersion dv) throws Throwable {
        return this.handlePutForExternalReadMethod(ctx, gtx, fqn, key, value);
    }

    @Override
    protected Object handlePutForExternalReadMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value) throws Throwable {
        gtx = this.getGlobalTransaction(ctx);
        this.cache.getTransactionTable().get(gtx).setForceAsyncReplication(true);
        return this.nextInterceptor(ctx);
    }

    private GlobalTransaction getGlobalTransaction(InvocationContext ctx) {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (gtx == null) {
            throw new CacheException("failed to get global transaction");
        }
        return gtx;
    }

    protected void broadcastPrepare(MethodCall methodCall, GlobalTransaction gtx, InvocationContext ctx) throws Throwable {
        int num_mods;
        boolean remoteCallSync = this.configuration.getCacheMode() == Configuration.CacheMode.REPL_SYNC;
        Object[] args = methodCall.getArgs();
        List modifications = (List)args[1];
        int n = num_mods = modifications != null ? modifications.size() : 0;
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            MethodCall toBroadcast = this.mapDataVersionedMethodCalls(methodCall, this.getTransactionWorkspace(gtx));
            this.broadcastTxs.add(gtx);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("(" + this.cache.getLocalAddress() + "): broadcasting prepare for " + gtx + " (" + num_mods + " modifications"));
            }
            this.replicateCall(ctx, toBroadcast, remoteCallSync, ctx.getOptionOverrides());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("(" + this.cache.getLocalAddress() + "):not broadcasting prepare as members are " + this.cache.getMembers()));
        }
    }

    protected void broadcastCommit(GlobalTransaction gtx, InvocationContext ctx) throws Throwable {
        boolean remoteCallSync = this.configuration.isSyncCommitPhase();
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                MethodCall commit_method = MethodCallFactory.create(11, gtx);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("running remote commit for " + gtx + " and coord=" + this.cache.getLocalAddress()));
                }
                this.replicateCall(ctx, commit_method, remoteCallSync, ctx.getOptionOverrides());
            }
            catch (Exception e) {
                this.log.error((Object)"Commit failed", (Throwable)e);
                throw e;
            }
        }
    }

    protected void broadcastRollback(GlobalTransaction gtx, InvocationContext ctx) throws Throwable {
        boolean remoteCallSync = this.configuration.isSyncRollbackPhase();
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                MethodCall rollback_method = MethodCallFactory.create(12, gtx);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("running remote rollback for " + gtx + " and coord=" + this.cache.getLocalAddress()));
                }
                this.replicateCall(ctx, rollback_method, remoteCallSync, ctx.getOptionOverrides());
            }
            catch (Exception e) {
                this.log.error((Object)"Rollback failed", (Throwable)e);
                throw e;
            }
        }
    }

    private MethodCall mapDataVersionedMethodCalls(MethodCall m, TransactionWorkspace w) {
        Object[] origArgs = m.getArgs();
        return MethodCallFactory.create(m.getMethodId(), origArgs[0], this.translate((List)origArgs[1], w), origArgs[2], origArgs[3], origArgs[4]);
    }

    private List<MethodCall> translate(List<MethodCall> l, TransactionWorkspace w) {
        ArrayList<MethodCall> newList = new ArrayList<MethodCall>();
        for (MethodCall origCall : l) {
            if (MethodDeclarations.isDataGravitationMethod(origCall.getMethodId())) {
                newList.add(origCall);
                continue;
            }
            Object[] origArgs = origCall.getArgs();
            Fqn fqn = (Fqn)origArgs[origCall.getMethodId() == 36 ? 0 : 1];
            DataVersion versionToBroadcast = this.getVersionToBroadcast(w, fqn);
            Object[] newArgs = new Object[origArgs.length + 1];
            System.arraycopy(origArgs, 0, newArgs, 0, origArgs.length);
            newArgs[origArgs.length] = versionToBroadcast;
            MethodCall newCall = MethodCallFactory.create(MethodDeclarations.getVersionedMethodId(origCall.getMethodId()), newArgs);
            newList.add(newCall);
        }
        return newList;
    }

    private DataVersion getVersionToBroadcast(TransactionWorkspace w, Fqn f) {
        WorkspaceNode n = w.getNode(f);
        if (n == null) {
            if (this.trace) {
                this.log.trace((Object)("Fqn " + f + " not found in workspace; not using a data version."));
            }
            return null;
        }
        if (n.isVersioningImplicit()) {
            DefaultDataVersion v = (DefaultDataVersion)n.getVersion();
            if (this.trace) {
                this.log.trace((Object)("Fqn " + f + " has implicit versioning.  Broadcasting an incremented version."));
            }
            return v.increment();
        }
        if (this.trace) {
            this.log.trace((Object)("Fqn " + f + " has explicit versioning.  Broadcasting the version as-is."));
        }
        return n.getVersion();
    }

    protected TransactionWorkspace getTransactionWorkspace(GlobalTransaction gtx) throws CacheException {
        OptimisticTransactionEntry transactionEntry = (OptimisticTransactionEntry)this.cache.getTransactionTable().get(gtx);
        if (transactionEntry == null) {
            throw new CacheException("unable to map global transaction " + gtx + " to transaction entry");
        }
        return transactionEntry.getTransactionWorkSpace();
    }
}

