/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.factories.annotations.ComponentName;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.lock.NodeLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnlockInterceptor
extends Interceptor {
    Map<Thread, List<NodeLock>> lockTable = null;

    public UnlockInterceptor() {
        this.initLogger();
    }

    @Inject
    private void injectDependencies(@ComponentName(value="LockTable") Map<Thread, List<NodeLock>> lockTable) {
        this.lockTable = lockTable;
    }

    @Override
    public Object invoke(InvocationContext ctx) throws Throwable {
        Transaction tx2;
        Object object;
        try {
            object = this.nextInterceptor(ctx);
            Object var4_4 = null;
        }
        catch (Throwable th) {
            try {
                throw th;
            }
            catch (Throwable throwable) {
                block9: {
                    Transaction tx2;
                    Object var4_5 = null;
                    if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSuppressLocking() || (tx2 = ctx.getTransaction()) != null && this.isValid(tx2)) break block9;
                    Thread currentThread = Thread.currentThread();
                    List<NodeLock> locks = this.lockTable.get(currentThread);
                    if (this.trace) {
                        this.log.trace((Object)("Attempting to release locks on current thread.  Lock table is " + this.lockTable));
                    }
                    if (locks != null && locks.size() > 0) {
                        this.releaseLocks(locks, currentThread);
                        this.lockTable.remove(currentThread);
                    }
                }
                throw throwable;
            }
        }
        if (!(ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSuppressLocking() || (tx2 = ctx.getTransaction()) != null && this.isValid(tx2))) {
            Thread currentThread = Thread.currentThread();
            List<NodeLock> locks = this.lockTable.get(currentThread);
            if (this.trace) {
                this.log.trace((Object)("Attempting to release locks on current thread.  Lock table is " + this.lockTable));
            }
            if (locks != null && locks.size() > 0) {
                this.releaseLocks(locks, currentThread);
                this.lockTable.remove(currentThread);
            }
        }
        return object;
    }

    private void releaseLocks(List<NodeLock> locks, Thread currentThread) {
        NodeLock[] locksArray = locks.toArray(new NodeLock[0]);
        for (int i = locksArray.length - 1; i > -1; --i) {
            if (this.trace) {
                this.log.trace((Object)("releasing lock for " + locksArray[i].getFqn() + ": " + locksArray[i]));
            }
            locksArray[i].release(currentThread);
        }
    }
}

