package org.jboss.cache.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups = {"functional"})
public class RecursiveRefTest 
{
   private static final String CONFIG_FILENAME = "META-INF/local-service.xml";
   private PojoCache cache;
   Log log = LogFactory.getLog(RecursiveRefTest.class);

   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      log.info("setUp() ....");
      boolean toStart = false;
      cache = PojoCacheFactory.createCache(CONFIG_FILENAME, toStart);
      cache.start();
      cache.attach("/aop/test", new HashMap<Object, Object>());
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
   }

   @SuppressWarnings("unchecked")
   public void testRecursiveList() throws Exception
   {
      ArrayList list = new ArrayList();
      list.add("1");
      cache.attach("list", list);
      list = (ArrayList) cache.find("list");
      list.add(list);
      System.out.println(list.toString());
   }

   @SuppressWarnings("unchecked")
   public void testRecursiveSet() throws Exception
   {
      HashSet set = new HashSet();
      set.add("1");
      cache.attach("set", set);
      set = (HashSet) cache.find("set");
      set.add(set);
      System.out.println(set.toString());
   }

   @SuppressWarnings("unchecked")
   public void testRecursiveMap() throws Exception
   {
      HashMap map = new HashMap();
      map.put("1", "1");
      cache.attach("map", map);
      map = (HashMap) cache.find("map");
      map.put("2", map);
      System.out.println(map.toString());
   }

} // class TestRunner


