/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.ComponentFactory;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.DefaultFactoryFor;
import org.jboss.cache.interceptors.ActivationInterceptor;
import org.jboss.cache.interceptors.CacheLoaderInterceptor;
import org.jboss.cache.interceptors.CacheMgmtInterceptor;
import org.jboss.cache.interceptors.CacheStoreInterceptor;
import org.jboss.cache.interceptors.CallInterceptor;
import org.jboss.cache.interceptors.DataGravitatorInterceptor;
import org.jboss.cache.interceptors.EvictionInterceptor;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.InvalidationInterceptor;
import org.jboss.cache.interceptors.InvocationContextInterceptor;
import org.jboss.cache.interceptors.NotificationInterceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticLockingInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.OptimisticReplicationInterceptor;
import org.jboss.cache.interceptors.OptimisticValidatorInterceptor;
import org.jboss.cache.interceptors.PassivationInterceptor;
import org.jboss.cache.interceptors.PessimisticLockInterceptor;
import org.jboss.cache.interceptors.ReplicationInterceptor;
import org.jboss.cache.interceptors.TxInterceptor;
import org.jboss.cache.interceptors.UnlockInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultFactoryFor(classes={Interceptor.class})
public class InterceptorChainFactory
extends ComponentFactory {
    @Deprecated
    public static InterceptorChainFactory getInstance() {
        return new InterceptorChainFactory();
    }

    public Interceptor buildInterceptorChain() throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        if (this.configuration.isNodeLockingOptimistic()) {
            return this.createOptimisticInterceptorChain();
        }
        return this.createPessimisticInterceptorChain();
    }

    public static Interceptor setLastInterceptorPointer(Interceptor first, Interceptor last) {
        for (Interceptor i = first; i != null; i = i.getNext()) {
            i.setLast(last);
        }
        return first;
    }

    private Interceptor createInterceptor(Class<? extends Interceptor> clazz) throws IllegalAccessException, InstantiationException {
        Interceptor i = this.componentRegistry.getComponent(clazz.getName(), clazz);
        if (i == null) {
            i = clazz.newInstance();
            this.componentRegistry.registerComponent(clazz.getName(), i, clazz);
        } else {
            i.setLast(null);
            i.setNext(null);
        }
        return i;
    }

    private void addInterceptor(Interceptor first, Interceptor i) {
        if (first == null) {
            return;
        }
        while (first.getNext() != null) {
            first = first.getNext();
        }
        first.setNext(i);
    }

    private Interceptor createPessimisticInterceptorChain() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Interceptor repl_interceptor = null;
        Interceptor cache_loader_interceptor = null;
        Interceptor cache_store_interceptor = null;
        Interceptor passivation_interceptor = null;
        Interceptor activation_interceptor = null;
        Interceptor dataGravitatorInterceptor = null;
        Interceptor invocationCtxInterceptor = this.createInterceptor(InvocationContextInterceptor.class);
        Interceptor notificationInterceptor = this.createInterceptor(NotificationInterceptor.class);
        Interceptor first = null;
        Interceptor call_interceptor = this.createInterceptor(CallInterceptor.class);
        if (this.isUsingBuddyReplication()) {
            dataGravitatorInterceptor = this.createInterceptor(DataGravitatorInterceptor.class);
        }
        Interceptor lock_interceptor = this.createInterceptor(PessimisticLockInterceptor.class);
        Interceptor unlock_interceptor = this.createInterceptor(UnlockInterceptor.class);
        Interceptor cacheMgmtInterceptor = this.createInterceptor(CacheMgmtInterceptor.class);
        Interceptor txInterceptor = this.createInterceptor(TxInterceptor.class);
        switch (this.configuration.getCacheMode()) {
            case REPL_SYNC: 
            case REPL_ASYNC: {
                repl_interceptor = this.createInterceptor(ReplicationInterceptor.class);
                break;
            }
            case INVALIDATION_SYNC: 
            case INVALIDATION_ASYNC: {
                repl_interceptor = this.createInterceptor(InvalidationInterceptor.class);
                break;
            }
        }
        if (this.isUsingCacheLoaders()) {
            if (this.configuration.getCacheLoaderConfig().isPassivation()) {
                activation_interceptor = this.createInterceptor(ActivationInterceptor.class);
                passivation_interceptor = this.createInterceptor(PassivationInterceptor.class);
            } else {
                cache_loader_interceptor = this.createInterceptor(CacheLoaderInterceptor.class);
                cache_store_interceptor = this.createInterceptor(CacheStoreInterceptor.class);
            }
        }
        if (first == null) {
            first = invocationCtxInterceptor;
        }
        if (this.configuration.getExposeManagementStatistics()) {
            if (first == null) {
                first = cacheMgmtInterceptor;
            } else {
                this.addInterceptor(first, cacheMgmtInterceptor);
            }
        }
        if (first == null) {
            first = txInterceptor;
        } else {
            this.addInterceptor(first, txInterceptor);
        }
        if (first == null) {
            first = notificationInterceptor;
        } else {
            this.addInterceptor(first, notificationInterceptor);
        }
        if (repl_interceptor != null) {
            if (first == null) {
                first = repl_interceptor;
            } else {
                this.addInterceptor(first, repl_interceptor);
            }
        }
        if (first == null) {
            first = lock_interceptor;
        } else {
            this.addInterceptor(first, lock_interceptor);
        }
        if (unlock_interceptor != null) {
            if (first == null) {
                first = unlock_interceptor;
            } else {
                this.addInterceptor(first, unlock_interceptor);
            }
        }
        if (activation_interceptor != null) {
            if (first == null) {
                first = activation_interceptor;
            } else {
                this.addInterceptor(first, activation_interceptor);
            }
            if (first == null) {
                first = passivation_interceptor;
            } else {
                this.addInterceptor(first, passivation_interceptor);
            }
        }
        if (cache_loader_interceptor != null) {
            if (first == null) {
                first = cache_loader_interceptor;
            } else {
                this.addInterceptor(first, cache_loader_interceptor);
            }
            if (first == null) {
                first = cache_store_interceptor;
            } else {
                this.addInterceptor(first, cache_store_interceptor);
            }
        }
        if (dataGravitatorInterceptor != null) {
            if (first == null) {
                first = dataGravitatorInterceptor;
            } else {
                this.addInterceptor(first, dataGravitatorInterceptor);
            }
        }
        if (this.configuration.getEvictionConfig() != null && this.configuration.getEvictionConfig().isValidConfig()) {
            Interceptor eviction_interceptor = this.createInterceptor(EvictionInterceptor.class);
            if (first == null) {
                first = eviction_interceptor;
            } else {
                this.addInterceptor(first, eviction_interceptor);
            }
        }
        if (first == null) {
            first = call_interceptor;
        } else {
            this.addInterceptor(first, call_interceptor);
        }
        return InterceptorChainFactory.setLastInterceptorPointer(first, call_interceptor);
    }

    private boolean isUsingCacheLoaders() {
        return this.configuration.getCacheLoaderConfig() != null && !this.configuration.getCacheLoaderConfig().getIndividualCacheLoaderConfigs().isEmpty();
    }

    private boolean isUsingBuddyReplication() {
        return this.configuration.getBuddyReplicationConfig() != null && this.configuration.getBuddyReplicationConfig().isEnabled();
    }

    private Interceptor createOptimisticInterceptorChain() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Interceptor replicationInterceptor = null;
        Interceptor activationInterceptor = null;
        Interceptor passivationInterceptor = null;
        Interceptor cacheLoaderInterceptor = null;
        Interceptor cacheStoreInterceptor = null;
        Interceptor first = null;
        Interceptor evictionInterceptor = null;
        Interceptor dataGravitatorInterceptor = null;
        Interceptor invocationCtxInterceptor = this.createInterceptor(InvocationContextInterceptor.class);
        Interceptor notificationInterceptor = this.createInterceptor(NotificationInterceptor.class);
        if (this.isUsingCacheLoaders()) {
            if (this.configuration.getCacheLoaderConfig().isPassivation()) {
                activationInterceptor = this.createInterceptor(ActivationInterceptor.class);
                passivationInterceptor = this.createInterceptor(PassivationInterceptor.class);
            } else {
                cacheLoaderInterceptor = this.createInterceptor(CacheLoaderInterceptor.class);
                cacheStoreInterceptor = this.createInterceptor(CacheStoreInterceptor.class);
            }
        }
        Interceptor txInterceptor = this.createInterceptor(TxInterceptor.class);
        if (this.isUsingBuddyReplication()) {
            dataGravitatorInterceptor = this.createInterceptor(DataGravitatorInterceptor.class);
        }
        switch (this.configuration.getCacheMode()) {
            case REPL_SYNC: 
            case REPL_ASYNC: {
                replicationInterceptor = this.createInterceptor(OptimisticReplicationInterceptor.class);
                break;
            }
            case INVALIDATION_SYNC: 
            case INVALIDATION_ASYNC: {
                replicationInterceptor = this.createInterceptor(InvalidationInterceptor.class);
                break;
            }
        }
        Interceptor lockInterceptor = this.createInterceptor(OptimisticLockingInterceptor.class);
        Interceptor validationInterceptor = this.createInterceptor(OptimisticValidatorInterceptor.class);
        Interceptor createIfNotExistsInterceptor = this.createInterceptor(OptimisticCreateIfNotExistsInterceptor.class);
        Interceptor nodeInterceptor = this.createInterceptor(OptimisticNodeInterceptor.class);
        Interceptor invokerInterceptor = this.createInterceptor(CallInterceptor.class);
        if (this.configuration.getEvictionConfig() != null && this.configuration.getEvictionConfig().isValidConfig()) {
            evictionInterceptor = this.createInterceptor(EvictionInterceptor.class);
        }
        if (first == null) {
            first = invocationCtxInterceptor;
        }
        if (this.configuration.getExposeManagementStatistics()) {
            Interceptor cacheMgmtInterceptor = this.createInterceptor(CacheMgmtInterceptor.class);
            if (first == null) {
                first = cacheMgmtInterceptor;
            } else {
                this.addInterceptor(first, cacheMgmtInterceptor);
            }
        }
        if (txInterceptor != null) {
            if (first == null) {
                first = txInterceptor;
            } else {
                this.addInterceptor(first, txInterceptor);
            }
        }
        if (first == null) {
            first = notificationInterceptor;
        } else {
            this.addInterceptor(first, notificationInterceptor);
        }
        if (first == null) {
            first = replicationInterceptor;
        } else {
            this.addInterceptor(first, replicationInterceptor);
        }
        if (passivationInterceptor != null && !this.configuration.getCacheLoaderConfig().isFetchPersistentState()) {
            if (first == null) {
                first = passivationInterceptor;
            } else {
                this.addInterceptor(first, passivationInterceptor);
            }
        }
        if (cacheStoreInterceptor != null && !this.configuration.getCacheLoaderConfig().isFetchPersistentState()) {
            if (first == null) {
                first = cacheStoreInterceptor;
            } else {
                this.addInterceptor(first, cacheStoreInterceptor);
            }
        }
        if (activationInterceptor != null) {
            if (first == null) {
                first = activationInterceptor;
            } else {
                this.addInterceptor(first, activationInterceptor);
            }
            if (this.configuration.getCacheLoaderConfig().isFetchPersistentState()) {
                if (first == null) {
                    first = passivationInterceptor;
                } else {
                    this.addInterceptor(first, passivationInterceptor);
                }
            }
        }
        if (cacheLoaderInterceptor != null) {
            if (first == null) {
                first = cacheLoaderInterceptor;
            } else {
                this.addInterceptor(first, cacheLoaderInterceptor);
            }
            if (this.configuration.getCacheLoaderConfig().isFetchPersistentState()) {
                if (first == null) {
                    first = cacheStoreInterceptor;
                } else {
                    this.addInterceptor(first, cacheStoreInterceptor);
                }
            }
        }
        if (dataGravitatorInterceptor != null) {
            if (first == null) {
                first = dataGravitatorInterceptor;
            } else {
                this.addInterceptor(first, dataGravitatorInterceptor);
            }
        }
        if (first == null) {
            first = lockInterceptor;
        } else {
            this.addInterceptor(first, lockInterceptor);
        }
        if (first == null) {
            first = validationInterceptor;
        } else {
            this.addInterceptor(first, validationInterceptor);
        }
        if (first == null) {
            first = createIfNotExistsInterceptor;
        } else {
            this.addInterceptor(first, createIfNotExistsInterceptor);
        }
        if (first == null) {
            first = evictionInterceptor;
        } else {
            this.addInterceptor(first, evictionInterceptor);
        }
        if (first == null) {
            first = nodeInterceptor;
        } else {
            this.addInterceptor(first, nodeInterceptor);
        }
        if (first == null) {
            first = invokerInterceptor;
        } else {
            this.addInterceptor(first, invokerInterceptor);
        }
        return InterceptorChainFactory.setLastInterceptorPointer(first, invokerInterceptor);
    }

    public static List<Interceptor> asList(Interceptor interceptor) {
        if (interceptor == null) {
            return null;
        }
        int num = 1;
        Interceptor tmp = interceptor;
        while ((tmp = tmp.getNext()) != null) {
            ++num;
        }
        ArrayList<Interceptor> retval = new ArrayList<Interceptor>(num);
        tmp = interceptor;
        num = 0;
        do {
            retval.add(tmp);
        } while ((tmp = tmp.getNext()) != null);
        return retval;
    }

    public Interceptor correctInterceptorChaining(Interceptor first) {
        return this.correctInterceptorChaining(InterceptorChainFactory.asList(first));
    }

    public Interceptor correctInterceptorChaining(List<Interceptor> interceptors) {
        Interceptor first = null;
        Interceptor last = null;
        for (Interceptor next : interceptors) {
            if (first == null) {
                first = last = next;
                continue;
            }
            last.setNext(next);
            last = next;
        }
        if (last != null) {
            last.setNext(null);
        }
        Interceptor i = InterceptorChainFactory.setLastInterceptorPointer(first, last);
        this.componentRegistry.registerComponent(Interceptor.class.getName(), i, Interceptor.class);
        return i;
    }

    @Override
    protected <T> T construct(String componentName, Class<T> componentType) {
        try {
            return (T)this.buildInterceptorChain();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to build interceptor chain", e);
        }
    }

    public static InterceptorChainFactory getInstance(ComponentRegistry componentRegistry, Configuration configuration) {
        InterceptorChainFactory icf = new InterceptorChainFactory();
        icf.componentRegistry = componentRegistry;
        icf.configuration = configuration;
        return icf;
    }
}

