/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.Iterator;
import javax.transaction.Status;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionTable;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LockUtil {
    private static final Log log = LogFactory.getLog(StateTransferManager.class);

    public static boolean breakTransactionLock(NodeLock lock, GlobalTransaction gtx, boolean localTx, CacheImpl cache) {
        TransactionTable tx_table = cache.getTransactionTable();
        TransactionManager tm = cache.getTransactionManager();
        boolean broken = false;
        int tryCount = 0;
        int lastStatus = Integer.MIN_VALUE;
        while (!broken && lock.isOwner(gtx)) {
            int status = LockUtil.breakTransactionLock(gtx, lock, tx_table, tm, localTx, lastStatus, tryCount);
            if (status == Integer.MIN_VALUE) {
                broken = true;
            } else if (status != lastStatus) {
                tryCount = 0;
            }
            lastStatus = status;
            ++tryCount;
        }
        return broken;
    }

    public static void forceAcquireLock(NodeSPI<?, ?> node, Object newOwner, CacheImpl cache, boolean lockChildren) {
        boolean serializable;
        NodeLock lock = node.getLock();
        boolean acquired = lock.isOwner(newOwner);
        if (!acquired && log.isDebugEnabled()) {
            log.debug((Object)("Force acquiring lock on node " + node.getFqn()));
        }
        TransactionTable tx_table = cache.getTransactionTable();
        TransactionManager tm = cache.getTransactionManager();
        Address localAddress = cache.getLocalAddress();
        boolean bl = serializable = cache.getConfiguration().getIsolationLevel() == IsolationLevel.SERIALIZABLE;
        while (!acquired) {
            Iterator<Object> it;
            Object curOwner = null;
            boolean attempted = false;
            while (!acquired && (curOwner = lock.getWriterOwner()) != null) {
                acquired = LockUtil.acquireLockFromOwner(node, lock, curOwner, newOwner, tx_table, tm, localAddress);
                attempted = true;
            }
            if (!acquired && serializable && (it = lock.getReaderOwners().iterator()).hasNext()) {
                curOwner = it.next();
                acquired = LockUtil.acquireLockFromOwner(node, lock, curOwner, newOwner, tx_table, tm, localAddress);
                attempted = true;
            }
            if (acquired || attempted) continue;
            try {
                acquired = lock.acquire(newOwner, 1L, NodeLock.LockType.READ);
            }
            catch (Exception ignored) {}
        }
        if (lockChildren) {
            for (NodeSPI<?, ?> n : node.getChildrenDirect()) {
                LockUtil.forceAcquireLock(n, newOwner, cache, true);
            }
        }
    }

    private static boolean acquireLockFromOwner(Node node, NodeLock lock, Object curOwner, Object newOwner, TransactionTable tx_table, TransactionManager tm, Object localAddress) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Attempting to acquire lock for node " + node.getFqn() + " from owner " + curOwner));
        }
        boolean acquired = false;
        boolean broken = false;
        int tryCount = 0;
        int lastStatus = Integer.MIN_VALUE;
        while (!broken && !acquired) {
            if (curOwner instanceof GlobalTransaction) {
                GlobalTransaction gtx = (GlobalTransaction)curOwner;
                boolean local = gtx.getAddress().equals(localAddress);
                int status = LockUtil.breakTransactionLock(gtx, lock, tx_table, tm, local, lastStatus, tryCount);
                if (status == Integer.MIN_VALUE) {
                    broken = true;
                } else if (status != lastStatus) {
                    tryCount = 0;
                }
                lastStatus = status;
            } else if (tryCount > 0) {
                lock.release(curOwner);
                broken = true;
            }
            if (broken && log.isTraceEnabled()) {
                log.trace((Object)("Broke lock for node " + node.getFqn() + " held by owner " + curOwner));
            }
            try {
                acquired = lock.acquire(newOwner, 1L, NodeLock.LockType.READ);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            ++tryCount;
        }
        return acquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int breakTransactionLock(GlobalTransaction gtx, NodeLock lock, TransactionTable tx_table, TransactionManager tm, boolean localTx, int lastStatus, int tryCount) {
        int status = 5;
        Transaction tx = tx_table.getLocalTransaction(gtx);
        if (tx != null) {
            try {
                status = tx.getStatus();
                if (status != lastStatus) {
                    tryCount = 0;
                }
                switch (status) {
                    case 0: 
                    case 1: 
                    case 5: 
                    case 7: {
                        if (tryCount == 0) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Attempting to break transaction lock held  by " + gtx + " by rolling back local tx"));
                            }
                            tm.resume(tx);
                            try {
                                tx.rollback();
                                break;
                            }
                            finally {
                                tm.suspend();
                            }
                        }
                        if (tryCount > 100) {
                            lock.release(gtx);
                            status = Integer.MIN_VALUE;
                        }
                        break;
                    }
                    case 8: 
                    case 9: {
                        if (tryCount < 10) break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        lock.release(gtx);
                        status = Integer.MIN_VALUE;
                        break;
                    }
                    case 2: {
                        if (tryCount == 0 && localTx) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Attempting to break transaction lock held by " + gtx + " by marking local tx as " + "rollback-only"));
                            }
                            tx.setRollbackOnly();
                            break;
                        }
                        if (tryCount < 10) break;
                    }
                    default: {
                        lock.release(gtx);
                        status = Integer.MIN_VALUE;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Exception breaking locks held by " + gtx), (Throwable)e);
                lock.release(gtx);
                status = Integer.MIN_VALUE;
            }
        } else if (gtx == lock.getWriterOwner() || lock.getReaderOwners().contains(gtx)) {
            lock.release(gtx);
            status = Integer.MIN_VALUE;
        }
        return status;
    }

    private static interface TransactionLockStatus
    extends Status {
        public static final int STATUS_BROKEN = Integer.MIN_VALUE;
    }
}

