/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.ComponentName;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.ObjectSerializationFactory;
import org.jboss.cache.transaction.GlobalTransaction;

public abstract class AbstractMarshaller
implements Marshaller {
    protected boolean useRegionBasedMarshalling;
    protected RegionManager regionManager;
    protected boolean defaultInactive;
    protected Log log;
    protected boolean trace;
    private Map<GlobalTransaction, Fqn> transactions = new ConcurrentHashMap<GlobalTransaction, Fqn>(16);
    protected Configuration configuration;
    protected ClassLoader defaultClassLoader;

    @Inject
    void injectDependencies(RegionManager regionManager, Configuration configuration, @ComponentName(value="deployerClassLoader") ClassLoader defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
        this.regionManager = regionManager;
        this.configuration = configuration;
    }

    @Start
    protected void init() {
        this.useRegionBasedMarshalling = this.configuration.isUseRegionBasedMarshalling();
        this.defaultInactive = this.configuration.isInactiveOnStartup();
    }

    protected void initLogger() {
        this.log = LogFactory.getLog(this.getClass());
        this.trace = this.log.isTraceEnabled();
    }

    public byte[] objectToByteBuffer(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = ObjectSerializationFactory.createObjectOutputStream(baos);
        this.objectToObjectStream(obj, out);
        out.close();
        return baos.toByteArray();
    }

    public Object objectFromByteBuffer(byte[] bytes) throws Exception {
        ObjectInputStream in = ObjectSerializationFactory.createObjectInputStream(bytes);
        return this.objectFromObjectStream(in);
    }

    public Object objectFromStream(InputStream in) throws Exception {
        if (in instanceof ObjectInputStream) {
            return this.objectFromObjectStream((ObjectInputStream)in);
        }
        return this.objectFromObjectStream(ObjectSerializationFactory.createObjectInputStream(in));
    }

    protected Fqn extractFqnFromMethodCall(MethodCall call) {
        MethodCall c0 = (MethodCall)((Object)call.getArgs()[0]);
        return this.extractFqn(c0);
    }

    protected Fqn extractFqnFromListOfMethodCall(MethodCall call) {
        Object[] args = call.getArgs();
        MethodCall c0 = (MethodCall)((Object)((List)args[0]).get(0));
        return this.extractFqn(c0);
    }

    protected Fqn extractFqn(MethodCall methodCall) {
        if (methodCall == null) {
            throw new NullPointerException("method call is null");
        }
        Fqn fqn = null;
        Object[] args = methodCall.getArgs();
        switch (methodCall.getMethodId()) {
            case 10: 
            case 18: {
                List modifications = (List)args[1];
                fqn = this.extractFqn((MethodCall)((Object)modifications.get(0)));
                boolean one_phase_commit = (Boolean)args[args.length - 1];
                if (one_phase_commit) break;
                this.transactions.put((GlobalTransaction)args[0], fqn);
                break;
            }
            case 11: 
            case 12: {
                fqn = this.transactions.remove(args[0]);
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 35: 
            case 47: {
                fqn = (Fqn)args[0];
                break;
            }
            case 34: {
                fqn = (Fqn)args[1];
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 13: 
            case 22: {
                fqn = this.extractFqn((MethodCall)((Object)args[0]));
                break;
            }
            default: {
                if (MethodDeclarations.isCrudMethod(methodCall.getMethodId())) {
                    fqn = (Fqn)args[1];
                    break;
                }
                throw new IllegalArgumentException("AbstractMarshaller.extractFqn(): Unknown id in method call: " + (Object)((Object)methodCall));
            }
        }
        if (this.trace) {
            this.log.trace((Object)("extract(): received " + (Object)((Object)methodCall) + "extracted fqn: " + fqn));
        }
        return fqn;
    }

    protected Region getRegion(Fqn fqn) {
        if (fqn == null) {
            return null;
        }
        if (BuddyManager.isBackupFqn(fqn)) {
            fqn = BuddyManager.getActualFqn(fqn);
        }
        Region r = this.regionManager.getRegion(fqn, Region.Type.MARSHALLING, false);
        return r;
    }
}

