/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.invocation.RemoteCacheInvocationDelegate;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.util.BitEncodedIntegerSet;
import org.jgroups.Address;

public class MethodDeclarations {
    private static Log log = LogFactory.getLog(MethodDeclarations.class);
    static final BitEncodedIntegerSet crudMethodIds = new BitEncodedIntegerSet();
    static final BitEncodedIntegerSet transactionLifecycleMethodIds = new BitEncodedIntegerSet();
    static final BitEncodedIntegerSet buddyGroupOrganisationMethodIds = new BitEncodedIntegerSet();
    static final BitEncodedIntegerSet blockUnblockMethodIds = new BitEncodedIntegerSet();
    static final BitEncodedIntegerSet putMethodIds = new BitEncodedIntegerSet();
    static final BitEncodedIntegerSet methodsThatNeedToReturnValuesToRemoteCallers = new BitEncodedIntegerSet();
    static final Method[] methods = new Method[48];
    static final Map<Method, Integer> methodIds = new HashMap<Method, Integer>();
    public static final Method putDataMethodLocal;
    public static final Method putDataEraseMethodLocal;
    public static final Method putKeyValMethodLocal;
    public static final Method removeNodeMethodLocal;
    public static final Method removeKeyMethodLocal;
    public static final Method removeDataMethodLocal;
    public static final Method evictNodeMethodLocal;
    public static final Method evictVersionedNodeMethodLocal;
    public static final Method prepareMethod;
    public static final Method commitMethod;
    public static final Method rollbackMethod;
    public static final Method replicateMethod;
    public static final Method replicateAllMethod;
    public static final Method addChildMethodLocal;
    public static final Method getKeyValueMethodLocal;
    public static final Method getNodeMethodLocal;
    public static final Method getKeysMethodLocal;
    public static final Method getChildrenNamesMethodLocal;
    public static final Method getDataMapMethodLocal;
    public static final Method existsMethod;
    public static final Method releaseAllLocksMethodLocal;
    public static final Method printMethodLocal;
    public static final Method lockMethodLocal;
    public static final Method optimisticPrepareMethod;
    public static final Method clusteredGetMethod;
    public static final Method remoteAssignToBuddyGroupMethod;
    public static final Method remoteRemoveFromBuddyGroupMethod;
    public static final Method remoteAnnounceBuddyPoolNameMethod;
    public static final Method dataGravitationCleanupMethod;
    public static final Method dataGravitationMethod;
    public static final Method moveMethodLocal;
    public static final Method blockChannelMethodLocal;
    public static final Method unblockChannelMethodLocal;
    public static final Method putForExternalReadMethodLocal;
    public static final Method putDataVersionedMethodLocal;
    public static final Method putDataEraseVersionedMethodLocal;
    public static final Method putKeyValVersionedMethodLocal;
    public static final Method putForExternalReadVersionedMethodLocal;
    public static final Method removeNodeVersionedMethodLocal;
    public static final Method removeKeyVersionedMethodLocal;
    public static final Method removeDataVersionedMethodLocal;
    public static final Method invalidateMethodLocal;
    public static final int putDataMethodLocal_id = 1;
    public static final int putDataEraseMethodLocal_id = 2;
    public static final int putKeyValMethodLocal_id = 3;
    public static final int removeNodeMethodLocal_id = 5;
    public static final int removeKeyMethodLocal_id = 6;
    public static final int removeDataMethodLocal_id = 7;
    public static final int evictNodeMethodLocal_id = 8;
    public static final int evictVersionedNodeMethodLocal_id = 9;
    public static final int prepareMethod_id = 10;
    public static final int commitMethod_id = 11;
    public static final int rollbackMethod_id = 12;
    public static final int replicateMethod_id = 13;
    public static final int replicateAllMethod_id = 14;
    public static final int addChildMethodLocal_id = 15;
    public static final int existsMethod_id = 16;
    public static final int releaseAllLocksMethodLocal_id = 17;
    public static final int optimisticPrepareMethod_id = 18;
    public static final int getPartialStateMethod_id = 19;
    public static final int clusteredGetMethod_id = 22;
    public static final int getChildrenNamesMethodLocal_id = 23;
    public static final int getDataMapMethodLocal_id = 24;
    public static final int getKeysMethodLocal_id = 25;
    public static final int getKeyValueMethodLocal_id = 26;
    public static final int remoteAnnounceBuddyPoolNameMethod_id = 28;
    public static final int remoteAssignToBuddyGroupMethod_id = 29;
    public static final int remoteRemoveFromBuddyGroupMethod_id = 30;
    public static final int getNodeMethodLocal_id = 31;
    public static final int printMethodLocal_id = 32;
    public static final int lockMethodLocal_id = 33;
    public static final int dataGravitationCleanupMethod_id = 34;
    public static final int dataGravitationMethod_id = 35;
    public static final int moveMethodLocal_id = 36;
    public static final int putDataVersionedMethodLocal_id = 37;
    public static final int putDataEraseVersionedMethodLocal_id = 38;
    public static final int putKeyValVersionedMethodLocal_id = 39;
    public static final int removeNodeVersionedMethodLocal_id = 40;
    public static final int removeKeyVersionedMethodLocal_id = 41;
    public static final int removeDataVersionedMethodLocal_id = 42;
    public static final int blockChannelMethodLocal_id = 43;
    public static final int unblockChannelMethodLocal_id = 44;
    public static final int putForExternalReadMethodLocal_id = 45;
    public static final int putForExternalReadVersionedMethodLocal_id = 46;
    public static final int invalidateMethodLocal_id = 47;

    public static int lookupMethodId(Method method) {
        Integer methodIdInteger = methodIds.get(method);
        int methodId = -1;
        if (methodIdInteger != null) {
            methodId = methodIdInteger;
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Method " + method + " is not registered with " + CacheMarshaller200.class));
        }
        return methodId;
    }

    public static Method lookupMethod(int id) {
        Method method = methods[id];
        if (method == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Method id " + id + " is not registered"));
            }
            throw new CacheException("Method id " + id + " is not registered with " + CacheMarshaller200.class);
        }
        return method;
    }

    public static boolean isCrudMethod(int id) {
        return crudMethodIds.contains(id);
    }

    public static boolean isTransactionLifecycleMethod(int id) {
        return transactionLifecycleMethodIds.contains(id);
    }

    public static boolean isBuddyGroupOrganisationMethod(int id) {
        return buddyGroupOrganisationMethodIds.contains(id);
    }

    public static boolean isPutMethod(int id) {
        return putMethodIds.contains(id);
    }

    public static boolean isGetMethod(int methodId) {
        return methodId == 23 || methodId == 24 || methodId == 16 || methodId == 25 || methodId == 26 || methodId == 31;
    }

    public static boolean isBlockUnblockMethod(int id) {
        return blockUnblockMethodIds.contains(id);
    }

    public static Method getVersionedMethod(int methodId) {
        return methods[MethodDeclarations.getVersionedMethodId(methodId)];
    }

    public static Method getUnversionedMethod(int methodId) {
        return methods[MethodDeclarations.getUnversionedMethodId(methodId)];
    }

    public static boolean isDataGravitationMethod(int methodId) {
        return methodId == 34 || methodId == 35;
    }

    public static boolean returnValueForRemoteCall(int methodId) {
        return methodsThatNeedToReturnValuesToRemoteCallers.contains(methodId);
    }

    public static int getUnversionedMethodId(int methodId) {
        if (MethodDeclarations.isCrudMethod(methodId)) {
            switch (methodId) {
                case 46: {
                    return 45;
                }
                case 38: {
                    return 2;
                }
                case 37: {
                    return 1;
                }
                case 39: {
                    return 3;
                }
                case 42: {
                    return 7;
                }
                case 41: {
                    return 6;
                }
                case 40: {
                    return 5;
                }
                case 36: {
                    return 36;
                }
            }
            throw new CacheException("Unrecognised method id " + methodId);
        }
        throw new CacheException("Attempting to look up a versioned equivalent of a non-crud method");
    }

    public static int getVersionedMethodId(int methodId) {
        if (MethodDeclarations.isCrudMethod(methodId)) {
            switch (methodId) {
                case 45: {
                    return 46;
                }
                case 2: {
                    return 38;
                }
                case 1: {
                    return 37;
                }
                case 3: {
                    return 39;
                }
                case 7: {
                    return 42;
                }
                case 6: {
                    return 41;
                }
                case 5: {
                    return 40;
                }
                case 36: {
                    return 36;
                }
            }
            throw new CacheException("Unrecognised method id " + methodId);
        }
        throw new CacheException("Attempting to look up a versioned equivalent of a non-crud method");
    }

    static {
        try {
            methodsThatNeedToReturnValuesToRemoteCallers.add(35);
            methodsThatNeedToReturnValuesToRemoteCallers.add(22);
            getDataMapMethodLocal = CacheImpl.class.getDeclaredMethod("_getData", Fqn.class);
            existsMethod = CacheImpl.class.getDeclaredMethod("exists", Fqn.class);
            putDataMethodLocal = CacheImpl.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Map.class, Boolean.TYPE);
            putDataEraseMethodLocal = CacheImpl.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Map.class, Boolean.TYPE, Boolean.TYPE);
            putKeyValMethodLocal = CacheImpl.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Object.class, Object.class, Boolean.TYPE);
            putForExternalReadMethodLocal = CacheImpl.class.getDeclaredMethod("_putForExternalRead", GlobalTransaction.class, Fqn.class, Object.class, Object.class);
            removeNodeMethodLocal = CacheImpl.class.getDeclaredMethod("_remove", GlobalTransaction.class, Fqn.class, Boolean.TYPE);
            removeKeyMethodLocal = CacheImpl.class.getDeclaredMethod("_remove", GlobalTransaction.class, Fqn.class, Object.class, Boolean.TYPE);
            removeDataMethodLocal = CacheImpl.class.getDeclaredMethod("_removeData", GlobalTransaction.class, Fqn.class, Boolean.TYPE);
            evictNodeMethodLocal = CacheImpl.class.getDeclaredMethod("_evict", Fqn.class);
            evictVersionedNodeMethodLocal = CacheImpl.class.getDeclaredMethod("_evict", Fqn.class, DataVersion.class);
            prepareMethod = CacheImpl.class.getDeclaredMethod("prepare", GlobalTransaction.class, List.class, Address.class, Boolean.TYPE);
            commitMethod = CacheImpl.class.getDeclaredMethod("commit", GlobalTransaction.class);
            rollbackMethod = CacheImpl.class.getDeclaredMethod("rollback", GlobalTransaction.class);
            addChildMethodLocal = CacheImpl.class.getDeclaredMethod("_addChild", GlobalTransaction.class, Fqn.class, Object.class, Node.class, Boolean.TYPE);
            getKeyValueMethodLocal = CacheImpl.class.getDeclaredMethod("_get", Fqn.class, Object.class, Boolean.TYPE);
            getNodeMethodLocal = CacheImpl.class.getDeclaredMethod("_get", Fqn.class);
            getKeysMethodLocal = CacheImpl.class.getDeclaredMethod("_getKeys", Fqn.class);
            getChildrenNamesMethodLocal = CacheImpl.class.getDeclaredMethod("_getChildrenNames", Fqn.class);
            replicateMethod = RemoteCacheInvocationDelegate.class.getDeclaredMethod("_replicate", MethodCall.class);
            replicateAllMethod = RemoteCacheInvocationDelegate.class.getDeclaredMethod("_replicate", List.class);
            releaseAllLocksMethodLocal = CacheImpl.class.getDeclaredMethod("_releaseAllLocks", Fqn.class);
            printMethodLocal = CacheImpl.class.getDeclaredMethod("_print", Fqn.class);
            lockMethodLocal = CacheImpl.class.getDeclaredMethod("_lock", Fqn.class, NodeLock.LockType.class, Boolean.TYPE);
            optimisticPrepareMethod = CacheImpl.class.getDeclaredMethod("optimisticPrepare", GlobalTransaction.class, List.class, Map.class, Address.class, Boolean.TYPE);
            clusteredGetMethod = RemoteCacheInvocationDelegate.class.getDeclaredMethod("clusteredGet", MethodCall.class, Boolean.class);
            remoteAnnounceBuddyPoolNameMethod = RemoteCacheInvocationDelegate.class.getDeclaredMethod("announceBuddyPoolName", Address.class, String.class);
            remoteRemoveFromBuddyGroupMethod = RemoteCacheInvocationDelegate.class.getDeclaredMethod("removeFromBuddyGroup", String.class);
            remoteAssignToBuddyGroupMethod = RemoteCacheInvocationDelegate.class.getDeclaredMethod("assignToBuddyGroup", BuddyGroup.class, Map.class);
            dataGravitationCleanupMethod = RemoteCacheInvocationDelegate.class.getDeclaredMethod("dataGravitationCleanup", Fqn.class, Fqn.class);
            dataGravitationMethod = CacheSPI.class.getDeclaredMethod("gravitateData", Fqn.class, Boolean.TYPE);
            moveMethodLocal = CacheImpl.class.getDeclaredMethod("_move", Fqn.class, Fqn.class);
            blockChannelMethodLocal = CacheImpl.class.getDeclaredMethod("_block", new Class[0]);
            unblockChannelMethodLocal = CacheImpl.class.getDeclaredMethod("_unblock", new Class[0]);
            putDataVersionedMethodLocal = CacheImpl.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Map.class, Boolean.TYPE, DataVersion.class);
            putDataEraseVersionedMethodLocal = CacheImpl.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Map.class, Boolean.TYPE, Boolean.TYPE, DataVersion.class);
            putKeyValVersionedMethodLocal = CacheImpl.class.getDeclaredMethod("_put", GlobalTransaction.class, Fqn.class, Object.class, Object.class, Boolean.TYPE, DataVersion.class);
            putForExternalReadVersionedMethodLocal = CacheImpl.class.getDeclaredMethod("_putForExternalRead", GlobalTransaction.class, Fqn.class, Object.class, Object.class, DataVersion.class);
            removeNodeVersionedMethodLocal = CacheImpl.class.getDeclaredMethod("_remove", GlobalTransaction.class, Fqn.class, Boolean.TYPE, DataVersion.class);
            removeKeyVersionedMethodLocal = CacheImpl.class.getDeclaredMethod("_remove", GlobalTransaction.class, Fqn.class, Object.class, Boolean.TYPE, DataVersion.class);
            removeDataVersionedMethodLocal = CacheImpl.class.getDeclaredMethod("_removeData", GlobalTransaction.class, Fqn.class, Boolean.TYPE, DataVersion.class);
            invalidateMethodLocal = CacheImpl.class.getDeclaredMethod("invalidate", Fqn.class, DataVersion.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        MethodDeclarations.methods[1] = putDataMethodLocal;
        MethodDeclarations.methods[2] = putDataEraseMethodLocal;
        MethodDeclarations.methods[3] = putKeyValMethodLocal;
        MethodDeclarations.methods[5] = removeNodeMethodLocal;
        MethodDeclarations.methods[6] = removeKeyMethodLocal;
        MethodDeclarations.methods[7] = removeDataMethodLocal;
        MethodDeclarations.methods[8] = evictNodeMethodLocal;
        MethodDeclarations.methods[9] = evictVersionedNodeMethodLocal;
        MethodDeclarations.methods[10] = prepareMethod;
        MethodDeclarations.methods[11] = commitMethod;
        MethodDeclarations.methods[12] = rollbackMethod;
        MethodDeclarations.methods[13] = replicateMethod;
        MethodDeclarations.methods[14] = replicateAllMethod;
        MethodDeclarations.methods[15] = addChildMethodLocal;
        MethodDeclarations.methods[16] = existsMethod;
        MethodDeclarations.methods[17] = releaseAllLocksMethodLocal;
        MethodDeclarations.methods[18] = optimisticPrepareMethod;
        MethodDeclarations.methods[22] = clusteredGetMethod;
        MethodDeclarations.methods[23] = getChildrenNamesMethodLocal;
        MethodDeclarations.methods[24] = getDataMapMethodLocal;
        MethodDeclarations.methods[25] = getKeysMethodLocal;
        MethodDeclarations.methods[26] = getKeyValueMethodLocal;
        MethodDeclarations.methods[28] = remoteAnnounceBuddyPoolNameMethod;
        MethodDeclarations.methods[29] = remoteAssignToBuddyGroupMethod;
        MethodDeclarations.methods[30] = remoteRemoveFromBuddyGroupMethod;
        MethodDeclarations.methods[31] = getNodeMethodLocal;
        MethodDeclarations.methods[32] = printMethodLocal;
        MethodDeclarations.methods[33] = lockMethodLocal;
        MethodDeclarations.methods[34] = dataGravitationCleanupMethod;
        MethodDeclarations.methods[35] = dataGravitationMethod;
        MethodDeclarations.methods[36] = moveMethodLocal;
        MethodDeclarations.methods[43] = blockChannelMethodLocal;
        MethodDeclarations.methods[44] = unblockChannelMethodLocal;
        MethodDeclarations.methods[37] = putDataVersionedMethodLocal;
        MethodDeclarations.methods[38] = putDataEraseVersionedMethodLocal;
        MethodDeclarations.methods[39] = putKeyValVersionedMethodLocal;
        MethodDeclarations.methods[42] = removeDataVersionedMethodLocal;
        MethodDeclarations.methods[41] = removeKeyVersionedMethodLocal;
        MethodDeclarations.methods[40] = removeNodeVersionedMethodLocal;
        MethodDeclarations.methods[46] = putForExternalReadVersionedMethodLocal;
        MethodDeclarations.methods[45] = putForExternalReadMethodLocal;
        MethodDeclarations.methods[47] = invalidateMethodLocal;
        for (int id = 0; id < methods.length; ++id) {
            if (methods[id] == null) continue;
            methodIds.put(methods[id], id);
        }
        putMethodIds.add(1);
        putMethodIds.add(2);
        putMethodIds.add(3);
        putMethodIds.add(38);
        putMethodIds.add(37);
        putMethodIds.add(39);
        putMethodIds.add(45);
        putMethodIds.add(46);
        crudMethodIds.addAll(putMethodIds);
        crudMethodIds.add(5);
        crudMethodIds.add(6);
        crudMethodIds.add(7);
        crudMethodIds.add(34);
        crudMethodIds.add(36);
        crudMethodIds.add(40);
        crudMethodIds.add(41);
        crudMethodIds.add(42);
        transactionLifecycleMethodIds.add(11);
        transactionLifecycleMethodIds.add(12);
        transactionLifecycleMethodIds.add(10);
        transactionLifecycleMethodIds.add(18);
        buddyGroupOrganisationMethodIds.add(28);
        buddyGroupOrganisationMethodIds.add(29);
        buddyGroupOrganisationMethodIds.add(30);
        blockUnblockMethodIds.add(43);
        blockUnblockMethodIds.add(44);
    }
}

