/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Comparator;
import org.testng.ITestNGMethod;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.ITest;

public class TestNGMethod
extends BaseTestMethod {
    private int m_invocationCount = 1;
    private int m_successPercentage = 100;
    private long m_timeOut = 0L;
    public static final Comparator<ITestNGMethod> SORT_BY_CLASS = new Comparator<ITestNGMethod>(){

        @Override
        public int compare(ITestNGMethod o1, ITestNGMethod o2) {
            String c1 = o1.getTestClass().getName();
            String c2 = o2.getTestClass().getName();
            return c1.compareTo(c2);
        }
    };

    public TestNGMethod(Method method, IAnnotationFinder finder) {
        super(method, finder);
        this.init();
    }

    public long getTimeOut() {
        return this.m_timeOut;
    }

    public int getInvocationCount() {
        return this.m_invocationCount;
    }

    public int getSuccessPercentage() {
        return this.m_successPercentage;
    }

    public boolean isTest() {
        return true;
    }

    private void init() {
        ITest testAnnotation = AnnotationHelper.findTest(this.getAnnotationFinder(), this.m_method);
        if (null != testAnnotation) {
            this.m_timeOut = testAnnotation.getTimeOut();
        }
        if (null != testAnnotation) {
            this.m_invocationCount = testAnnotation.getInvocationCount();
            this.m_successPercentage = testAnnotation.getSuccessPercentage();
            this.setThreadPoolSize(new Integer(testAnnotation.getThreadPoolSize()));
        }
        this.initGroups(ITest.class);
        if (null != testAnnotation) {
            this.setAlwaysRun(testAnnotation.getAlwaysRun());
            this.setDescription(testAnnotation.getDescription());
        }
    }
}

