/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.InputStream;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheFactoryTest {
    Configuration expected;
    String configFile = "META-INF/replSync-service.xml";
    private CacheSPI cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        XmlConfigurationParser parser = new XmlConfigurationParser();
        this.expected = parser.parseFile(this.configFile);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            this.cache.stop();
        }
    }

    public void testFromConfigFileStarted() {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(this.configFile);
        assert (this.cache.getCacheStatus() == CacheStatus.STARTED) : "Should have started";
        this.doSimpleConfTests(this.cache.getConfiguration());
    }

    public void testFromConfigFileUnstarted() {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(this.configFile, false);
        assert (this.cache.getCacheStatus() != CacheStatus.STARTED) : "Should not have started";
        this.doSimpleConfTests(this.cache.getConfiguration());
    }

    public void testFromConfigObjStarted() {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(this.expected);
        assert (this.cache.getCacheStatus() == CacheStatus.STARTED) : "Should have started";
        this.doSimpleConfTests(this.cache.getConfiguration());
    }

    public void testFromConfigObjUnstarted() {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(this.expected, false);
        assert (this.cache.getCacheStatus() != CacheStatus.STARTED) : "Should not have started";
        this.doSimpleConfTests(this.cache.getConfiguration());
    }

    private void doSimpleConfTests(Configuration tc) {
        AssertJUnit.assertEquals((Object)Configuration.CacheMode.REPL_SYNC, (Object)tc.getCacheMode());
        AssertJUnit.assertEquals((long)10000L, (long)tc.getLockAcquisitionTimeout());
        AssertJUnit.assertEquals((Object)IsolationLevel.REPEATABLE_READ, (Object)tc.getIsolationLevel());
        AssertJUnit.assertEquals((boolean)true, (boolean)tc.isUseRegionBasedMarshalling());
    }

    public void testLifecycle() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(this.expected, false);
        assert (this.cache.getCacheStatus() != CacheStatus.STARTED) : "Should not have started";
        this.cache.start();
        assert (this.cache.getCacheStatus() == CacheStatus.STARTED) : "Should have started";
        this.cache.stop();
        assert (this.cache.getCacheStatus() != CacheStatus.STARTED) : "Should not have started";
    }

    public void testCreationFromStreamStarted() throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.configFile);
        DefaultCacheFactory cf = new DefaultCacheFactory();
        this.cache = (CacheSPI)cf.createCache(is);
        assert (this.cache.getCacheStatus() == CacheStatus.STARTED) : "Should have started";
        this.doSimpleConfTests(this.cache.getConfiguration());
    }

    public void testCreationFromStream() throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.configFile);
        DefaultCacheFactory cf = new DefaultCacheFactory();
        this.cache = (CacheSPI)cf.createCache(is, false);
        assert (this.cache.getCacheStatus() != CacheStatus.STARTED) : "Should not have started";
        this.doSimpleConfTests(this.cache.getConfiguration());
    }

    public void testComponentsInjected() throws Exception {
        DefaultCacheFactory cf = new DefaultCacheFactory();
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache = (CacheSPI)cf.createCache(c);
        assert (TestingUtil.extractField(this.cache, "regionManager") != null);
        assert (TestingUtil.extractField(this.cache, "notifier") != null);
        assert (TestingUtil.extractField(this.cache, "marshaller") != null);
        assert (TestingUtil.extractField(this.cache, "transactionManager") != null);
        assert (TestingUtil.extractField(this.cache, "transactionTable") != null);
        assert (TestingUtil.extractField(this.cache, "stateTransferManager") != null);
    }
}

