/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMoveAPITest {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Node<Object, Object> rootNode;
    protected Node<Object, Object> nodeA;
    protected Node<Object, Object> nodeB;
    protected Node<Object, Object> nodeC;
    protected Node<Object, Object> nodeD;
    protected Node<Object, Object> nodeE;
    protected CacheSPI<Object, Object> cache;
    protected TransactionManager tm;
    protected static final Fqn<String> A = Fqn.fromString((String)"/a");
    protected static final Fqn<String> B = Fqn.fromString((String)"/b");
    protected static final Fqn<String> C = Fqn.fromString((String)"/c");
    protected static final Fqn<String> D = Fqn.fromString((String)"/d");
    protected static final Fqn<String> E = Fqn.fromString((String)"/e");
    protected Object k = "key";
    protected Object vA = "valueA";
    protected Object vB = "valueB";
    protected Object vC = "valueC";
    protected Object vD = "valueD";
    protected Object vE = "valueE";
    protected boolean optimistic = false;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache("META-INF/local-tx-service.xml", false);
        this.cache.getConfiguration().setNodeLockingScheme(this.optimistic ? Configuration.NodeLockingScheme.OPTIMISTIC : Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.start();
        this.rootNode = this.cache.getRoot();
        this.tm = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
    }

    @Test(groups={"functional"})
    public void testBasicMove() {
        this.nodeA = this.rootNode.addChild(A);
        this.nodeA.put(this.k, this.vA);
        this.nodeB = this.rootNode.addChild(B);
        this.nodeB.put(this.k, this.vB);
        this.nodeC = this.nodeA.addChild(C);
        this.nodeC.put(this.k, this.vC);
        AssertJUnit.assertTrue((boolean)this.rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)this.rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)this.rootNode.hasChild(C));
        AssertJUnit.assertTrue((boolean)this.nodeA.hasChild(C));
        AssertJUnit.assertEquals((String)("" + this.nodeA), (Object)this.vA, (Object)this.nodeA.get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.nodeB.get(this.k));
        AssertJUnit.assertEquals((Object)this.vC, (Object)this.nodeC.get(this.k));
        AssertJUnit.assertEquals(this.nodeA, (Object)this.nodeC.getParent());
        this.log.info((Object)("BEFORE MOVE " + this.cache));
        this.cache.move(this.nodeC.getFqn(), this.nodeB.getFqn());
        this.nodeC = this.cache.getNode(new Fqn(this.genericize(this.nodeB.getFqn()), C));
        this.log.info((Object)("POST MOVE " + this.cache));
        this.log.info((Object)("HC " + this.nodeC + " " + System.identityHashCode(this.nodeC)));
        Node x = this.cache.getRoot().getChild(Fqn.fromString((String)"b/c"));
        this.log.info((Object)("HC " + x + " " + System.identityHashCode(x)));
        AssertJUnit.assertEquals((String)("NODE C " + this.nodeC), (String)"/b/c", (String)this.nodeC.getFqn().toString());
        AssertJUnit.assertTrue((boolean)this.rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)this.rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)this.rootNode.hasChild(C));
        AssertJUnit.assertFalse((boolean)this.nodeA.hasChild(C));
        AssertJUnit.assertTrue((boolean)this.nodeB.hasChild(C));
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.nodeA.get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.nodeB.get(this.k));
        AssertJUnit.assertEquals((Object)this.vC, (Object)this.nodeC.get(this.k));
        AssertJUnit.assertEquals((String)("B is parent of C: " + this.nodeB), this.nodeB, (Object)this.nodeC.getParent());
    }

    private Fqn<String> genericize(Fqn fqn) {
        return fqn;
    }

    private Node<Object, Object> genericize(Node node) {
        return node;
    }

    @Test(groups={"functional"})
    public void testMoveWithChildren() {
        this.nodeA = this.rootNode.addChild(A);
        this.nodeA.put(this.k, this.vA);
        this.nodeB = this.rootNode.addChild(B);
        this.nodeB.put(this.k, this.vB);
        this.nodeC = this.nodeA.addChild(C);
        this.nodeC.put(this.k, this.vC);
        this.nodeD = this.nodeC.addChild(D);
        this.nodeD.put(this.k, this.vD);
        this.nodeE = this.nodeD.addChild(E);
        this.nodeE.put(this.k, this.vE);
        AssertJUnit.assertTrue((boolean)this.rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)this.rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)this.rootNode.hasChild(C));
        AssertJUnit.assertTrue((boolean)this.nodeA.hasChild(C));
        AssertJUnit.assertTrue((boolean)this.nodeC.hasChild(D));
        AssertJUnit.assertTrue((boolean)this.nodeD.hasChild(E));
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.nodeA.get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.nodeB.get(this.k));
        AssertJUnit.assertEquals((Object)this.vC, (Object)this.nodeC.get(this.k));
        AssertJUnit.assertEquals((Object)this.vD, (Object)this.nodeD.get(this.k));
        AssertJUnit.assertEquals((Object)this.vE, (Object)this.nodeE.get(this.k));
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeA.getParent());
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeB.getParent());
        AssertJUnit.assertEquals(this.nodeA, (Object)this.nodeC.getParent());
        AssertJUnit.assertEquals(this.nodeC, (Object)this.nodeD.getParent());
        AssertJUnit.assertEquals(this.nodeD, (Object)this.nodeE.getParent());
        this.log.info((Object)("move " + this.nodeC + " to " + this.nodeB));
        this.cache.move(this.nodeC.getFqn(), this.nodeB.getFqn());
        this.nodeC = this.nodeB.getChild(C);
        this.nodeD = this.nodeC.getChild(D);
        this.nodeE = this.nodeD.getChild(E);
        AssertJUnit.assertTrue((boolean)this.rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)this.rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)this.rootNode.hasChild(C));
        AssertJUnit.assertFalse((boolean)this.nodeA.hasChild(C));
        AssertJUnit.assertTrue((boolean)this.nodeB.hasChild(C));
        AssertJUnit.assertTrue((boolean)this.nodeC.hasChild(D));
        AssertJUnit.assertTrue((boolean)this.nodeD.hasChild(E));
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.nodeA.get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.nodeB.get(this.k));
        AssertJUnit.assertEquals((Object)this.vC, (Object)this.nodeC.get(this.k));
        AssertJUnit.assertEquals((Object)this.vD, (Object)this.nodeD.get(this.k));
        AssertJUnit.assertEquals((Object)this.vE, (Object)this.nodeE.get(this.k));
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeA.getParent());
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeB.getParent());
        AssertJUnit.assertEquals(this.nodeB, (Object)this.nodeC.getParent());
        AssertJUnit.assertEquals(this.nodeC, (Object)this.nodeD.getParent());
        AssertJUnit.assertEquals(this.nodeD, (Object)this.nodeE.getParent());
    }

    @Test(groups={"functional"})
    public void testTxCommit() throws Exception {
        this.nodeA = this.rootNode.addChild(A);
        this.nodeB = this.nodeA.addChild(B);
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeA.getParent());
        AssertJUnit.assertEquals(this.nodeA, (Object)this.nodeB.getParent());
        AssertJUnit.assertEquals(this.nodeA, this.rootNode.getChildren().iterator().next());
        AssertJUnit.assertEquals(this.nodeB, this.nodeA.getChildren().iterator().next());
        this.tm.begin();
        this.cache.move(this.nodeB.getFqn(), Fqn.ROOT);
        this.tm.commit();
        this.nodeB = this.rootNode.getChild(B);
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeA.getParent());
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeB.getParent());
        AssertJUnit.assertTrue((boolean)this.rootNode.getChildren().contains(this.nodeA));
        AssertJUnit.assertTrue((boolean)this.rootNode.getChildren().contains(this.nodeB));
        AssertJUnit.assertTrue((boolean)this.nodeA.getChildren().isEmpty());
    }

    @Test(groups={"functional"})
    public void testTxRollback() throws Exception {
        this.nodeA = this.rootNode.addChild(A);
        this.nodeB = this.nodeA.addChild(B);
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeA.getParent());
        AssertJUnit.assertEquals(this.nodeA, (Object)this.nodeB.getParent());
        AssertJUnit.assertEquals(this.nodeA, this.rootNode.getChildren().iterator().next());
        AssertJUnit.assertEquals(this.nodeB, this.nodeA.getChildren().iterator().next());
        this.tm.begin();
        this.cache.move(this.nodeB.getFqn(), Fqn.ROOT);
        if (!this.optimistic) {
            AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeA.getParent());
            AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeB.getParent());
            AssertJUnit.assertTrue((boolean)this.rootNode.getChildren().contains(this.nodeA));
            AssertJUnit.assertTrue((boolean)this.rootNode.getChildren().contains(this.nodeB));
            AssertJUnit.assertTrue((boolean)this.nodeA.getChildren().isEmpty());
        }
        this.tm.rollback();
        this.nodeA = this.rootNode.getChild(A);
        this.nodeB = this.nodeA.getChild(B);
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeA.getParent());
        AssertJUnit.assertEquals(this.nodeA, (Object)this.nodeB.getParent());
        AssertJUnit.assertEquals(this.nodeA, this.rootNode.getChildren().iterator().next());
        AssertJUnit.assertEquals(this.nodeB, this.nodeA.getChildren().iterator().next());
    }

    @Test(groups={"functional"})
    public void testWithCacheloaders() throws Exception {
        this.doCacheLoaderTest(false, false);
    }

    @Test(groups={"functional"})
    public void testWithPassivation() throws Exception {
        this.doCacheLoaderTest(true, false);
    }

    @Test(groups={"functional"})
    public void testWithCacheloadersTx() throws Exception {
        this.doCacheLoaderTest(false, true);
    }

    @Test(groups={"functional"})
    public void testWithPassivationTx() throws Exception {
        this.doCacheLoaderTest(true, true);
    }

    protected void doCacheLoaderTest(boolean pasv, boolean useTx) throws Exception {
        this.cache.destroy();
        this.cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig(pasv, "", DummyInMemoryCacheLoader.class.getName(), null, false, false, false, false));
        this.cache.start();
        DummyInMemoryCacheLoader loader = (DummyInMemoryCacheLoader)this.cache.getCacheLoaderManager().getCacheLoader();
        this.rootNode.put((Object)"key", (Object)"value");
        if (!pasv) {
            Map<Object, Object> m = loader.get(Fqn.ROOT);
            AssertJUnit.assertNotNull((String)"Should not be null", m);
            AssertJUnit.assertEquals((Object)"value", (Object)m.get("key"));
        }
        this.nodeA = this.rootNode.addChild(A);
        this.nodeA.put(this.k, this.vA);
        this.nodeB = this.rootNode.addChild(B);
        this.nodeB.put(this.k, this.vB);
        this.nodeC = this.nodeA.addChild(C);
        this.nodeC.put(this.k, this.vC);
        this.nodeD = this.nodeC.addChild(D);
        this.nodeD.put(this.k, this.vD);
        this.nodeE = this.nodeD.addChild(E);
        this.nodeE.put(this.k, this.vE);
        AssertJUnit.assertNotNull((Object)this.cache.peek(A, false));
        AssertJUnit.assertNotNull((Object)this.cache.peek(B, false));
        AssertJUnit.assertNull((Object)this.cache.peek(C, false));
        AssertJUnit.assertNotNull((Object)this.cache.peek(new Fqn(A, C), false));
        AssertJUnit.assertNotNull((Object)this.cache.peek(new Fqn(new Fqn(A, C), D), false));
        AssertJUnit.assertNotNull((Object)this.cache.peek(new Fqn(new Fqn(new Fqn(A, C), D), E), false));
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.nodeA.get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.nodeB.get(this.k));
        AssertJUnit.assertEquals((Object)this.vC, (Object)this.nodeC.get(this.k));
        AssertJUnit.assertEquals((Object)this.vD, (Object)this.nodeD.get(this.k));
        AssertJUnit.assertEquals((Object)this.vE, (Object)this.nodeE.get(this.k));
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeA.getParent());
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeB.getParent());
        AssertJUnit.assertEquals(this.nodeA, (Object)this.nodeC.getParent());
        AssertJUnit.assertEquals(this.nodeC, (Object)this.nodeD.getParent());
        AssertJUnit.assertEquals(this.nodeD, (Object)this.nodeE.getParent());
        System.out.println("Loader" + (Object)((Object)loader));
        this.cache.evict(Fqn.ROOT, true);
        if (useTx) {
            this.tm.begin();
        }
        this.cache.move(this.nodeC.getFqn(), this.nodeB.getFqn());
        if (useTx) {
            this.tm.commit();
        }
        this.nodeA = this.rootNode.getChild(A);
        this.nodeB = this.rootNode.getChild(B);
        this.nodeC = this.nodeB.getChild(C);
        this.log.info((Object)"nodeC get child B ");
        this.nodeD = this.nodeC.getChild(D);
        this.log.info((Object)"nodeD get child E ");
        this.nodeE = this.nodeD.getChild(E);
        Fqn old_C = new Fqn(C, (Object[])new String[0]);
        Fqn old_D = new Fqn(old_C, D);
        Fqn old_E = new Fqn(old_D, E);
        AssertJUnit.assertNotNull((Object)this.cache.peek(A, false));
        AssertJUnit.assertNotNull((Object)this.cache.peek(B, false));
        AssertJUnit.assertNull((Object)this.cache.peek(C, false));
        AssertJUnit.assertNull((Object)this.cache.peek(new Fqn(A, C), false));
        AssertJUnit.assertNotNull((Object)this.cache.peek(new Fqn(B, C), false));
        AssertJUnit.assertNotNull((Object)this.cache.peek(new Fqn(new Fqn(B, C), D), false));
        AssertJUnit.assertNotNull((Object)this.cache.peek(new Fqn(new Fqn(new Fqn(B, C), D), E), false));
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.nodeA.get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.nodeB.get(this.k));
        AssertJUnit.assertEquals((Object)this.vC, (Object)this.nodeC.get(this.k));
        AssertJUnit.assertEquals((Object)this.vD, (Object)this.nodeD.get(this.k));
        AssertJUnit.assertEquals((Object)this.vE, (Object)this.nodeE.get(this.k));
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeA.getParent());
        AssertJUnit.assertEquals(this.rootNode, (Object)this.nodeB.getParent());
        AssertJUnit.assertEquals(this.nodeB, (Object)this.nodeC.getParent());
        AssertJUnit.assertEquals(this.nodeC, (Object)this.nodeD.getParent());
        AssertJUnit.assertEquals(this.nodeD, (Object)this.nodeE.getParent());
        if (pasv) {
            this.cache.evict(Fqn.ROOT, true);
        }
        AssertJUnit.assertEquals((Object)this.vA, (Object)loader.get(this.nodeA.getFqn()).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)loader.get(this.nodeB.getFqn()).get(this.k));
        AssertJUnit.assertEquals((Object)this.vC, (Object)loader.get(this.nodeC.getFqn()).get(this.k));
        AssertJUnit.assertEquals((Object)this.vD, (Object)loader.get(this.nodeD.getFqn()).get(this.k));
        AssertJUnit.assertEquals((Object)this.vE, (Object)loader.get(this.nodeE.getFqn()).get(this.k));
        AssertJUnit.assertNull(loader.get(old_C));
        AssertJUnit.assertNull(loader.get(old_D));
        AssertJUnit.assertNull(loader.get(old_E));
    }

    @Test(groups={"functional"})
    public void testLocksDeepMove() throws Exception {
        this.nodeA = this.rootNode.addChild(A);
        this.nodeB = this.nodeA.addChild(B);
        this.nodeD = this.nodeB.addChild(D);
        this.nodeC = this.rootNode.addChild(C);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tm.begin();
        this.cache.move(this.nodeC.getFqn(), this.nodeB.getFqn());
        AssertJUnit.assertEquals((String)"ROOT should have a RL, nodeC should have a RL, nodeA should have a RL, nodeB should have a WL, nodeD should have a WL", (int)5, (int)this.cache.getNumberOfLocksHeld());
        this.tm.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    @Test(groups={"functional"})
    public void testLocks() throws Exception {
        this.nodeA = this.rootNode.addChild(A);
        this.nodeB = this.nodeA.addChild(B);
        this.nodeC = this.rootNode.addChild(C);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tm.begin();
        this.cache.move(this.nodeC.getFqn(), this.nodeB.getFqn());
        AssertJUnit.assertEquals((String)"ROOT should have a RL, nodeC should have a RL, nodeA should have a RL, nodeB should have a WL", (int)4, (int)this.cache.getNumberOfLocksHeld());
        this.tm.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    @Test(groups={"functional"})
    public void testConcurrency() throws InterruptedException {
        if (this.optimistic) {
            return;
        }
        int N = 3;
        int loops = 64;
        Fqn<String> FQN_A = A;
        Fqn<String> FQN_B = B;
        Fqn<String> FQN_C = C;
        Fqn<String> FQN_D = D;
        Fqn<String> FQN_E = E;
        Fqn FQN_X = Fqn.fromString((String)"/x");
        Fqn FQN_Y = Fqn.fromString((String)"/y");
        final Node[] NODES = new Node[]{this.rootNode.addChild(FQN_A), this.rootNode.addChild(FQN_B), this.rootNode.addChild(FQN_C), this.rootNode.addChild(FQN_D), this.rootNode.addChild(FQN_E)};
        final Node NODE_X = this.genericize(NODES[0]).addChild(FQN_X);
        final Node NODE_Y = this.genericize(NODES[1]).addChild(FQN_Y);
        Thread[] movers = new Thread[3];
        final CountDownLatch latch = new CountDownLatch(1);
        final Random r = new Random();
        for (int i = 0; i < 3; ++i) {
            movers[i] = new Thread("Mover-" + i){

                public void run() {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    for (int counter = 0; counter < 64; ++counter) {
                        System.out.println(this.getName() + ": Attempt " + counter);
                        try {
                            NodeMoveAPITest.this.cache.move(NODE_X.getFqn(), NODES[r.nextInt(NODES.length)].getFqn());
                        }
                        catch (NodeNotExistsException e) {
                            // empty catch block
                        }
                        TestingUtil.sleepRandom(250);
                        try {
                            NodeMoveAPITest.this.cache.move(NODE_Y.getFqn(), NODES[r.nextInt(NODES.length)].getFqn());
                        }
                        catch (NodeNotExistsException nodeNotExistsException) {
                            // empty catch block
                        }
                        TestingUtil.sleepRandom(250);
                    }
                }
            };
            movers[i].start();
        }
        latch.countDown();
        for (Thread t : movers) {
            t.join();
        }
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        boolean found_x = false;
        boolean found_x_again = false;
        for (Node erased : NODES) {
            Node<Object, Object> n = this.genericize(erased);
            if (!found_x) {
                found_x = n.hasChild(FQN_X);
                continue;
            }
            found_x_again = found_x_again || n.hasChild(FQN_X);
        }
        boolean found_y = false;
        boolean found_y_again = false;
        for (Node erased : NODES) {
            Node<Object, Object> n = this.genericize(erased);
            if (!found_y) {
                found_y = n.hasChild(FQN_Y);
                continue;
            }
            found_y_again = found_y_again || n.hasChild(FQN_Y);
        }
        AssertJUnit.assertTrue((String)"Should have found x", (boolean)found_x);
        AssertJUnit.assertTrue((String)"Should have found y", (boolean)found_y);
        AssertJUnit.assertFalse((String)"Should have only found x once", (boolean)found_x_again);
        AssertJUnit.assertFalse((String)"Should have only found y once", (boolean)found_y_again);
    }

    @Test(groups={"functional"})
    public void testMoveInSamePlace() {
        Fqn FQN_X = Fqn.fromString((String)"/x");
        Node aNode = this.rootNode.addChild(A);
        Node xNode = aNode.addChild(FQN_X);
        AssertJUnit.assertEquals((int)aNode.getChildren().size(), (int)1);
        this.cache.move(xNode.getFqn(), aNode.getFqn());
        AssertJUnit.assertEquals((int)aNode.getChildren().size(), (int)1);
    }

    protected CacheLoaderConfig getSingleCacheLoaderConfig(boolean passivation, String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean shared, boolean purgeOnStartup) throws Exception {
        String xml = "<config>\n<passivation>" + passivation + "</passivation>\n" + "<preload>" + preload + "</preload>\n" + "<cacheloader>\n" + "<class>" + cacheloaderClass + "</class>\n" + "<properties>" + properties + "</properties>\n" + "<async>" + async + "</async>\n" + "<shared>" + shared + "</shared>\n" + "<fetchPersistentState>" + fetchPersistentState + "</fetchPersistentState>\n" + "<purgeOnStartup>" + purgeOnStartup + "</purgeOnStartup>\n" + "</cacheloader>\n" + "</config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }
}

