/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocatorConfig;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.interceptors.DataGravitatorInterceptor;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional", "jgroups"})
public class BuddyReplicationConfigTest {
    private CacheSPI<Object, Object> cache;

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.cache.stop();
        this.cache = null;
    }

    public void testNullConfig() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setBuddyReplicationConfig(null);
        AssertJUnit.assertNull((Object)this.cache.getBuddyManager());
    }

    public void testDisabledConfig() throws Exception {
        String xmlConfig = "<config><buddyReplicationEnabled>false</buddyReplicationEnabled></config>";
        Element element = XmlHelper.stringToElement((String)xmlConfig);
        BuddyReplicationConfig config = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setBuddyReplicationConfig(config);
        AssertJUnit.assertNull((Object)this.cache.getBuddyManager());
    }

    public void testBasicConfig() throws Exception {
        String xmlConfig = "<config><buddyReplicationEnabled>true</buddyReplicationEnabled></config>";
        Element element = XmlHelper.stringToElement((String)xmlConfig);
        BuddyReplicationConfig config = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cache.getConfiguration().setBuddyReplicationConfig(config);
        this.cache.create();
        this.cache.start();
        AssertJUnit.assertNotNull((Object)this.cache.getBuddyManager());
        BuddyManager mgr = this.cache.getBuddyManager();
        AssertJUnit.assertTrue((boolean)mgr.isEnabled());
        AssertJUnit.assertNull((Object)mgr.getBuddyPoolName());
        AssertJUnit.assertEquals(NextMemberBuddyLocator.class, mgr.buddyLocator.getClass());
        NextMemberBuddyLocatorConfig blc = (NextMemberBuddyLocatorConfig)mgr.buddyLocator.getConfig();
        AssertJUnit.assertEquals((int)1, (int)blc.getNumBuddies());
        AssertJUnit.assertTrue((boolean)blc.isIgnoreColocatedBuddies());
    }

    public void testXmlConfig() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(new XmlConfigurationParser().parseFile("META-INF/buddyreplication-service.xml"), false);
        this.cache.create();
        this.cache.start();
        BuddyManager bm = this.cache.getBuddyManager();
        AssertJUnit.assertNotNull((Object)bm);
        AssertJUnit.assertTrue((boolean)bm.isEnabled());
        AssertJUnit.assertTrue((boolean)(bm.buddyLocator instanceof NextMemberBuddyLocator));
        NextMemberBuddyLocator bl = (NextMemberBuddyLocator)bm.buddyLocator;
        NextMemberBuddyLocatorConfig blc = (NextMemberBuddyLocatorConfig)bl.getConfig();
        AssertJUnit.assertTrue((boolean)blc.isIgnoreColocatedBuddies());
        AssertJUnit.assertEquals((int)1, (int)blc.getNumBuddies());
        AssertJUnit.assertEquals((String)"myBuddyPoolReplicationGroup", (String)bm.getConfig().getBuddyPoolName());
        AssertJUnit.assertEquals((int)2000, (int)bm.getConfig().getBuddyCommunicationTimeout());
        boolean hasDG = false;
        for (Interceptor interceptor : this.cache.getInterceptorChain()) {
            hasDG = hasDG || interceptor instanceof DataGravitatorInterceptor;
        }
        System.out.println(this.cache.getInterceptorChain());
        AssertJUnit.assertTrue((String)"Should have a data gravitator!!", (boolean)hasDG);
    }
}

