/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.lock.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ElementSizePolicyTest {
    CacheSPI<Object, Object> cache;
    int wakeupIntervalMillis = 0;
    final String ROOT_STR = "/test";
    Throwable t1_ex;
    Throwable t2_ex;
    final long DURATION = 10000L;
    boolean isTrue;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis = this.cache.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        this.log("wakeupInterval is " + this.wakeupIntervalMillis);
        if (this.wakeupIntervalMillis < 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
        this.t2_ex = null;
        this.t1_ex = null;
        this.isTrue = true;
    }

    void initCaches() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache("META-INF/local-elementsize-eviction-service.xml", false);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
    }

    public void testEviction() throws Exception {
        int i;
        String rootStr = "/org/jboss/test/data/";
        for (i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                if (i % 2 != 0) continue;
                for (int k = 0; k < i; ++k) {
                    this.cache.put(fqn, (Object)k, (Object)Integer.toString(k));
                }
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        System.out.println(this.cache);
        this._sleep(this.wakeupIntervalMillis + 500);
        System.out.println(this.cache);
        for (i = 0; i < 10; ++i) {
            Node node = this.cache.getNode("/org/jboss/test/data/" + Integer.toString(i));
            System.out.println(node);
            if (i % 2 == 0) {
                if (i < 6) {
                    int numElements = ((NodeSPI)node).getDataDirect().size();
                    AssertJUnit.assertEquals((int)(i + 1), (int)numElements);
                    continue;
                }
                AssertJUnit.assertNull((Object)node);
                continue;
            }
            AssertJUnit.assertEquals((int)1, (int)((NodeSPI)node).getDataDirect().size());
        }
    }

    public void testEviction2() throws Exception {
        Fqn fqn;
        String str;
        int i;
        String rootStr = "/org/jboss/data/";
        for (i = 0; i < 20; ++i) {
            str = rootStr + Integer.toString(i);
            fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)i, (Object)str);
            for (int k = 0; k < i; ++k) {
                this.cache.put(fqn, (Object)k, (Object)str);
            }
        }
        this._sleep(this.wakeupIntervalMillis + 500);
        for (i = 0; i < 20; ++i) {
            str = rootStr + Integer.toString(i);
            fqn = Fqn.fromString((String)str);
            Node node = this.cache.getNode(fqn);
            System.out.println(i + " " + node);
            if (i > 9) {
                AssertJUnit.assertNull((String)("Testing at " + i), (Object)node);
                continue;
            }
            AssertJUnit.assertEquals((int)(1 + i), (int)node.getData().size());
        }
        for (i = 0; i < 17; ++i) {
            this.cache.put("/org/jboss/data/" + Integer.toString(3), (Object)(100 + i), (Object)"value");
        }
        Node node = this.cache.getNode("/org/jboss/data/" + Integer.toString(3));
        AssertJUnit.assertEquals((int)21, (int)node.getData().size());
        this._sleep(this.wakeupIntervalMillis + 500);
        AssertJUnit.assertNull((Object)this.cache.getNode("/org/jboss/data/" + Integer.toString(3)));
    }

    public void testConcurrentPutAndEvict() throws Exception {
        this.cache.stop();
        this.cache.destroy();
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.start();
        this.cache.put("/test/concurrentPutAndEvict", (Object)"value", (Object)1);
        for (int i = 0; i < 10; ++i) {
            new MyPutter("Putter" + i).start();
        }
        int counter = 0;
        do {
            ++counter;
            if (this.t1_ex != null) {
                AssertJUnit.fail((String)("Exception generated in put() " + this.t1_ex));
            }
            this.log("nodes/locks: " + this.cache.getNumberOfNodes() + "/" + this.cache.getNumberOfLocksHeld());
            this._sleep(1000L);
        } while (counter <= 10);
        this.isTrue = false;
    }

    private void _sleep(long msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void log(String msg) {
        System.out.println("-- " + msg);
    }

    class MyPutter
    extends Thread {
        public MyPutter(String name) {
            super(name);
        }

        public void run() {
            int i = 0;
            String myName = "/test/test1/node" + this.getName();
            while (ElementSizePolicyTest.this.isTrue) {
                try {
                    ElementSizePolicyTest.this.cache.put(myName + i++, (Object)"value", (Object)i);
                    MyPutter.sleep(1L);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (ElementSizePolicyTest.this.t1_ex != null) continue;
                    ElementSizePolicyTest.this.t1_ex = e;
                }
            }
        }
    }
}

