/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class NullEvictionPolicyTest {
    CacheSPI<Object, Object> cache_;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache_ = null;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache_ != null) {
            this.cache_.stop();
            this.cache_.destroy();
        }
    }

    public void testEviction() {
        Fqn lru;
        Fqn test;
        Fqn dflt;
        int i;
        this.cache_ = (CacheSPI)new DefaultCacheFactory().createCache("META-INF/local-null-eviction-service.xml", false);
        this.cache_.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache_.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache_.start();
        String dfltRootStr = "/a/";
        String testRootStr = "/test/";
        String lruRootStr = "/lru/";
        for (i = 0; i < 20; ++i) {
            if (i % 1 == 0 || i % 3 == 0) {
                dflt = Fqn.fromString((String)(dfltRootStr + i));
                test = Fqn.fromString((String)(testRootStr + i));
                lru = Fqn.fromString((String)(lruRootStr + i));
                this.cache_.put(dflt, (Object)"key", (Object)"value");
                this.cache_.put(test, (Object)"key", (Object)"value");
                this.cache_.put(lru, (Object)"key", (Object)"value");
                continue;
            }
            dflt = Fqn.fromString((String)(dfltRootStr + (i - 1)));
            test = Fqn.fromString((String)(testRootStr + (i - 1)));
            lru = Fqn.fromString((String)(lruRootStr + (i - 1)));
            if (i % 2 == 0) {
                AssertJUnit.assertEquals((Object)"value", (Object)this.cache_.get(dflt, (Object)"key"));
                AssertJUnit.assertEquals((Object)"value", (Object)this.cache_.get(test, (Object)"key"));
                AssertJUnit.assertEquals((Object)"value", (Object)this.cache_.get(lru, (Object)"key"));
                continue;
            }
            this.cache_.removeNode(dflt);
            this.cache_.removeNode(test);
            this.cache_.removeNode(lru);
        }
        TestingUtil.sleepThread(2500L);
        for (i = 0; i < 20; ++i) {
            dflt = Fqn.fromString((String)(dfltRootStr + i));
            test = Fqn.fromString((String)(testRootStr + i));
            lru = Fqn.fromString((String)(lruRootStr + i));
            if (i % 1 == 0) {
                AssertJUnit.assertEquals((Object)"value", (Object)this.cache_.get(dflt, (Object)"key"));
                AssertJUnit.assertEquals((Object)"value", (Object)this.cache_.get(test, (Object)"key"));
                AssertJUnit.assertNull((Object)this.cache_.get(lru, (Object)"key"));
                continue;
            }
            if (i % 3 != 0) continue;
            AssertJUnit.assertNull((Object)this.cache_.get(dflt, (Object)"key"));
            AssertJUnit.assertNull((Object)this.cache_.get(test, (Object)"key"));
            AssertJUnit.assertNull((Object)this.cache_.get(lru, (Object)"key"));
        }
    }
}

