/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.List;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.interceptors.EvictionInterceptor;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class OptimisticEvictionTest {
    private static final int NUMBER_OF_RUNS = 0x100000;
    private static final int NUMBER_NODES = 256;
    private Fqn<Object> region = new Fqn(new Object[]{"testingRegion"});
    private TransactionManager txManager;
    private CacheSPI<Object, Object> cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.txManager = new DummyTransactionManagerLookup().getTransactionManager();
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache("META-INF/optimistic-eviction.xml");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            try {
                if (this.cache.getTransactionManager().getTransaction() != null) {
                    this.cache.getTransactionManager().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cache.stop();
            this.cache = null;
        }
    }

    public void testEvictionError() throws Exception {
        int i;
        for (i = 0; i < 256; ++i) {
            this.cache.put(new Fqn(this.region, new Object[]{i}), (Object)i, (Object)i);
        }
        for (i = 0; i < 0x100000; ++i) {
            this.txManager.begin();
            this.cache.get(this.region, (Object)(i % 256));
            this.txManager.commit();
        }
    }

    public void testEvictionOccurence() throws Exception {
        this.cache.put("/timeBased/test", (Object)"key", (Object)"value");
        AssertJUnit.assertTrue((boolean)this.cache.exists("/timeBased/test"));
        TestingUtil.sleepThread(3000L);
        AssertJUnit.assertTrue((!this.cache.exists("/timeBased/test") ? 1 : 0) != 0);
    }

    public void testInterceptorChain() throws Exception {
        List interceptors = this.cache.getInterceptorChain();
        System.out.println(interceptors);
        Iterator i = interceptors.iterator();
        boolean found = false;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof EvictionInterceptor)) continue;
            found = true;
        }
        AssertJUnit.assertTrue((String)"Eviction interceptor should be in interceptor chain.", (boolean)found);
    }

    public void testCompleteRemoval() throws Exception {
        String rootStr = "/timeBased/";
        Fqn parent = Fqn.fromString((String)(rootStr + "parent"));
        this.cache.put(parent, (Object)"key", (Object)"value");
        this.cache.put(new Fqn(parent, (Object[])new String[]{"child"}), (Object)"key", (Object)"value");
        TestingUtil.sleepThread(5500L);
        AssertJUnit.assertFalse((String)"Parent completely removed", (boolean)this.cache.getRoot().hasChild(parent));
    }
}

