/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public abstract class AbstractCacheLoaderTestBase {
    protected final Log log = LogFactory.getLog(this.getClass());

    protected CacheLoaderConfig getSingleCacheLoaderConfig(String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean shared) throws Exception {
        return this.getSingleCacheLoaderConfig(preload, cacheloaderClass, properties, async, fetchPersistentState, shared, false);
    }

    protected CacheLoaderConfig getSingleCacheLoaderConfig(String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean shared, boolean purgeOnStartup) throws Exception {
        return this.getSingleCacheLoaderConfig(false, preload, cacheloaderClass, properties, async, fetchPersistentState, shared, purgeOnStartup);
    }

    protected CacheLoaderConfig getSingleCacheLoaderConfig(boolean passivation, String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean shared, boolean purgeOnStartup) throws Exception {
        String xml = "<config>\n<passivation>" + passivation + "</passivation>\n" + "<preload>" + preload + "</preload>\n" + "<cacheloader>\n" + "<class>" + cacheloaderClass + "</class>\n" + "<properties>" + properties + "</properties>\n" + "<async>" + async + "</async>\n" + "<shared>" + shared + "</shared>\n" + "<fetchPersistentState>" + fetchPersistentState + "</fetchPersistentState>\n" + "<purgeOnStartup>" + purgeOnStartup + "</purgeOnStartup>\n" + "</cacheloader>\n" + "</config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }
}

