/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.PessimisticLockInterceptor;
import org.jboss.cache.interceptors.UnlockInterceptor;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class PessimisticLockTest {
    private Cache<Object, Object> cache;
    private TransactionManager tm;
    private Fqn<String> fqn = Fqn.fromString((String)"/a/b/c");

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.cache = new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.start();
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.cache.stop();
    }

    private void assertNoStaleLocks() {
        CacheSPI spi = (CacheSPI)this.cache;
        PessimisticLockInterceptor pli = TestingUtil.findInterceptor(spi, PessimisticLockInterceptor.class);
        UnlockInterceptor ui = TestingUtil.findInterceptor(spi, UnlockInterceptor.class);
        Map lockTablePLI = (Map)TestingUtil.extractField(pli, "lockTable");
        Map lockTableUI = (Map)TestingUtil.extractField(ui, "lockTable");
        assert (lockTablePLI == lockTableUI) : "PessimisticLockInterceptor and UnlockInterceptor should be referring to the same LockTable!!";
        assert (lockTablePLI.size() == 0) : "Lock table on pessimistic lock interceptor should be empty";
        assert (lockTableUI.size() == 0) : "Lock table on unlock interceptor should be empty";
        assert (spi.getNumberOfLocksHeld() == 0) : "Should have no stale locks!";
    }

    public void testPut() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.assertNoStaleLocks();
        this.tm.begin();
        this.cache.put(this.fqn, (Object)"k2", (Object)"v2");
        NodeSPI n = (NodeSPI)this.cache.getRoot().getChild(this.fqn);
        AssertJUnit.assertFalse((boolean)n.getLock().isReadLocked());
        AssertJUnit.assertTrue((boolean)n.getLock().isWriteLocked());
        AssertJUnit.assertTrue((boolean)n.getParent().getLock().isReadLocked());
        AssertJUnit.assertFalse((boolean)n.getParent().getLock().isWriteLocked());
        AssertJUnit.assertTrue((boolean)n.getParent().getParent().getLock().isReadLocked());
        AssertJUnit.assertFalse((boolean)n.getParent().getParent().getLock().isWriteLocked());
        this.tm.commit();
        this.assertNoStaleLocks();
    }

    public void testGet() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.assertNoStaleLocks();
        this.tm.begin();
        this.cache.get(this.fqn, (Object)"k2");
        NodeSPI n = (NodeSPI)this.cache.getRoot().getChild(this.fqn);
        AssertJUnit.assertTrue((boolean)n.getLock().isReadLocked());
        AssertJUnit.assertFalse((boolean)n.getLock().isWriteLocked());
        AssertJUnit.assertTrue((boolean)n.getParent().getLock().isReadLocked());
        AssertJUnit.assertFalse((boolean)n.getParent().getLock().isWriteLocked());
        AssertJUnit.assertTrue((boolean)n.getParent().getParent().getLock().isReadLocked());
        AssertJUnit.assertFalse((boolean)n.getParent().getParent().getLock().isWriteLocked());
        this.tm.commit();
        this.assertNoStaleLocks();
    }

    public void testRemove() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.assertNoStaleLocks();
        this.tm.begin();
        this.cache.remove(this.fqn, (Object)"k2");
        NodeSPI n = (NodeSPI)this.cache.getRoot().getChild(this.fqn);
        AssertJUnit.assertFalse((boolean)n.getLock().isReadLocked());
        AssertJUnit.assertTrue((boolean)n.getLock().isWriteLocked());
        AssertJUnit.assertTrue((boolean)n.getParent().getLock().isReadLocked());
        AssertJUnit.assertFalse((boolean)n.getParent().getLock().isWriteLocked());
        AssertJUnit.assertTrue((boolean)n.getParent().getParent().getLock().isReadLocked());
        AssertJUnit.assertFalse((boolean)n.getParent().getParent().getLock().isWriteLocked());
        this.tm.commit();
        this.assertNoStaleLocks();
    }
}

