/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.marshall.MyList;
import org.jboss.cache.marshall.MyMap;
import org.jboss.cache.marshall.MySet;
import org.jboss.cache.marshall.SelectedClassnameClassLoader;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class CustomCollectionTest {
    private Cache<Object, Object> cache1 = null;
    private Cache<Object, Object> cache2 = null;
    private String myListClass = MyList.class.getName();
    private String mySetClass = MySet.class.getName();
    private String myMapClass = MyMap.class.getName();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache1 = this.createCache();
        this.cache2 = this.createCache();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache1.stop();
        this.cache2.stop();
    }

    public void testMap() throws Exception {
        this.doMapTest(false);
    }

    public void testMapWithRegions() throws Exception {
        this.doMapTest(true);
    }

    public void testSet() throws Exception {
        this.doSetTest(false);
    }

    public void testSetWithRegions() throws Exception {
        this.doSetTest(true);
    }

    public void testList() throws Exception {
        this.doListTest(false);
    }

    public void testListWithRegions() throws Exception {
        this.doListTest(true);
    }

    private void doMapTest(boolean contextClassLoader) throws Exception {
        ClassLoader customClassLoader = this.getClassLoader();
        Class<?> mapClass = customClassLoader.loadClass(this.myMapClass);
        Map map = (Map)(contextClassLoader ? mapClass.newInstance() : new MyMap());
        map.put("k", "v");
        if (contextClassLoader) {
            this.enableRegionBasedClassLoading(customClassLoader);
        }
        this.cache1.start();
        this.cache2.start();
        this.cache1.put(CustomCollectionTest.fqn("/a"), (Object)"key", (Object)map);
        Object o = this.cache2.get(CustomCollectionTest.fqn("/a"), (Object)"key");
        AssertJUnit.assertTrue((boolean)(o instanceof Map));
        if (contextClassLoader) {
            AssertJUnit.assertNotSame(MyMap.class, o.getClass());
            AssertJUnit.assertSame(mapClass, o.getClass());
        } else {
            AssertJUnit.assertSame(MyMap.class, o.getClass());
            AssertJUnit.assertNotSame(mapClass, o.getClass());
        }
        AssertJUnit.assertEquals((Object)"v", ((Map)o).get("k"));
    }

    private void doSetTest(boolean contextClassLoader) throws Exception {
        ClassLoader customClassLoader = this.getClassLoader();
        Class<?> setClass = customClassLoader.loadClass(this.mySetClass);
        Set set = (Set)(contextClassLoader ? setClass.newInstance() : new MySet());
        set.add("k");
        if (contextClassLoader) {
            this.enableRegionBasedClassLoading(customClassLoader);
        }
        this.cache1.start();
        this.cache2.start();
        this.cache1.put(CustomCollectionTest.fqn("/a"), (Object)"key", (Object)set);
        Object o = this.cache2.get(CustomCollectionTest.fqn("/a"), (Object)"key");
        AssertJUnit.assertTrue((boolean)(o instanceof Set));
        if (contextClassLoader) {
            AssertJUnit.assertNotSame(MySet.class, o.getClass());
            AssertJUnit.assertSame(setClass, o.getClass());
        } else {
            AssertJUnit.assertSame(MySet.class, o.getClass());
            AssertJUnit.assertNotSame(setClass, o.getClass());
        }
        AssertJUnit.assertTrue((boolean)((Set)o).contains("k"));
    }

    private void doListTest(boolean contextClassLoader) throws Exception {
        ClassLoader customClassLoader = this.getClassLoader();
        Class<?> listClass = customClassLoader.loadClass(this.myListClass);
        List list = (List)(contextClassLoader ? listClass.newInstance() : new MyList());
        list.add("k");
        if (contextClassLoader) {
            this.enableRegionBasedClassLoading(customClassLoader);
        }
        this.cache1.start();
        this.cache2.start();
        this.cache1.put(CustomCollectionTest.fqn("/a"), (Object)"key", (Object)list);
        Object o = this.cache2.get(CustomCollectionTest.fqn("/a"), (Object)"key");
        AssertJUnit.assertTrue((boolean)(o instanceof List));
        if (contextClassLoader) {
            AssertJUnit.assertSame(listClass, o.getClass());
            AssertJUnit.assertNotSame(MyList.class, o.getClass());
        } else {
            AssertJUnit.assertSame(MyList.class, o.getClass());
            AssertJUnit.assertNotSame(listClass, o.getClass());
        }
        AssertJUnit.assertTrue((boolean)((List)o).contains("k"));
    }

    public void testHarnessClassLoader() throws Exception {
        Class<?> myListFromCustomLoader = this.getClassLoader().loadClass(this.myListClass);
        AssertJUnit.assertNotNull(myListFromCustomLoader);
        AssertJUnit.assertFalse((boolean)MyList.class.equals(myListFromCustomLoader));
        Object customLoaderMyList = myListFromCustomLoader.newInstance();
        try {
            MyList m = (MyList)customLoaderMyList;
            AssertJUnit.fail((String)"Should have barfed");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void enableRegionBasedClassLoading(ClassLoader customClassLoader) {
        this.cache1.getConfiguration().setUseRegionBasedMarshalling(true);
        Region region1 = this.cache1.getRegion(CustomCollectionTest.fqn("/a"), true);
        region1.registerContextClassLoader(customClassLoader);
        this.cache2.getConfiguration().setUseRegionBasedMarshalling(true);
        Region region2 = this.cache2.getRegion(CustomCollectionTest.fqn("/a"), true);
        region2.registerContextClassLoader(customClassLoader);
    }

    private ClassLoader getClassLoader() {
        String[] includesClasses = new String[]{this.myListClass, this.mySetClass, this.myMapClass};
        String[] excludesClasses = new String[]{};
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return new SelectedClassnameClassLoader(includesClasses, excludesClasses, cl);
    }

    private Cache<Object, Object> createCache() {
        Cache cache = new DefaultCacheFactory().createCache(false);
        cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        return cache;
    }

    private static Fqn fqn(String fqn) {
        return Fqn.fromString((String)fqn);
    }
}

