/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.RPCManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;

public class ReplicationQueue {
    private static Log log = LogFactory.getLog(ReplicationQueue.class);
    private long interval = 5000L;
    private long max_elements = 500L;
    private final List<MethodCall> elements = new LinkedList<MethodCall>();
    private Timer timer = null;
    private MyTask task = null;
    private RPCManager rpcManager;
    private Configuration configuration;
    private boolean enabled;

    public boolean isEnabled() {
        return this.enabled;
    }

    @Inject
    private void injectDependencies(RPCManager rpcManager, Configuration configuration) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.enabled = configuration.isUseReplQueue() && (configuration.getBuddyReplicationConfig() == null || !configuration.getBuddyReplicationConfig().isEnabled());
    }

    @Start
    public synchronized void start() {
        this.interval = this.configuration.getReplQueueInterval();
        this.max_elements = this.configuration.getReplQueueMaxElements();
        boolean bl = this.enabled = this.configuration.isUseReplQueue() && (this.configuration.getBuddyReplicationConfig() == null || !this.configuration.getBuddyReplicationConfig().isEnabled());
        if (this.enabled && this.interval > 0L) {
            if (this.task == null) {
                this.task = new MyTask();
            }
            if (this.timer == null) {
                this.timer = new Timer(true);
                this.timer.schedule((TimerTask)this.task, 500L, this.interval);
            }
        }
    }

    @Stop
    public synchronized void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MethodCall job) {
        if (job == null) {
            throw new NullPointerException("job is null");
        }
        List<MethodCall> list = this.elements;
        synchronized (list) {
            this.elements.add(job);
            if ((long)this.elements.size() >= this.max_elements) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ArrayList<MethodCall> l;
        List<MethodCall> list = this.elements;
        synchronized (list) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("flush(): flushing repl queue (num elements=" + this.elements.size() + ")"));
            }
            l = new ArrayList<MethodCall>(this.elements);
            this.elements.clear();
        }
        if (l.size() > 0) {
            try {
                this.rpcManager.callRemoteMethods(null, MethodCallFactory.create(14, l), false, true, 5000, false);
            }
            catch (Throwable t) {
                log.error((Object)("failed replicating " + l.size() + " elements in replication queue"), t);
            }
        }
    }

    class MyTask
    extends TimerTask {
        MyTask() {
        }

        public void run() {
            ReplicationQueue.this.flush();
        }
    }
}

