/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.CacheStoreInterceptorMBean;
import org.jboss.cache.interceptors.MethodDispacherInterceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheStoreInterceptor
extends MethodDispacherInterceptor
implements CacheStoreInterceptorMBean {
    protected CacheLoaderConfig loaderConfig = null;
    protected TransactionManager tx_mgr = null;
    protected TransactionTable tx_table = null;
    private HashMap m_txStores = new HashMap();
    private Map<GlobalTransaction, Set<Fqn>> preparingTxs = new ConcurrentHashMap<GlobalTransaction, Set<Fqn>>();
    private long m_cacheStores = 0L;
    protected CacheLoader loader;

    public CacheStoreInterceptor() {
        this.initLogger();
    }

    @Start
    protected void startInterceptor() {
        this.loader = this.cache.getCacheLoaderManager().getCacheLoader();
        this.loaderConfig = this.cache.getCacheLoaderManager().getCacheLoaderConfig();
        this.tx_mgr = this.cache.getTransactionManager();
        this.tx_table = this.cache.getTransactionTable();
    }

    @Override
    protected boolean skipMethodCall(InvocationContext ctx) {
        if (!ctx.isOriginLocal() && this.loaderConfig.isShared()) {
            if (this.trace) {
                this.log.trace((Object)"Passing up method call and bypassing this interceptor since the cache loader is shared and this call originated remotely.");
            }
            return true;
        }
        return false;
    }

    @Override
    protected Object handleCommitMethod(InvocationContext ctx, GlobalTransaction gtx) throws Throwable {
        if (this.inTransaction()) {
            if (this.trace) {
                this.log.trace((Object)"transactional so don't put stuff in the cloader yet.");
            }
            if (ctx.isTxHasMods()) {
                if (this.trace) {
                    this.log.trace((Object)("Calling loader.commit() for gtx " + gtx));
                }
                try {
                    this.loader.commit(gtx);
                }
                catch (Throwable t) {
                    this.preparingTxs.remove(gtx);
                    throw t;
                }
                if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
                    Integer puts = (Integer)this.m_txStores.get(gtx);
                    if (puts != null) {
                        this.m_cacheStores += (long)puts.intValue();
                    }
                    this.m_txStores.remove(gtx);
                }
                Object returnValue = this.nextInterceptor(ctx);
                Set<Fqn> affectedFqns = this.preparingTxs.remove(gtx);
                if (affectedFqns != null) {
                    this.storeInternalState(ctx, affectedFqns);
                }
                return returnValue;
            }
            if (this.trace) {
                this.log.trace((Object)"Commit called with no modifications; ignoring.");
            }
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleRollbackMethod(InvocationContext ctx, GlobalTransaction gtx) throws Throwable {
        if (this.inTransaction()) {
            if (this.trace) {
                this.log.trace((Object)"transactional so don't put stuff in the cloader yet.");
            }
            if (ctx.isTxHasMods()) {
                if (this.preparingTxs.containsKey(gtx)) {
                    this.preparingTxs.remove(gtx);
                    this.loader.rollback(gtx);
                }
                if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
                    this.m_txStores.remove(gtx);
                }
            } else if (this.trace) {
                this.log.trace((Object)"Rollback called with no modifications; ignoring.");
            }
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleOptimisticPrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modifications, Map data, Address address, boolean onePhaseCommit) throws Throwable {
        if (this.inTransaction()) {
            if (this.trace) {
                this.log.trace((Object)"transactional so don't put stuff in the cloader yet.");
            }
            this.prepareCacheLoader(gtx, ctx.getMethodCall().isOnePhaseCommitPrepareMehod());
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handlePrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modification, Address coordinator, boolean onePhaseCommit) throws Throwable {
        if (this.inTransaction()) {
            if (this.trace) {
                this.log.trace((Object)"transactional so don't put stuff in the cloader yet.");
            }
            this.prepareCacheLoader(gtx, ctx.getMethodCall().isOnePhaseCommitPrepareMehod());
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleRemoveNodeMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        if (!this.inTransaction()) {
            this.loader.remove(fqn);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleRemoveKeyMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, boolean createUndoOps) throws Throwable {
        if (!this.inTransaction()) {
            Object returnValue = this.loader.remove(fqn, key);
            this.nextInterceptor(ctx);
            return returnValue;
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleRemoveDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        if (!this.inTransaction()) {
            this.loader.removeData(fqn);
            NodeSPI n = this.peekNode(ctx, fqn, false, false, false);
            if (n != null) {
                n.setDataLoaded(true);
            }
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleMoveMethod(InvocationContext ctx, Fqn from, Fqn to) throws Throwable {
        Object returnValue = this.nextInterceptor(ctx);
        if (this.inTransaction()) {
            return returnValue;
        }
        Fqn<Object> newNodeFqn = new Fqn<Object>(to, from.getLastElement());
        this.recursiveMove(from, newNodeFqn);
        this.loader.remove(from);
        return returnValue;
    }

    @Override
    protected Object handlePutDataEraseMethod(InvocationContext ctx, GlobalTransaction gt, Fqn fqn, Map newData, boolean createUndoOps, boolean eraseContents) throws Throwable {
        Object returnValue = this.nextInterceptor(ctx);
        if (this.inTransaction()) {
            return returnValue;
        }
        this.loader.removeData(fqn);
        NodeSPI n = this.peekNode(ctx, fqn, false, false, false);
        n.setDataLoaded(true);
        return returnValue;
    }

    @Override
    protected Object handlePutDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Map data, boolean createUndoOps) throws Throwable {
        Object returnValue = this.nextInterceptor(ctx);
        if (this.inTransaction()) {
            return returnValue;
        }
        this.loader.put(fqn, data);
        if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
            ++this.m_cacheStores;
        }
        return returnValue;
    }

    @Override
    protected Object handlePutForExternalReadMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, Object value) throws Throwable {
        return this.handlePutKeyValue(ctx, fqn, key, value);
    }

    @Override
    protected Object handlePutKeyValueMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps) throws Throwable {
        return this.handlePutKeyValue(ctx, fqn, key, value);
    }

    private Object handlePutKeyValue(InvocationContext ctx, Fqn fqn, Object key, Object value) throws Throwable {
        Object returnValue = this.nextInterceptor(ctx);
        if (this.inTransaction()) {
            return returnValue;
        }
        returnValue = this.loader.put(fqn, key, value);
        if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
            ++this.m_cacheStores;
        }
        return returnValue;
    }

    private boolean inTransaction() throws SystemException {
        return this.tx_mgr != null && this.tx_mgr.getTransaction() != null;
    }

    private void storeInternalState(InvocationContext ctx, Set<Fqn> affectedFqns) throws Exception {
        if (this.cache.getConfiguration().isNodeLockingOptimistic()) {
            for (Fqn f : affectedFqns) {
                NodeSPI n = this.peekNode(ctx, f, false, false, false);
                if (n == null) continue;
                Map internalState = n.getInternalState(true);
                this.loader.put(f, internalState);
            }
        }
    }

    private void recursiveMove(Fqn fqn, Fqn newFqn) throws Exception {
        ArrayList<Fqn> fqns = new ArrayList<Fqn>();
        fqns.add(fqn);
        fqns.add(newFqn);
        this.loader.put(newFqn, this.loader.get(fqn));
        Set<?> childrenNames = this.loader.getChildrenNames(fqn);
        if (childrenNames != null) {
            for (Object child : childrenNames) {
                this.recursiveMove(new Fqn<Object>(fqn, child), new Fqn<Object>(newFqn, child));
            }
        }
    }

    @Override
    public long getCacheLoaderStores() {
        return this.m_cacheStores;
    }

    @Override
    public void resetStatistics() {
        this.m_cacheStores = 0L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("CacheLoaderStores", this.m_cacheStores);
        return retval;
    }

    private void prepareCacheLoader(GlobalTransaction gtx, boolean onePhase) throws Exception {
        int txPuts = 0;
        TransactionEntry entry = this.tx_table.get(gtx);
        if (entry == null) {
            throw new Exception("entry for transaction " + gtx + " not found in transaction table");
        }
        HashSet<Fqn> affectedFqns = new HashSet<Fqn>();
        List<MethodCall> modifications = entry.getCacheLoaderModifications();
        if (modifications.size() == 0) {
            if (this.trace) {
                this.log.trace((Object)"Transaction has not logged any modifications!");
            }
            return;
        }
        if (this.trace) {
            this.log.trace((Object)("Cache loader modification list: " + modifications));
        }
        ArrayList<Modification> cache_loader_modifications = new ArrayList<Modification>();
        for (MethodCall methodCall : modifications) {
            Modification mod = this.convertMethodCallToModification(methodCall, affectedFqns);
            cache_loader_modifications.add(mod);
            if (!this.configuration.getExposeManagementStatistics() || !this.getStatisticsEnabled() || mod.getType() != Modification.ModificationType.PUT_DATA && mod.getType() != Modification.ModificationType.PUT_DATA_ERASE && mod.getType() != Modification.ModificationType.PUT_KEY_VALUE) continue;
            ++txPuts;
        }
        if (this.trace) {
            this.log.trace((Object)("Converted method calls to cache loader modifications.  List size: " + cache_loader_modifications.size()));
        }
        if (cache_loader_modifications.size() > 0) {
            this.loader.prepare(gtx, cache_loader_modifications, onePhase);
            this.preparingTxs.put(gtx, affectedFqns);
            if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled() && txPuts > 0) {
                this.m_txStores.put(gtx, txPuts);
            }
        }
    }

    private Modification convertMethodCallToModification(MethodCall methodCall, Set<Fqn> affectedFqns) throws Exception {
        Modification mod;
        Method method;
        if (this.trace) {
            this.log.trace((Object)("Converting method call " + (Object)((Object)methodCall) + " to modification."));
        }
        if ((method = methodCall.getMethod()) == null) {
            throw new Exception("method call has no method: " + (Object)((Object)methodCall));
        }
        Object[] args = methodCall.getArgs();
        Fqn fqn = (Fqn)args[1];
        switch (methodCall.getMethodId()) {
            case 1: {
                mod = new Modification(Modification.ModificationType.PUT_DATA, fqn, (Map)args[2]);
                break;
            }
            case 2: {
                mod = new Modification(Modification.ModificationType.PUT_DATA_ERASE, fqn, (Map)args[2]);
                break;
            }
            case 3: {
                mod = new Modification(Modification.ModificationType.PUT_KEY_VALUE, fqn, args[2], args[3]);
                break;
            }
            case 5: {
                mod = new Modification(Modification.ModificationType.REMOVE_NODE, fqn);
                break;
            }
            case 6: {
                mod = new Modification(Modification.ModificationType.REMOVE_KEY_VALUE, fqn, args[2]);
                break;
            }
            case 7: {
                mod = new Modification(Modification.ModificationType.REMOVE_DATA, fqn);
                break;
            }
            case 36: {
                Fqn moveFrom = (Fqn)args[0];
                affectedFqns.add(moveFrom);
                mod = new Modification(Modification.ModificationType.MOVE, moveFrom, fqn);
                break;
            }
            default: {
                throw new CacheException("method call " + method.getName() + " cannot be converted to a modification");
            }
        }
        affectedFqns.add(fqn);
        if (this.trace) {
            this.log.trace((Object)("Converted " + (Object)((Object)methodCall) + " to Modification of type " + (Object)((Object)mod.getType())));
        }
        return mod;
    }
}

