/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import java.util.Map;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jgroups.Address;

public class OptimisticLockingInterceptor
extends OptimisticInterceptor {
    private long lockAcquisitionTimeout;

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.lockAcquisitionTimeout = cache.getConfiguration().getLockAcquisitionTimeout();
    }

    public OptimisticLockingInterceptor() {
        this.initLogger();
    }

    protected Object handleOptimisticPrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modifications, Map data, Address address, boolean onePhaseCommit) throws Throwable {
        gtx = this.getGlobalTransaction(ctx);
        long timeout = this.lockAcquisitionTimeout;
        if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getLockAcquisitionTimeout() >= 0) {
            timeout = ctx.getOptionOverrides().getLockAcquisitionTimeout();
        }
        try {
            TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
            TransactionEntry te = this.cache.getTransactionTable().get(gtx);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Locking nodes in transaction workspace for GlobalTransaction " + gtx));
            }
            for (WorkspaceNode workspaceNode : workspace.getNodes().values()) {
                NodeSPI node = workspaceNode.getNode();
                boolean isWriteLockNeeded = workspaceNode.isDirty() || workspaceNode.isChildrenModified() && (this.configuration.isLockParentForChildInsertRemove() || node.isLockForChildInsertRemove());
                boolean acquired = node.getLock().acquire(gtx, timeout, isWriteLockNeeded ? NodeLock.LockType.WRITE : NodeLock.LockType.READ);
                if (acquired) {
                    if (this.trace) {
                        this.log.trace((Object)("Acquired lock on node " + node.getFqn()));
                    }
                    te.addLock(node.getLock());
                    continue;
                }
                throw new CacheException("Unable to acquire lock on node " + node.getFqn());
            }
        }
        catch (Throwable e) {
            this.log.debug((Object)"Caught exception attempting to lock nodes ", e);
            try {
                this.unlock(gtx);
            }
            catch (Throwable t) {
                this.log.error((Object)"Failed to unlock nodes, after failing to lock nodes during a prepare!  Locks are possibly in a very inconsistent state now!", t);
            }
            throw e;
        }
        return this.nextInterceptor(ctx);
    }

    protected Object handleCommitMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        return this.transactionFinalized(ctx);
    }

    protected Object handleRollbackMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        return this.transactionFinalized(ctx);
    }

    protected Object handleLockMethod(InvocationContext ctx, Fqn fqn, NodeLock.LockType lockType, boolean recursive) {
        throw new CacheException("_lock() passed up the interceptor stack when Optimistic Locking is used.  This is NOT supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object transactionFinalized(InvocationContext ctx) throws Throwable {
        Object retval = null;
        try {
            retval = this.nextInterceptor(ctx);
        }
        finally {
            try {
                this.unlock(this.getGlobalTransaction(ctx));
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to unlock nodes after a commit or rollback!  Locks are possibly in a very inconsistent state now!", (Throwable)e);
            }
        }
        return retval;
    }

    private void unlock(GlobalTransaction gtx) {
        TransactionEntry entry = this.txTable.get(gtx);
        entry.releaseAllLocksFIFO(gtx);
    }
}

