/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import java.util.List;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.cache.Cache;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxUtil {
    public static final String JBOSS_SERVER_DOMAIN = "jboss";
    public static final String JBOSS_CACHE_DOMAIN = "jboss.cache";
    public static final String SERVICE_KEY_NAME = "service";
    public static final String BASE_PREFIX = "jboss.cache:service=JBossCache";
    public static final String CLUSTER_KEY = "cluster";
    public static final String PREFIX = "jboss.cache:service=JBossCache,cluster=";
    public static final String UNIQUE_ID_KEY = "uniqueId";
    public static final String NO_CLUSTER_PREFIX = "jboss.cache:service=JBossCache,uniqueId=";
    public static final String CACHE_TYPE_KEY = "cacheType";
    public static final String PLAIN_CACHE_TYPE = "Cache";
    public static final String MBEAN_CLASS_SUFFIX = "MBean";
    public static final String INTERCEPTOR_KEY = ",cache-interceptor=";

    public static void registerCacheMBean(MBeanServer server, CacheJmxWrapperMBean cache, String cacheObjectName) throws JMException {
        ObjectName on = new ObjectName(cacheObjectName);
        if (!server.isRegistered(on)) {
            server.registerMBean(cache, on);
        }
    }

    public static void registerInterceptors(MBeanServer server, List<Interceptor> interceptors, String cacheObjectName) throws JMException {
        if (server == null || interceptors == null || cacheObjectName == null) {
            return;
        }
        for (Interceptor interceptor : interceptors) {
            if (!interceptor.getStatisticsEnabled()) continue;
            boolean mbeanExists = true;
            try {
                Class.forName(interceptor.getClass().getName() + MBEAN_CLASS_SUFFIX);
            }
            catch (Throwable e) {
                mbeanExists = false;
            }
            String className = interceptor.getClass().getName();
            String serviceName = cacheObjectName + INTERCEPTOR_KEY + className.substring(className.lastIndexOf(46) + 1);
            ObjectName objName = new ObjectName(serviceName);
            if (server.isRegistered(objName) || !mbeanExists) continue;
            server.registerMBean(interceptor, objName);
        }
    }

    public static String getDefaultCacheObjectName(Cache cache) {
        return JmxUtil.getDefaultCacheObjectName(cache.getConfiguration(), cache.getClass().getName());
    }

    public static String getDefaultCacheObjectName(Configuration config, String cacheImplClass) {
        String tmpName = null;
        tmpName = config.getClusterName() == null ? NO_CLUSTER_PREFIX + JmxUtil.getUniqueId(cacheImplClass) : PREFIX + config.getClusterName();
        return tmpName;
    }

    public static String getUniqueId(String cacheImplClass) {
        return cacheImplClass + System.currentTimeMillis();
    }

    public static void unregisterCacheMBean(MBeanServer server, String cacheObjectName) throws Exception {
        server.unregisterMBean(new ObjectName(cacheObjectName));
    }

    public static void unregisterInterceptors(MBeanServer server, List<Interceptor> interceptors, String cacheObjectName) throws Exception {
        if (server == null || interceptors == null || cacheObjectName == null) {
            return;
        }
        for (Interceptor interceptor : interceptors) {
            String className = interceptor.getClass().getName();
            String serviceName = cacheObjectName + INTERCEPTOR_KEY + className.substring(className.lastIndexOf(46) + 1);
            ObjectName objName = new ObjectName(serviceName);
            if (!server.isRegistered(objName)) continue;
            server.unregisterMBean(objName);
        }
    }
}

