/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.ConnectionFactory;

public class ManagedConnectionFactory
implements ConnectionFactory {
    private static final Log log = LogFactory.getLog(ManagedConnectionFactory.class);
    private DataSource dataSource;
    private String datasourceName;

    public void setConfig(AdjListJDBCCacheLoaderConfig config) {
        this.datasourceName = config.getDatasourceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() throws Exception {
        InitialContext ctx;
        block8: {
            ctx = null;
            ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.datasourceName);
            if (!log.isTraceEnabled()) break block8;
            log.trace((Object)("Datasource lookup for " + this.datasourceName + " succeded: " + this.dataSource));
        }
        Object var4_2 = null;
        if (ctx == null) return;
        try {
            ctx.close();
            return;
        }
        catch (NamingException e2) {
            log.warn((Object)"Failed to close naming context.", (Throwable)e2);
        }
        return;
        {
            catch (NamingException e) {
                this.reportAndRethrowError("Failed to lookup datasource " + this.datasourceName, e);
                Object var4_3 = null;
                if (ctx == null) return;
                try {
                    ctx.close();
                    return;
                }
                catch (NamingException e2) {
                    log.warn((Object)"Failed to close naming context.", (Throwable)e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (ctx == null) throw throwable;
            try {
                ctx.close();
                throw throwable;
            }
            catch (NamingException e2) {
                log.warn((Object)"Failed to close naming context.", (Throwable)e2);
            }
            throw throwable;
        }
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Connection checked out: " + connection));
        }
        return connection;
    }

    public void prepare(Object txId) {
    }

    public void commit(Object txId) {
    }

    public void rollback(Object txId) {
    }

    public void close(Connection con) {
        this.safeClose(con);
    }

    public void stop() {
    }

    private void safeClose(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.warn((Object)"Failed to close connection", (Throwable)e);
            }
        }
    }

    private void reportAndRethrowError(String message, Exception cause) throws IllegalStateException {
        log.error((Object)message, (Throwable)cause);
        throw new IllegalStateException(message, cause);
    }
}

