/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.jdbm;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.jdbm.JdbmCacheLoaderConfig;
import org.jboss.cache.loader.jdbm.JdbmFqnComparator;
import org.jboss.cache.loader.jdbm.Null;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class JdbmCacheLoader
extends AbstractCacheLoader {
    private static final Log log = LogFactory.getLog(JdbmCacheLoader.class);
    private static final String KEYS = "K";
    private static final String NODE = "N";
    private static final String NAME = "JdbmCacheLoader";
    private JdbmCacheLoaderConfig config;
    private String cacheDbName;
    private RecordManager recman;
    private BTree tree;

    @Override
    public void create() throws Exception {
        this.checkNotOpen();
    }

    @Override
    public void start() throws Exception {
        File homeDir;
        boolean created;
        File location;
        log.trace((Object)"Starting JdbmCacheLoader instance.");
        this.checkNotOpen();
        this.checkNonNull(this.cache, "CacheSPI object is required");
        String locationStr = this.config.getLocation();
        if (locationStr == null) {
            locationStr = System.getProperty("java.io.tmpdir");
            this.config.setLocation(locationStr);
        }
        if (!(location = new File(locationStr)).exists() && !(created = location.mkdirs())) {
            throw new IOException("Unable to create cache loader location " + location);
        }
        if (!location.isDirectory()) {
            throw new IOException("Cache loader location [" + location + "] is not a directory!");
        }
        int offset = locationStr.indexOf(35);
        if (offset >= 0 && offset < locationStr.length() - 1) {
            homeDir = new File(locationStr.substring(0, offset));
            this.cacheDbName = locationStr.substring(offset + 1);
        } else {
            homeDir = new File(locationStr);
            this.cacheDbName = this.cache.getClusterName();
        }
        try {
            this.openDatabase(new File(homeDir, this.cacheDbName));
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    private void openDatabase(File f) throws Exception {
        Properties props = new Properties();
        this.recman = RecordManagerFactory.createRecordManager((String)f.toString(), (Properties)props);
        long recid = this.recman.getNamedObject(NAME);
        log.debug((Object)("JdbmCacheLoader located as " + recid));
        if (recid == 0L) {
            this.tree = BTree.createInstance((RecordManager)this.recman, (Comparator)new JdbmFqnComparator());
            this.recman.setNamedObject(NAME, this.tree.getRecid());
        } else {
            this.tree = BTree.load((RecordManager)this.recman, (long)recid);
        }
        log.info((Object)("JDBM database " + f + " opened with " + this.tree.size() + " entries"));
    }

    private void closeDatabases() {
        if (this.recman != null) {
            try {
                this.recman.close();
            }
            catch (Exception shouldNotOccur) {
                log.warn((Object)"Caught unexpected exception", (Throwable)shouldNotOccur);
            }
        }
        this.recman = null;
        this.tree = null;
    }

    @Override
    public void stop() {
        log.debug((Object)"stop");
        this.closeDatabases();
    }

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.checkNotOpen();
        this.config = base instanceof JdbmCacheLoaderConfig ? (JdbmCacheLoaderConfig)base : new JdbmCacheLoaderConfig(base);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Configuring cache loader with location = " + this.config.getLocation()));
        }
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    @Override
    public void setCache(CacheSPI c) {
        super.setCache(c);
        this.checkNotOpen();
    }

    private Fqn keys(Fqn name) {
        return new Fqn<Object>(name, new Object[]{KEYS});
    }

    private Fqn key(Fqn name, Object key) {
        return new Fqn<Object>(name, new Object[]{KEYS, this.nullMask(key)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getChildrenNames(Fqn name) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getChildrenNames " + name));
        }
        BTree bTree = this.tree;
        synchronized (bTree) {
            return this.getChildrenNames0(name);
        }
    }

    private Set<String> getChildrenNames0(Fqn name) throws IOException {
        Fqn fqn;
        int size;
        Tuple t;
        TupleBrowser browser = this.tree.browse((Object)name);
        if (browser.getNext(t = new Tuple())) {
            if (!t.getValue().equals(NODE)) {
                log.trace((Object)" not a node");
                return null;
            }
        } else {
            log.trace((Object)" no nodes");
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        int depth = name.size() + 1;
        while (browser.getNext(t) && (size = (fqn = (Fqn)t.getKey()).size()) >= depth) {
            if (size != depth || !t.getValue().equals(NODE)) continue;
            set.add((String)fqn.getLastElement());
        }
        if (set.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map get(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.tree.find((Object)name) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("get, no node: " + name));
            }
            return null;
        }
        Fqn keys = this.keys(name);
        Tuple t = new Tuple();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        BTree bTree = this.tree;
        synchronized (bTree) {
            Fqn fqn;
            TupleBrowser browser = this.tree.browse((Object)keys);
            while (browser.getNext(t) && (fqn = (Fqn)t.getKey()).isChildOf(keys)) {
                Object k = fqn.getLastElement();
                Object v = t.getValue();
                map.put(this.nullUnmask(k), this.nullUnmask(v));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("get " + name + " map=" + map));
        }
        return map;
    }

    @Override
    public boolean exists(Fqn name) throws IOException {
        return this.tree.find((Object)name) != null;
    }

    private void commit() throws Exception {
        this.recman.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        Object object;
        try {
            object = this.put0(name, key, value);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.commit();
            throw throwable;
        }
        this.commit();
        return object;
    }

    private Object put0(Fqn name, Object key, Object value) throws Exception {
        this.checkNonNull(name, "name");
        this.makeNode(name);
        Fqn rec = this.key(name, key);
        Object oldValue = this.insert(rec, value);
        if (log.isTraceEnabled()) {
            log.trace((Object)("put " + rec + " value=" + value + " old=" + oldValue));
        }
        return oldValue;
    }

    public void put(Fqn name, Map values) throws Exception {
        this.put0(name, values);
        this.commit();
    }

    private void put0(Fqn name, Map<?, ?> values) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("put " + name + " values=" + values));
        }
        this.makeNode(name);
        if (values == null) {
            return;
        }
        for (Map.Entry<?, ?> me : values.entrySet()) {
            Fqn rec = this.key(name, me.getKey());
            this.insert(rec, this.nullMask(me.getValue()));
        }
    }

    private void makeNode(Fqn fqn) throws IOException {
        int size;
        Fqn child;
        Object existing;
        if (this.exists(fqn)) {
            return;
        }
        for (int i = size = fqn.size(); i >= 0 && (existing = this.tree.insert(child = fqn.getAncestor(i), (Object)NODE, false)) == null; --i) {
        }
    }

    private Object insert(Fqn fqn, Object value) throws IOException {
        return this.nullUnmask(this.tree.insert((Object)fqn, this.nullMask(value), true));
    }

    private void erase0(Fqn name) throws IOException {
        this.erase0(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void erase0(Fqn name, boolean self) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("erase " + name + " self=" + self));
        }
        BTree bTree = this.tree;
        synchronized (bTree) {
            Fqn fqn;
            TupleBrowser browser = this.tree.browse((Object)name);
            Tuple t = new Tuple();
            if (browser.getNext(t) && self) {
                this.tree.remove(t.getKey());
            }
            while (browser.getNext(t) && (fqn = (Fqn)t.getKey()).isChildOf(name)) {
                this.tree.remove((Object)fqn);
            }
        }
    }

    private Object eraseKey0(Fqn name, Object key) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("eraseKey " + name + " key " + key));
        }
        Fqn fqnKey = this.key(name, key);
        try {
            return this.tree.remove((Object)fqnKey);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
        this.checkOpen();
        this.checkNonNull(modifications, "modifications");
        super.put(modifications);
        this.commit();
    }

    @Override
    public void remove(Fqn name) throws Exception {
        this.erase0(name);
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Fqn name, Object key) throws Exception {
        Object object;
        try {
            object = this.eraseKey0(name, key);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.commit();
            throw throwable;
        }
        this.commit();
        return object;
    }

    @Override
    public void removeData(Fqn name) throws Exception {
        this.erase0(name, false);
    }

    private void checkOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Operation not allowed before calling create()");
        }
    }

    private void checkNotOpen() {
        if (this.tree != null) {
            throw new IllegalStateException("Operation not allowed after calling create()");
        }
    }

    private void checkNonNull(Object param, String paramName) {
        if (param == null) {
            throw new NullPointerException("Parameter must not be null: " + paramName);
        }
    }

    private Object nullMask(Object o) {
        return o == null ? Null.NULL : o;
    }

    private Object nullUnmask(Object o) {
        return o == Null.NULL ? null : o;
    }

    public void dump() throws IOException {
        this.dump(Fqn.ROOT);
    }

    public void dump(Object key) throws IOException {
        TupleBrowser browser = this.tree.browse(key);
        Tuple t = new Tuple();
        log.debug((Object)("contents: " + key));
        while (browser.getNext(t)) {
            log.debug((Object)(t.getKey() + "\t" + t.getValue()));
        }
        log.debug((Object)"");
    }

    public String toString() {
        BTree bt = this.tree;
        int size = bt == null ? -1 : bt.size();
        return "JdbmCacheLoader locationStr=" + this.config.getLocation() + " size=" + size;
    }
}

