/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.invocation.CacheInvocationDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachePrinter {
    public static String printCacheDetails(Cache c) {
        CacheImpl ci = ((CacheInvocationDelegate)c).getDelegationTarget();
        return ci.printDetails();
    }

    public static String printCacheLockingInfo(Cache c) {
        CacheImpl ci = ((CacheInvocationDelegate)c).getDelegationTarget();
        return ci.printLockInfo();
    }

    public static String printCacheInterceptors(CacheSPI<?, ?> cache) {
        StringBuilder b = new StringBuilder();
        int index = 0;
        b.append("\n");
        for (Interceptor i : cache.getInterceptorChain()) {
            b.append("# ");
            b.append(index);
            b.append(" : ");
            b.append(i);
            b.append("\n");
            ++index;
        }
        return b.toString();
    }

    public static String printInterceptorChain(Interceptor i) {
        StringBuffer sb = new StringBuffer();
        if (i != null) {
            if (i.getNext() != null) {
                sb.append(CachePrinter.printInterceptorChain(i.getNext())).append("\n");
            }
            sb.append(">> ");
            sb.append(i.getClass().getName());
        }
        return sb.toString();
    }
}

