/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.ElementSizeConfiguration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class ElementSizeConfigurationTest {
    public void testXMLParse1() throws Exception {
        ElementSizeConfiguration config = new ElementSizeConfiguration();
        String xml = "<region name=\"abc\"><attribute name=\"maxNodes\">1000</attribute><attribute name=\"maxElementsPerNode\">100</attribute></region>";
        Element element = XmlHelper.stringToElement((String)xml);
        XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)config);
        AssertJUnit.assertEquals((int)100, (int)config.getMaxElementsPerNode());
        AssertJUnit.assertEquals((int)1000, (int)config.getMaxNodes());
    }

    public void testXMLParse2() throws Exception {
        ElementSizeConfiguration config = new ElementSizeConfiguration();
        String xml = "<region name=\"abc\"><attribute name=\"maxNodes\">1000</attribute></region>";
        Element element = XmlHelper.stringToElement((String)xml);
        try {
            XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)config);
        }
        catch (ConfigurationException ce) {
            AssertJUnit.assertTrue((String)"Configure exception properly thrown", (boolean)true);
            return;
        }
        AssertJUnit.fail((String)"Invalid region Element Size configuration did not cause ConfigureException to be thrown with empty maxElementsPerNode attribute");
    }

    public void testXMLParse3() throws Exception {
        ElementSizeConfiguration config = new ElementSizeConfiguration();
        String xml = "<region name=\"abc\"><attribute name=\"maxElementsPerNode\">100</attribute></region>";
        Element element = XmlHelper.stringToElement((String)xml);
        XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)config);
        AssertJUnit.assertEquals((int)100, (int)config.getMaxElementsPerNode());
        AssertJUnit.assertEquals((int)0, (int)config.getMaxNodes());
    }
}

