/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.cache.eviction.ElementSizeQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ElementSizeQueueTest {
    private ElementSizeQueue queue;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.queue = new ElementSizeQueue();
    }

    public void testQueue() throws Exception {
        NodeEntry ne;
        for (int i = 0; i < 500; ++i) {
            ne = new NodeEntry("/a/b/c/" + Integer.toString(i));
            this.queue.addNodeEntry(ne);
        }
        this.queue.resortEvictionQueue();
        AssertJUnit.assertEquals((int)500, (int)this.queue.getNumberOfNodes());
        AssertJUnit.assertTrue((boolean)this.queue.containsNodeEntry(new NodeEntry("/a/b/c/250")));
        NodeEntry ne275 = this.queue.getNodeEntry("/a/b/c/275");
        AssertJUnit.assertEquals((String)"/a/b/c/275", (String)ne275.getFqn().toString());
        Iterator it = this.queue.iterate();
        int k = 0;
        while (it.hasNext()) {
            ne = (NodeEntry)it.next();
            AssertJUnit.assertEquals((String)("/a/b/c/" + Integer.toString(k)), (String)ne.getFqn().toString());
            if (k % 2 == 0) {
                ne.setNumberOfElements(k);
            }
            ++k;
        }
        this.queue.resortEvictionQueue();
        k = 0;
        while (it.hasNext()) {
            ne = (NodeEntry)it.next();
            System.out.println(ne.toString());
            if (k < 250) {
                AssertJUnit.assertEquals((int)k, (int)ne.getNumberOfElements());
                AssertJUnit.assertEquals((int)0, (int)(k % 2));
            } else {
                AssertJUnit.assertTrue((k % 2 != 0 ? 1 : 0) != 0);
                AssertJUnit.assertEquals((int)0, (int)ne.getNumberOfElements());
            }
            ++k;
        }
    }

    public void testPrune() throws Exception {
        for (int i = 0; i < 5000; ++i) {
            this.queue.addNodeEntry(new NodeEntry("/a/b/c/" + Integer.toString(i)));
        }
        Iterator it = this.queue.iterate();
        int i = 0;
        while (it.hasNext()) {
            NodeEntry ne = (NodeEntry)it.next();
            if (i % 2 == 0) {
                this.queue.removeNodeEntry(ne);
            }
            ++i;
        }
        AssertJUnit.assertEquals((int)2500, (int)this.queue.getNumberOfNodes());
        Set removalQueue = this.queue.getRemovalQueue();
        List evictionList = this.queue.getEvictionList();
        AssertJUnit.assertEquals((int)2500, (int)removalQueue.size());
        for (NodeEntry ne : removalQueue) {
            int currentIndex = Integer.parseInt((String)ne.getFqn().get(3));
            AssertJUnit.assertEquals((int)0, (int)(currentIndex % 2));
            AssertJUnit.assertFalse((boolean)this.queue.containsNodeEntry(ne));
            AssertJUnit.assertNull((Object)this.queue.getNodeEntry(ne.getFqn()));
            AssertJUnit.assertTrue((boolean)evictionList.contains(ne));
        }
        AssertJUnit.assertEquals((int)5000, (int)evictionList.size());
        this.queue.prune();
        AssertJUnit.assertEquals((int)0, (int)removalQueue.size());
        AssertJUnit.assertEquals((int)2500, (int)evictionList.size());
    }

    public void testGetFirstNodeEntry() throws Exception {
        NodeEntry ne;
        for (int i = 0; i < 500; ++i) {
            NodeEntry ne2 = new NodeEntry("/a/b/c/" + Integer.toString(i));
            this.queue.addNodeEntry(ne2);
            if (i % 2 != 0) continue;
            ne2.setNumberOfElements(2);
        }
        this.queue.resortEvictionQueue();
        int count = 0;
        while ((ne = this.queue.getFirstNodeEntry()) != null) {
            if (count < 250) {
                AssertJUnit.assertEquals((int)2, (int)ne.getNumberOfElements());
            } else {
                AssertJUnit.assertEquals((int)0, (int)ne.getNumberOfNodeVisits());
            }
            this.queue.removeNodeEntry(ne);
            ++count;
        }
        AssertJUnit.assertEquals((int)0, (int)this.queue.getNumberOfNodes());
    }

    public void testNumElements() throws Exception {
        int i;
        ElementSizeQueue queue = new ElementSizeQueue();
        NodeEntry ne = new NodeEntry("/a/b/c");
        ne.setNumberOfElements(50);
        queue.addNodeEntry(ne);
        queue.resortEvictionQueue();
        AssertJUnit.assertEquals((int)50, (int)queue.getNumberOfElements());
        AssertJUnit.assertEquals((int)1, (int)queue.getNumberOfNodes());
        queue.removeNodeEntry(ne);
        AssertJUnit.assertEquals((int)0, (int)queue.getNumberOfElements());
        for (i = 0; i < 10; ++i) {
            ne = new NodeEntry("/a/b/c/" + Integer.toString(i));
            ne.setNumberOfElements(i);
            queue.addNodeEntry(ne);
        }
        queue.resortEvictionQueue();
        AssertJUnit.assertEquals((int)45, (int)queue.getNumberOfElements());
        AssertJUnit.assertEquals((int)10, (int)queue.getNumberOfNodes());
        ne = queue.getNodeEntry("/a/b/c/0");
        AssertJUnit.assertNotNull((Object)ne);
        AssertJUnit.assertEquals((int)0, (int)ne.getNumberOfElements());
        ne.setNumberOfElements(500);
        AssertJUnit.assertEquals((int)545, (int)queue.getNumberOfElements());
        ne = queue.getNodeEntry("/a/b/c/0");
        AssertJUnit.assertEquals((int)500, (int)ne.getNumberOfElements());
        queue.resortEvictionQueue();
        ne = queue.getNodeEntry("/a/b/c/1");
        AssertJUnit.assertNotNull((Object)ne);
        AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfElements());
        queue.resortEvictionQueue();
        ne.setNumberOfElements(2);
        queue.resortEvictionQueue();
        AssertJUnit.assertEquals((int)546, (int)queue.getNumberOfElements());
        queue.removeNodeEntry(ne);
        AssertJUnit.assertEquals((int)544, (int)queue.getNumberOfElements());
        AssertJUnit.assertEquals((int)9, (int)queue.getNumberOfNodes());
        queue.removeNodeEntry(queue.getNodeEntry("/a/b/c/0"));
        for (i = 2; i < 10; ++i) {
            ne = queue.getNodeEntry("/a/b/c/" + Integer.toString(i));
            AssertJUnit.assertEquals((int)i, (int)ne.getNumberOfElements());
            queue.removeNodeEntry(ne);
        }
        AssertJUnit.assertEquals((int)0, (int)queue.getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)queue.getNumberOfElements());
    }
}

