/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.RPCManager;
import org.jboss.cache.RegionManager;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.EmptyConstructorFactory;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.CacheMarshaller210;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ComponentRegistryFunctionalTest {
    private ComponentRegistry cr;
    private Configuration configuration;

    @BeforeMethod
    public void setUp() throws Exception {
        DefaultCacheFactory cf = new DefaultCacheFactory();
        Cache cache = cf.createCache(false);
        this.cr = TestingUtil.extractComponentRegistry(cache);
        this.configuration = cache.getConfiguration();
    }

    public void testDefaultFactoryScanning() {
        this.cr.scanDefaultFactories();
        assert (this.cr.defaultFactories != null) : "Should be populated";
        assert (this.cr.defaultFactories.containsKey(Marshaller.class));
        assert (((Class)this.cr.defaultFactories.get(Marshaller.class)).equals(EmptyConstructorFactory.class));
        assert (this.cr.defaultFactories.containsKey(Notifier.class));
        assert (((Class)this.cr.defaultFactories.get(Notifier.class)).equals(EmptyConstructorFactory.class));
    }

    public void testDependencyConsistency() {
        for (ComponentRegistry.Component component : this.cr.componentLookup.values()) {
            for (ComponentRegistry.Component dep : component.dependencies) {
                assert (((ComponentRegistry.Component)this.cr.componentLookup.get((Object)dep.name)).dependencyFor.contains(component)) : "Dependency " + dep.name + " does not have component " + component.name + " in it's dependencyFor collection.";
            }
        }
        for (ComponentRegistry.Component component : this.cr.componentLookup.values()) {
            for (ComponentRegistry.Component dep : component.dependencyFor) {
                assert (((ComponentRegistry.Component)this.cr.componentLookup.get((Object)dep.name)).dependencies.contains(component)) : "Dependency " + dep.name + " does not have component " + component.name + " in it's dependencies collection.";
            }
        }
    }

    public void testNamedComponents() {
        this.cr.registerComponent("blah", new Object(), Object.class);
        Object namedComponent1 = this.cr.getOrCreateComponent("blah", Object.class);
        Object namedComponent2 = this.cr.getOrCreateComponent("blah", Object.class);
        assert (namedComponent1 == namedComponent2);
    }

    public void testConstructionOrder1() {
        Class<Marshaller> componentToTest = Marshaller.class;
        Marshaller m = (Marshaller)this.cr.getOrCreateComponent(null, componentToTest);
        assert (m instanceof VersionAwareMarshaller);
        VersionAwareMarshaller vam = (VersionAwareMarshaller)m;
        vam.initReplicationVersions();
        m = (Marshaller)TestingUtil.extractField(vam, "defaultMarshaller");
        assert (m instanceof CacheMarshaller210);
    }

    public void testConstructionOrder2() {
        Class<Marshaller> componentToTest = Marshaller.class;
        this.configuration.setMarshallerClass(CacheMarshaller200.class.getName());
        CacheMarshaller210 instance = new CacheMarshaller210();
        this.configuration.setCacheMarshaller((Marshaller)instance);
        this.cr.unregisterComponent(Marshaller.class);
        this.cr.updateDependencies();
        Marshaller m = (Marshaller)this.cr.getOrCreateComponent(null, componentToTest);
        assert (m == instance) : "m is " + m + " but expected " + instance;
    }

    public void testConstructionOrder3() {
        Class<Marshaller> componentToTest = Marshaller.class;
        CacheMarshaller210 instance = new CacheMarshaller210();
        this.configuration.setCacheMarshaller((Marshaller)instance);
        this.cr.unregisterComponent(Marshaller.class);
        this.cr.updateDependencies();
        Marshaller m = (Marshaller)this.cr.getOrCreateComponent(null, componentToTest);
        assert (m == instance) : "m is " + m + " but expected " + instance;
    }

    public void testConstructionOrder4() {
        Class<Marshaller> componentToTest = Marshaller.class;
        this.configuration.setMarshallerClass(CacheMarshaller200.class.getName());
        Marshaller m = (Marshaller)this.cr.getOrCreateComponent(null, componentToTest);
        assert (m instanceof VersionAwareMarshaller);
        VersionAwareMarshaller vam = (VersionAwareMarshaller)m;
        vam.initReplicationVersions();
        m = (Marshaller)TestingUtil.extractField(vam, "defaultMarshaller");
        assert (m instanceof CacheMarshaller200);
    }

    public void testTransitiveDependencies() {
        Class<BuddyManager> componentToTest = BuddyManager.class;
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        BuddyReplicationConfig.BuddyLocatorConfig blc = new BuddyReplicationConfig.BuddyLocatorConfig();
        blc.setBuddyLocatorClass(NextMemberBuddyLocator.class.getName());
        brc.setBuddyLocatorConfig(blc);
        this.configuration.setBuddyReplicationConfig(brc);
        BuddyManager bm = (BuddyManager)this.cr.getOrCreateComponent(null, componentToTest);
        assert (bm != null);
        StateTransferManager stm = (StateTransferManager)TestingUtil.extractField(bm, "stateTransferManager");
        assert (stm != null);
        RPCManager rpcm = (RPCManager)TestingUtil.extractField(bm, "rpcManager");
        assert (rpcm != null);
        RegionManager rm = (RegionManager)TestingUtil.extractField(bm, "regionManager");
        assert (rm != null);
        Configuration cfg = (Configuration)TestingUtil.extractField(bm, "configuration");
        assert (cfg == this.configuration);
    }

    public void testInjectionOrder() {
        this.cr.defaultFactories.put(Test1.class, EmptyConstructorFactory.class);
        this.cr.defaultFactories.put(Test2.class, EmptyConstructorFactory.class);
        this.cr.defaultFactories.put(Test3.class, EmptyConstructorFactory.class);
        Test1 t1 = (Test1)this.cr.getOrCreateComponent(null, Test1.class);
        assert (t1 != null);
        assert (t1.test2 != null);
        assert (t1.test2.test3 != null);
        assert (t1.someValue == t1.test2.test3.someValue);
    }

    public static class Test3 {
        private boolean someValue = true;
    }

    public static class Test2 {
        private Test3 test3;

        @Inject
        public void setTest3(Test3 test3) {
            this.test3 = test3;
        }
    }

    public static class Test1 {
        private Test2 test2;
        private boolean someValue = false;

        @Inject
        public void setTest2(Test2 test2) {
            this.test2 = test2;
            this.someValue = test2.test3.someValue;
        }
    }
}

