/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ObjectInputStream;
import org.jboss.cache.Version;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.marshall.AbstractVersionAwareMarshallerTest;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.CacheMarshaller210;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.jboss.cache.marshall.io.ObjectStreamPool;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class VersionAwareMarshallerTest
extends AbstractVersionAwareMarshallerTest {
    @BeforeMethod
    public void setUp() {
        this.cr = new ComponentRegistry(new Configuration());
    }

    @AfterMethod
    public void tearDown() {
        this.cr = null;
    }

    public void testMarshallerSelection() {
        VersionAwareMarshaller marshaller = this.createVAMandRestartCache("2.1.0.GA");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = this.createVAMandRestartCache("2.0.0.GA");
        AssertJUnit.assertEquals(CacheMarshaller200.class, marshaller.defaultMarshaller.getClass());
        marshaller = this.createVAMandRestartCache("1.4.0.GA");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = this.createVAMandRestartCache("1.5.0.GA");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = this.createVAMandRestartCache("1.3.0.GA");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = this.createVAMandRestartCache("1.3.0.SP2");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = this.createVAMandRestartCache("1.3.1.GA");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = this.createVAMandRestartCache("1.2.4.SP2");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = this.createVAMandRestartCache("1.2.3");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
    }

    public void testVersionHeaderDefaultCurrent() throws Exception {
        VersionAwareMarshaller marshaller = this.createVAMandRestartCache(Version.getVersionString((short)Version.getVersionShort()));
        byte[] bytes = marshaller.objectToByteBuffer((Object)"Hello");
        ObjectStreamPool pool = (ObjectStreamPool)TestingUtil.extractField(marshaller, "pool");
        ObjectInputStream in = pool.getInputStream(bytes);
        AssertJUnit.assertEquals((String)"Version header short should be '21'", (int)21, (int)in.readShort());
    }

    public void testVersionHeader200() throws Exception {
        VersionAwareMarshaller marshaller = this.createVAMandRestartCache("2.0.0.GA");
        byte[] bytes = marshaller.objectToByteBuffer((Object)"Hello");
        ObjectStreamPool pool = (ObjectStreamPool)TestingUtil.extractField(marshaller, "pool");
        ObjectInputStream in = pool.getInputStream(bytes);
        AssertJUnit.assertEquals((String)"Version header short should be '20'", (int)20, (int)in.readShort());
    }
}

