/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.interceptors.CallInterceptor;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class NodeInterceptorRemoveNodeTest
extends AbstractOptimisticTestCase {
    private CacheSPI<Object, Object> cache;
    private TestListener listener;
    private MockInterceptor dummy;
    private TransactionManager mgr;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.listener = new TestListener();
        this.cache = this.createCacheWithListener(this.listener);
        this.dummy = new MockInterceptor();
        this.dummy.setCache(this.cache);
        this.cache.addInterceptor((Interceptor)this.dummy, CallInterceptor.class);
        this.cache.removeInterceptor(CallInterceptor.class);
        this.mgr = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        super.tearDown();
        this.cache.stop();
    }

    public void testTransactionRemoveNotExistsNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        this.cache.removeNode("/one/two");
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        this.mgr.commit();
        assert (2 == this.dummy.getAllCalled().size());
        assert (this.dummy.getAllCalled().contains(MethodDeclarations.commitMethod));
        assert (this.dummy.getAllCalled().contains(MethodDeclarations.optimisticPrepareMethod));
        AssertJUnit.assertEquals((int)0, (int)workspace.getNodes().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)0, (int)this.listener.getNodesAdded());
    }

    public void testTransactionRemoveNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("key1", "value");
        this.cache.put("/one/two", temp);
        this.cache.removeNode("/one/two");
        assert (this.dummy.getAllCalled().isEmpty());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        List mergedChildren = workspace.getNode(Fqn.fromString((String)"/one")).getMergedChildren();
        AssertJUnit.assertEquals((int)1, (int)((Set)mergedChildren.get(1)).size());
        System.out.println(entry.getModifications());
        AssertJUnit.assertEquals((int)2, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
    }

    public void testTransactionRemoveIntermediateNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("key1", "value");
        this.cache.put("/one/two", temp);
        this.cache.removeNode("/one");
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        AssertJUnit.assertEquals((int)1, (int)((Set)workspace.getNode(Fqn.fromString((String)"/one")).getMergedChildren().get(0)).size());
        AssertJUnit.assertEquals((int)2, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        assert (2 == this.dummy.getAllCalled().size());
        assert (this.dummy.getAllCalled().contains(MethodDeclarations.commitMethod));
        assert (this.dummy.getAllCalled().contains(MethodDeclarations.optimisticPrepareMethod));
    }

    public void testTransactionRemoveTwiceMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("key1", "value");
        this.cache.put("/one/two", temp);
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        workspace.getNode(Fqn.fromString((String)"/one"));
        workspace.getNode(Fqn.fromString((String)"/one/two"));
        this.cache.removeNode("/one");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        this.cache.removeNode("/one");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        assert (2 == this.dummy.getAllCalled().size());
        assert (this.dummy.getAllCalled().contains(MethodDeclarations.commitMethod));
        assert (this.dummy.getAllCalled().contains(MethodDeclarations.optimisticPrepareMethod));
    }

    public void testTransactionRemovePutNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("key1", "value");
        this.cache.put("/one/two", temp);
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        WorkspaceNode one = workspace.getNode(Fqn.fromString((String)"/one"));
        WorkspaceNode two = workspace.getNode(Fqn.fromString((String)"/one/two"));
        this.cache.removeNode("/one");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        this.cache.put("/one/two", temp);
        WorkspaceNode oneAfter = workspace.getNode(Fqn.fromString((String)"/one"));
        WorkspaceNode twoAfter = workspace.getNode(Fqn.fromString((String)"/one/two"));
        AssertJUnit.assertSame((Object)one, (Object)oneAfter);
        AssertJUnit.assertEquals((boolean)false, (boolean)oneAfter.isDeleted());
        AssertJUnit.assertSame((Object)two, (Object)twoAfter);
        AssertJUnit.assertEquals((boolean)false, (boolean)twoAfter.isDeleted());
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getModifications().size());
        assert (2 == this.dummy.getAllCalled().size());
        assert (this.dummy.getAllCalled().contains(MethodDeclarations.commitMethod));
        assert (this.dummy.getAllCalled().contains(MethodDeclarations.optimisticPrepareMethod));
        AssertJUnit.assertEquals((int)2, (int)this.listener.getNodesAdded());
    }

    public void testTransactionRemovePutkeyValMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("key1", "value");
        this.cache.put("/one/two", temp);
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        WorkspaceNode one = workspace.getNode(Fqn.fromString((String)"/one"));
        WorkspaceNode two = workspace.getNode(Fqn.fromString((String)"/one/two"));
        this.cache.removeNode("/one");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        this.cache.put(new Fqn(new Object[]{"one"}), (Object)"key1", (Object)"value2");
        WorkspaceNode oneAfter = workspace.getNode(Fqn.fromString((String)"/one"));
        WorkspaceNode twoAfter = workspace.getNode(Fqn.fromString((String)"/one/two"));
        AssertJUnit.assertSame((Object)one, (Object)oneAfter);
        AssertJUnit.assertEquals((boolean)false, (boolean)oneAfter.isDeleted());
        AssertJUnit.assertEquals((Object)two, (Object)twoAfter);
        AssertJUnit.assertEquals((boolean)true, (boolean)twoAfter.isDeleted());
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        this.mgr.commit();
        AssertJUnit.assertEquals((Object)"value2", (Object)workspace.getNode(Fqn.fromString((String)"/one")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        assert (2 == this.dummy.getAllCalled().size());
        assert (this.dummy.getAllCalled().contains(MethodDeclarations.commitMethod));
        assert (this.dummy.getAllCalled().contains(MethodDeclarations.optimisticPrepareMethod));
        AssertJUnit.assertEquals((int)2, (int)this.listener.getNodesAdded());
    }

    public void testTransactionRemoveSubNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("key1", "value");
        this.cache.put("/one/two", temp);
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        WorkspaceNode one = workspace.getNode(Fqn.fromString((String)"/one"));
        AssertJUnit.assertEquals((int)1, (int)((Set)one.getMergedChildren().get(0)).size());
        this.cache.removeNode("/one/two");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        this.mgr.commit();
        AssertJUnit.assertEquals((int)1, (int)((Set)workspace.getNode(Fqn.fromString((String)"/one")).getMergedChildren().get(1)).size());
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertEquals((int)2, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        assert (2 == this.dummy.getAllCalled().size());
        assert (this.dummy.getAllCalled().contains(MethodDeclarations.commitMethod));
        assert (this.dummy.getAllCalled().contains(MethodDeclarations.optimisticPrepareMethod));
        AssertJUnit.assertEquals((int)2, (int)this.listener.getNodesAdded());
    }
}

