/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.replicated;

import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.invocation.CacheInvocationDelegate;
import org.jboss.cache.invocation.RemoteCacheInvocationDelegate;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"})
public class SyncReplTest {
    private Cache[] caches;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        System.out.println("*** In setUp()");
        this.caches = new Cache[2];
        this.caches[0] = new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC));
        this.caches[1] = new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC));
        TestingUtil.blockUntilViewsReceived(this.caches, 5000L);
        System.out.println("*** Finished setUp()");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        System.out.println("*** In tearDown()");
        if (this.caches != null) {
            for (Cache c : this.caches) {
                c.stop();
            }
            this.caches = null;
        }
        System.out.println("*** Finished tearDown()");
    }

    public void testBasicOperation() {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        this.assertInvocationContextInitState();
        Fqn f = Fqn.fromString((String)"/test/data");
        String k = "key";
        String v = "value";
        AssertJUnit.assertNull((String)"Should be null", (Object)this.caches[0].getRoot().getChild(f));
        AssertJUnit.assertNull((String)"Should be null", (Object)this.caches[1].getRoot().getChild(f));
        Node node = this.caches[0].getRoot().addChild(f);
        assert (((NodeSPI)node).getCache() instanceof CacheInvocationDelegate);
        assert (!(((NodeSPI)node).getCache() instanceof RemoteCacheInvocationDelegate));
        AssertJUnit.assertNotNull((String)"Should not be null", (Object)node);
        node.put((Object)k, (Object)v);
        AssertJUnit.assertEquals((Object)v, (Object)node.get((Object)k));
        AssertJUnit.assertEquals((Object)v, (Object)this.caches[0].get(f, (Object)k));
        AssertJUnit.assertEquals((String)"Should have replicated", (Object)v, (Object)this.caches[1].get(f, (Object)k));
    }

    public void testSyncRepl() {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        this.assertInvocationContextInitState();
        Fqn fqn = Fqn.fromString((String)"/JSESSIONID/1010.10.5:3000/1234567890/1");
        this.caches[0].getConfiguration().setSyncCommitPhase(true);
        this.caches[1].getConfiguration().setSyncCommitPhase(true);
        this.caches[0].put(fqn, (Object)"age", (Object)38);
        AssertJUnit.assertEquals((String)"Value should be set", (Object)38, (Object)this.caches[0].get(fqn, (Object)"age"));
        AssertJUnit.assertEquals((String)"Value should have replicated", (Object)38, (Object)this.caches[1].get(fqn, (Object)"age"));
    }

    public void testNodeConvenienceNodeRemoval() {
        Fqn fqn = Fqn.fromString((String)"/test/fqn");
        this.caches[0].getRoot().addChild(fqn);
        AssertJUnit.assertTrue((boolean)this.caches[0].getRoot().hasChild(fqn));
        AssertJUnit.assertTrue((boolean)this.caches[1].getRoot().hasChild(fqn));
        AssertJUnit.assertEquals((boolean)true, (boolean)this.caches[0].removeNode(fqn));
        AssertJUnit.assertFalse((boolean)this.caches[0].getRoot().hasChild(fqn));
        AssertJUnit.assertFalse((boolean)this.caches[1].getRoot().hasChild(fqn));
        AssertJUnit.assertEquals((boolean)false, (boolean)this.caches[0].removeNode(fqn));
        Fqn child = Fqn.fromString((String)"/test/fqn/child");
        this.caches[0].getRoot().addChild(child);
        AssertJUnit.assertTrue((boolean)this.caches[0].getRoot().hasChild(child));
        AssertJUnit.assertTrue((boolean)this.caches[1].getRoot().hasChild(child));
        AssertJUnit.assertEquals((boolean)true, (boolean)this.caches[0].removeNode(fqn));
        AssertJUnit.assertFalse((boolean)this.caches[0].getRoot().hasChild(fqn));
        AssertJUnit.assertFalse((boolean)this.caches[1].getRoot().hasChild(fqn));
        AssertJUnit.assertEquals((boolean)false, (boolean)this.caches[0].removeNode(fqn));
    }

    private void assertClusterSize(String message, int size) {
        for (Cache c : this.caches) {
            this.assertClusterSize(message, size, c);
        }
    }

    private void assertClusterSize(String message, int size, Cache c) {
        AssertJUnit.assertEquals((String)message, (int)size, (int)c.getMembers().size());
    }

    private void assertInvocationContextInitState() {
        for (Cache c : this.caches) {
            this.assertInvocationContextInitState(c);
        }
    }

    private void assertInvocationContextInitState(Cache c) {
        InvocationContext ctx = c.getInvocationContext();
        InvocationContext control = null;
        try {
            control = ctx.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        control.reset();
        control.setOptionOverrides(new Option());
        AssertJUnit.assertEquals((String)"Should be equal", (Object)control, (Object)ctx);
    }
}

