/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.event.NodeEvent;
import org.jboss.cache.statetransfer.StateTransferTestBase;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, enabled=false)
public class ForcedStateTransferTest
extends StateTransferTestBase {
    public void testActiveTransaction() throws Exception {
        String[] values = new String[]{"A", "B", "C"};
        this.transactionTest(values, false, "REPEATABLE_READ");
    }

    public void testRollbackOnlyTransaction() throws Exception {
        String[] values = new String[]{"A", "B", "C"};
        this.transactionTest(values, true, "REPEATABLE_READ");
    }

    private void transactionTest(String[] values, boolean rollback, String isolationLevel) throws Exception {
        CacheSPI<Object, Object> sender = this.initializeSender(isolationLevel, false, false);
        TaskRunner[] runners = this.initializeTransactionRunners(values, sender, "/LOCK", rollback);
        CacheSPI<Object, Object> receiver = this.startReceiver(isolationLevel, false, false);
        this.checkResults(receiver, runners, false);
    }

    private CacheSPI<Object, Object> initializeSender(String isolationLevel, boolean replSync, boolean useMarshalling) throws Exception {
        CacheSPI<Object, Object> sender = this.createCache("sender", isolationLevel, replSync, useMarshalling, true);
        if (useMarshalling) {
            sender.getRegion(Fqn.ROOT, true).activate();
        }
        sender.put(Fqn.fromString((String)"/OK"), (Object)"KEY", (Object)"X");
        return sender;
    }

    private TxRunner[] initializeTransactionRunners(String[] values, CacheSPI<Object, Object> sender, String rootFqn, boolean rollback) {
        TxRunner[] runners = new TxRunner[values.length];
        for (int i = 0; i < values.length; ++i) {
            runners[i] = new TxRunner(sender, rootFqn, values[i], rollback);
            this.initializeRunner(runners[i]);
        }
        return runners;
    }

    private void initializeRunner(TaskRunner runner) {
        runner.start();
        long start = System.currentTimeMillis();
        while (!runner.isAsleep()) {
            AssertJUnit.assertTrue((String)(runner.getClass().getName() + " " + runner.value + " is alive"), (boolean)runner.isAlive());
            AssertJUnit.assertFalse((String)(runner.getClass().getName() + " " + runner.value + " has not timed out"), (System.currentTimeMillis() - start > 1000L ? 1 : 0) != 0);
        }
    }

    private void checkResults(CacheSPI<Object, Object> receiver, TaskRunner[] runners, boolean allowValues) throws CacheException {
        int i;
        boolean[] aliveStates = new boolean[runners.length];
        for (i = 0; i < runners.length; ++i) {
            aliveStates[i] = runners[i].isAlive();
            if (!aliveStates[i]) continue;
            runners[i].interrupt();
        }
        AssertJUnit.assertEquals((String)"OK value correct", (Object)"X", (Object)receiver.get(Fqn.fromString((String)"/OK"), (Object)"KEY"));
        for (i = 0; i < runners.length; ++i) {
            AssertJUnit.assertTrue((String)("Runner " + runners[i].value + " was alive"), (boolean)aliveStates[i]);
            AssertJUnit.assertNull((String)("Runner " + runners[i].value + " ran cleanly"), (Object)runners[i].failure);
            if (allowValues) {
                AssertJUnit.assertEquals((String)("Correct value in " + runners[i].fqn), (Object)runners[i].value, (Object)receiver.get(runners[i].fqn, (Object)"KEY"));
                continue;
            }
            AssertJUnit.assertNull((String)("No value in " + runners[i].fqn), (Object)receiver.get(runners[i].fqn, (Object)"KEY"));
        }
    }

    public void testHungThread() throws Exception {
        CacheSPI<Object, Object> sender = this.initializeSender("REPEATABLE_READ", false, false);
        String[] values = new String[]{"A", "B", "C"};
        TaskRunner[] runners = this.initializeHangThreadRunners(values, sender, "/LOCK");
        CacheSPI<Object, Object> receiver = this.startReceiver("REPEATABLE_READ", false, false);
        this.checkResults(receiver, runners, true);
    }

    private HangThreadRunner[] initializeHangThreadRunners(String[] values, CacheSPI<Object, Object> sender, String rootFqn) {
        HangThreadRunner[] runners = new HangThreadRunner[values.length];
        for (int i = 0; i < values.length; ++i) {
            runners[i] = new HangThreadRunner(sender, rootFqn, values[i]);
            this.initializeRunner(runners[i]);
        }
        return runners;
    }

    public void testBeforeCompletionLock() throws Exception {
        this.synchronizationTest(true);
    }

    public void testAfterCompletionLock() throws Exception {
        this.synchronizationTest(false);
    }

    private void synchronizationTest(boolean hangBefore) throws Exception {
        CacheSPI<Object, Object> sender = this.initializeSender("REPEATABLE_READ", false, false);
        String[] values = new String[]{"A", "B", "C"};
        TaskRunner[] runners = this.initializeSynchronizationTxRunners(values, sender, "/LOCK", hangBefore);
        CacheSPI<Object, Object> receiver = this.startReceiver("REPEATABLE_READ", false, false);
        this.checkResults(receiver, runners, !hangBefore);
    }

    private SynchronizationTxRunner[] initializeSynchronizationTxRunners(String[] values, CacheSPI<Object, Object> sender, String rootFqn, boolean hangBefore) {
        SynchronizationTxRunner[] runners = new SynchronizationTxRunner[values.length];
        for (int i = 0; i < values.length; ++i) {
            runners[i] = new SynchronizationTxRunner(sender, rootFqn, values[i], hangBefore);
            this.initializeRunner(runners[i]);
        }
        return runners;
    }

    public void testMultipleProblems() throws Exception {
        this.multipleProblemTest("REPEATABLE_READ", "/LOCK", false, false);
    }

    public void testSerializableIsolation() throws Exception {
        this.multipleProblemTest("SERIALIZABLE", "/", false, false);
    }

    public void testPartialStateTransfer() throws Exception {
        this.multipleProblemTest("REPEATABLE_READ", "/LOCK", false, true);
    }

    public void testReplSync() throws Exception {
        this.multipleProblemTest("REPEATABLE_READ", "/LOCK", true, false);
    }

    private void multipleProblemTest(String isolationLevel, String rootFqn, boolean replSync, boolean useMarshalling) throws Exception {
        CacheSPI<Object, Object> sender = this.initializeSender(isolationLevel, replSync, useMarshalling);
        String[] val1 = new String[]{"A", "B", "C"};
        TaskRunner[] after = this.initializeSynchronizationTxRunners(val1, sender, rootFqn, false);
        String[] val2 = new String[]{"D", "E", "F"};
        TaskRunner[] before = this.initializeSynchronizationTxRunners(val2, sender, rootFqn, true);
        String[] val3 = new String[]{"G", "H", "I"};
        TaskRunner[] active = this.initializeTransactionRunners(val3, sender, rootFqn, false);
        String[] val4 = new String[]{"J", "K", "L"};
        TaskRunner[] rollback = this.initializeTransactionRunners(val4, sender, rootFqn, true);
        String[] val5 = new String[]{"M", "N", "O"};
        TaskRunner[] threads = this.initializeHangThreadRunners(val5, sender, rootFqn);
        CacheSPI<Object, Object> receiver = this.startReceiver(isolationLevel, replSync, useMarshalling);
        this.checkResults(receiver, active, false);
        this.checkResults(receiver, rollback, false);
        this.checkResults(receiver, before, false);
        this.checkResults(receiver, after, true);
        this.checkResults(receiver, threads, true);
    }

    @Override
    protected String getReplicationVersion() {
        return "2.1.0.CR4";
    }

    private CacheSPI<Object, Object> startReceiver(String isolationLevel, boolean replSync, boolean useMarshalling) throws Exception {
        CacheSPI<Object, Object> receiver = this.createCache("receiver", isolationLevel, replSync, useMarshalling, false);
        CacheStarter starter = new CacheStarter(receiver, useMarshalling);
        starter.start();
        starter.join(20000L);
        boolean alive = starter.isAlive();
        if (alive) {
            starter.interrupt();
        }
        AssertJUnit.assertFalse((String)"Starter finished", (boolean)alive);
        AssertJUnit.assertNull((String)"No exceptions in starter", (Object)starter.failure);
        return receiver;
    }

    private CacheSPI<Object, Object> createCache(String cacheID, String isolationLevel, boolean replSync, boolean useMarshalling, boolean startCache) throws Exception {
        CacheSPI<Object, Object> result = super.createCache(cacheID, replSync, useMarshalling, false, false, false, true);
        result.getConfiguration().setStateRetrievalTimeout(0L);
        result.getConfiguration().setLockAcquisitionTimeout(1000L);
        result.getConfiguration().setIsolationLevel(isolationLevel);
        if (startCache) {
            result.start();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizationTxRunner
    extends TaskRunner {
        Transaction tx = null;
        HangThreadSynchronization sync;

        SynchronizationTxRunner(CacheSPI<Object, Object> cache, String rootFqn, String value, boolean hangBefore) {
            super(cache, rootFqn, value);
            this.sync = new HangThreadSynchronization(hangBefore);
        }

        @Override
        void executeTask() throws Exception {
            TransactionManager tm = this.cache.getTransactionManager();
            tm.begin();
            this.tx = tm.getTransaction();
            this.tx.registerSynchronization((Synchronization)this.sync);
            this.cache.put(this.fqn, (Object)"KEY", (Object)this.value);
            tm.commit();
        }

        @Override
        boolean isAsleep() {
            return this.sync.asleep;
        }

        @Override
        boolean isDone() {
            return this.sync.done;
        }
    }

    static class HangThreadSynchronization
    implements Synchronization {
        boolean asleep;
        boolean hangBefore;
        boolean done;

        HangThreadSynchronization(boolean hangBefore) {
            this.hangBefore = hangBefore;
        }

        public void beforeCompletion() {
            if (this.hangBefore) {
                this.hang();
            }
        }

        public void afterCompletion(int status) {
            if (!this.hangBefore) {
                this.hang();
            }
        }

        void hang() {
            this.asleep = true;
            TestingUtil.sleepThread(30000L);
            this.done = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HangThreadRunner
    extends TaskRunner {
        HangThreadListener listener;

        HangThreadRunner(CacheSPI<Object, Object> cache, String rootFqn, String value) {
            super(cache, rootFqn, value);
            this.listener = new HangThreadListener(this.fqn);
            cache.addCacheListener((Object)this.listener);
        }

        @Override
        void executeTask() throws Exception {
            this.cache.put(this.fqn, (Object)"KEY", (Object)this.value);
        }

        @Override
        boolean isAsleep() {
            return this.listener.asleep;
        }

        @Override
        boolean isDone() {
            return this.listener.done;
        }
    }

    @CacheListener
    static class HangThreadListener {
        boolean asleep;
        Fqn toHang;
        boolean alreadyHung;
        boolean done;

        HangThreadListener(Fqn toHang) {
            this.toHang = toHang;
        }

        @NodeModified
        public void nodeModified(NodeEvent e) {
            if (!e.isPre()) {
                this.hangThread(e.getFqn());
            }
        }

        private void hangThread(Fqn fqn) {
            if (!this.alreadyHung && this.toHang.equals((Object)fqn)) {
                this.asleep = true;
                this.alreadyHung = true;
                TestingUtil.sleepThread(30000L);
                this.done = true;
                this.asleep = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TxRunner
    extends TaskRunner {
        TransactionManager tm = null;
        boolean rollback = false;
        boolean done = true;

        TxRunner(CacheSPI<Object, Object> cache, String rootFqn, String value, boolean rollback) {
            super(cache, rootFqn, value);
            this.rollback = rollback;
        }

        @Override
        void executeTask() throws Exception {
            this.tm = this.cache.getTransactionManager();
            this.tm.begin();
            this.cache.put(this.fqn, (Object)"KEY", (Object)this.value);
            if (this.rollback) {
                this.tm.setRollbackOnly();
            }
            this.asleep = true;
            TestingUtil.sleepThread(25000L);
            this.done = true;
        }

        @Override
        void finalCleanup() {
            if (this.tm != null) {
                try {
                    this.tm.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        boolean isDone() {
            return this.done;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class TaskRunner
    extends Thread {
        CacheSPI<Object, Object> cache;
        Fqn fqn;
        String value;
        Exception failure;
        boolean asleep = false;

        TaskRunner(CacheSPI<Object, Object> cache, String rootFqn, String value) {
            this.cache = cache;
            this.value = value;
            this.fqn = new Fqn(Fqn.fromString((String)rootFqn), (Object[])new String[]{value});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.executeTask();
            }
            catch (Exception e) {
                if (!this.isDone()) {
                    this.failure = e;
                }
            }
            finally {
                this.asleep = false;
                this.finalCleanup();
            }
        }

        abstract void executeTask() throws Exception;

        abstract boolean isDone();

        void finalCleanup() {
        }

        boolean isAsleep() {
            return this.asleep;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheStarter
    extends Thread {
        CacheSPI<Object, Object> cache;
        boolean useMarshalling;
        Exception failure;

        CacheStarter(CacheSPI<Object, Object> cache, boolean useMarshalling) {
            this.cache = cache;
            this.useMarshalling = useMarshalling;
        }

        @Override
        public void run() {
            try {
                this.cache.start();
                if (this.useMarshalling) {
                    TestingUtil.blockUntilViewReceived(this.cache, 2, 60000L);
                    this.cache.getRegion(Fqn.ROOT, true).activate();
                }
            }
            catch (Exception e) {
                this.failure = e;
            }
        }
    }
}

