/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.transaction.DummyBaseTransactionManager;
import org.jboss.cache.transaction.DummyTransaction;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.DummyUserTransaction;

public class AsyncRollbackTransactionManager
extends DummyTransactionManager {
    private static final long serialVersionUID = 5793952292960075970L;
    static AsyncRollbackTransactionManager instance = null;
    private static Log log = LogFactory.getLog(AsyncRollbackTransactionManager.class);
    private Thread timedOutTransactionsChecker = null;
    private int timeout = 30;
    private Map<Long, AsyncRollbackTransaction> txMap = new HashMap<Long, AsyncRollbackTransaction>();

    public static DummyTransactionManager getInstance() {
        if (instance == null) {
            instance = new AsyncRollbackTransactionManager();
            try {
                Properties p = new Properties();
                p.put("java.naming.factory.initial", "org.jboss.cache.transaction.DummyContextFactory");
                InitialContext ctx = new InitialContext(p);
                ctx.bind("java:/TransactionManager", (Object)instance);
                ctx.bind("UserTransaction", (Object)new DummyUserTransaction((DummyTransactionManager)instance));
            }
            catch (NamingException e) {
                log.error((Object)"binding of DummyTransactionManager failed", (Throwable)e);
            }
        }
        return instance;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.timeout = seconds;
    }

    public AsyncRollbackTransactionManager() {
        this.timedOutTransactionsChecker = new TimedOutTransactionsChecker();
        this.timedOutTransactionsChecker.start();
    }

    public void begin() throws NotSupportedException, SystemException {
        Transaction currentTx = this.getTransaction();
        if (currentTx != null) {
            throw new NotSupportedException(Thread.currentThread() + " is already associated with a transaction (" + currentTx + ")");
        }
        AsyncRollbackTransaction tx = new AsyncRollbackTransaction((DummyBaseTransactionManager)this, this.timeout);
        this.setTransaction((Transaction)tx);
        this.txMap.put(tx.generateTransactionId(), tx);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.removeTxFromMap((AsyncRollbackTransaction)this.getTransaction());
        super.rollback();
    }

    public void removeTxFromMap(AsyncRollbackTransaction tx) throws SystemException {
        if (tx != null) {
            this.txMap.remove(tx.getTransactionId());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        AsyncRollbackTransaction tx = (AsyncRollbackTransaction)this.getTransaction();
        if (tx != null) {
            this.txMap.remove(tx.getTransactionId());
        }
        super.commit();
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        super.resume(tx);
    }

    public Transaction suspend() throws SystemException {
        return super.suspend();
    }

    static class AsyncRollbackTransaction
    extends DummyTransaction {
        private static long transactionNums = 0L;
        private long transactionId;
        private long beginTimeMillis;
        private int timeoutSec;

        public AsyncRollbackTransaction(DummyBaseTransactionManager tm, int timeout) {
            super(tm);
            this.timeoutSec = timeout;
            this.beginTimeMillis = System.currentTimeMillis();
        }

        public long getTransactionId() {
            return this.transactionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long generateTransactionId() {
            long result = 0L;
            Class<AsyncRollbackTransaction> clazz = AsyncRollbackTransaction.class;
            synchronized (AsyncRollbackTransaction.class) {
                result = ++transactionNums;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                this.transactionId = result;
                return result;
            }
        }

        final int getTimeoutSeconds() {
            return this.timeoutSec;
        }

        protected final void asyncRollback() throws SystemException {
            Thread asyncRollbackThread = new Thread(){

                public void run() {
                    try {
                        AsyncRollbackTransaction.this.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            ((AsyncRollbackTransactionManager)this.tm_).removeTxFromMap(this);
            asyncRollbackThread.start();
        }

        public void wakeUp() throws SystemException {
            if (this.isTransactionTimedOut()) {
                this.asyncRollback();
            }
        }

        private boolean isTransactionTimedOut() {
            return System.currentTimeMillis() - this.beginTimeMillis > (long)(this.timeoutSec * 1000);
        }
    }

    private class TimedOutTransactionsChecker
    extends Thread {
        private boolean running;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            while (this.running) {
                try {
                    Thread.sleep(500L);
                    TimedOutTransactionsChecker timedOutTransactionsChecker = this;
                    synchronized (timedOutTransactionsChecker) {
                        for (AsyncRollbackTransaction t : AsyncRollbackTransactionManager.this.txMap.values()) {
                            try {
                                t.wakeUp();
                            }
                            catch (SystemException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

