/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.interceptors;

import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.cache.Fqn;

/**
 * Interceptor (done via aop advice) to check the validity of the id specified by the user.
 *
 * @version $Id: CheckIdInterceptor.java 3892 2007-05-23 10:28:59Z msurtani $
 */
public class CheckIdInterceptor extends AbstractInterceptor
{
   public Object invoke(Invocation in) throws Throwable
   {
      if (!(in instanceof MethodInvocation))
      {
         throw new IllegalArgumentException("CheckIdInterceptor.invoke(): invocation not MethodInvocation");
      }

      MethodInvocation invocation = (MethodInvocation) in;
      invocation.getAdvisor();
      try
      {
         checkFqnValidity((Fqn) invocation.getArguments()[0]);
         return invocation.invokeNext(); // proceed to next advice or actual call
      }
      finally
      {
      }
   }


   private static void checkFqnValidity(Fqn id)
   {
      // throws exception is fqn is JBossInternal
//      if (id.hasElement(InternalConstant.JBOSS_INTERNAL_STRING))
//      {
//         throw new IllegalArgumentException("CheckIdIntercepto.checkFqnValidity(): fqn is not valid: " + id);
//      }
   }
}

