/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.cache.pojo;

import static org.testng.AssertJUnit.assertTrue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.pojo.impl.CachedType;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Basic CachedType test case.
 *
 * @author Ben Wang
 */
@Test(groups = {"functional"})
public class CachedTypeTest 
{
   Log log = LogFactory.getLog(CachedTypeTest.class);

   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      log.info("setUp() ....");
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
   }

   public void testInteger() throws Exception
   {
      CachedType t = new CachedType(int.class);
      assertTrue("Int ", t.isImmediate());

      t = new CachedType(Integer.class);
      assertTrue("Int ", t.isImmediate());
   }

   public void testShort() throws Exception
   {
      CachedType t = new CachedType(short.class);
      assertTrue("Short ", t.isImmediate());

      t = new CachedType(Short.class);
      assertTrue("Short ", t.isImmediate());
   }

   public void testString() throws Exception
   {
      CachedType t = new CachedType(String.class);
      assertTrue("String ", t.isImmediate());
   }

   public void testDouble() throws Exception
   {
      CachedType t = new CachedType(double.class);
      assertTrue("Double ", t.isImmediate());

      t = new CachedType(Double.class);
      assertTrue("Double ", t.isImmediate());
   }

   public void testChar() throws Exception
   {
      CachedType t = new CachedType(Character.class);
      assertTrue("Character ", t.isImmediate());

      t = new CachedType(Character.class);
      assertTrue("Character ", t.isImmediate());
   }

   public void testBoolean() throws Exception
   {
      CachedType t = new CachedType(boolean.class);
      assertTrue("Boolean ", t.isImmediate());

      t = new CachedType(Boolean.class);
      assertTrue("Boolean ", t.isImmediate());
   }

   public void testLong() throws Exception
   {
      CachedType t = new CachedType(long.class);
      assertTrue("Long ", t.isImmediate());

      t = new CachedType(Long.class);
      assertTrue("Long ", t.isImmediate());
   }

   public void testByte() throws Exception
   {
      CachedType t = new CachedType(byte.class);
      assertTrue("Byte ", t.isImmediate());

      t = new CachedType(Short.class);
      assertTrue("Byte ", t.isImmediate());
   }




}
