package org.jboss.cache.pojo.jmx;

import javax.management.ObjectName;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheFactory;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.testng.annotations.Test;

/**
 * Functional tests for CacheJmxWrapper broadcast of cache event notifications
 *
 * @author Jerry Gauthier
 * @version $Id: NotificationTest.java 5129 2008-01-15 00:19:02Z jason.greene@jboss.com $
 */
@Test(groups = {"functional"})
public class NotificationTest extends org.jboss.cache.jmx.NotificationTest
{
   private PojoCache pojoCache;



   @Override
   protected Object createCacheAndJmxWrapper() throws Exception
   {
      pojoCache = createCache(CLUSTER_NAME);
      cache = (CacheSPI<Object, Object>)pojoCache.getCache();
      return new PojoCacheJmxWrapper(pojoCache);
   }

   @Override
   protected void destroyCache()
   {
      if (pojoCache != null)
      {
         // stop the cache before the listener is unregistered
         //cache1.stop();
         pojoCache.destroy();
         pojoCache = null;
         cache = null;
      }
   }

   protected ObjectName getWrapperObjectName() throws Exception
   {
      return new ObjectName(JmxUtil.PREFIX + CLUSTER_NAME);
   }

   protected PojoCacheImpl createCache(String clusterName) throws Exception
   {
      Configuration config = createConfiguration(clusterName);

      PojoCacheImpl cache = (PojoCacheImpl) PojoCacheFactory.createCache(config, false);

      cache.create();
      // start the cache after the listener has been registered
      //cache.start();
      return cache;
   }
}