/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.rollback;

import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertFalse;
import static org.testng.AssertJUnit.assertNull;

import java.util.ArrayList;

import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.advice.Interceptor;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheFactory;
import org.jboss.cache.pojo.interceptors.dynamic.CacheFieldInterceptor;
import org.jboss.cache.pojo.test.Address;
import org.jboss.cache.pojo.test.Person;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Additional basic tests
 *
 * @author Ben Wang
 */

@Test(groups = {"functional"})
public class InMemoryTxUndoTest
{
   Log log_ = LogFactory.getLog(InMemoryTxUndoTest.class);
   PojoCache cache_;
   TransactionManager tx_mgr;


   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      log_.info("setUp() ....");
      String configFile = "META-INF/local-service.xml";
      boolean toStart = false;
      cache_ = PojoCacheFactory.createCache(configFile, toStart);
      cache_.start();
      tx_mgr = DummyTransactionManager.getInstance();

   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
      cache_.stop();
   }

   //   public void testDummy() {}
   private boolean hasCacheInterceptor(Object pojo)
   {
      Interceptor[] interceptors = ((Advised) pojo)._getInstanceAdvisor().getInterceptors();
      for (int i = 0; i < interceptors.length; i++)
      {
         if (interceptors[i] instanceof CacheFieldInterceptor)
            return true;
      }
      return false;
   }

   public void testSimpleTxWithRollback1() throws Exception
   {
      log_.info("testSimpleTxWithRollback1() ....");
      Person test = new Person();
      test.setName("Ben");
      test.setAge(10);
      tx_mgr.begin();
      cache_.attach("/a", test);
      test.setAge(20);
      tx_mgr.rollback();

      assertFalse("Should not have cache interceptor ", hasCacheInterceptor(test));
      assertEquals("Should still be ", 10, test.getAge());
   }

   public void testSimpleTxWithRollback2() throws Exception
   {
      log_.info("testSimpleTxWithRollback2() ....");
      Person test = new Person();
      test.setName("Ben");
      test.setAge(10);
      cache_.attach("/a", test);

      tx_mgr.begin();
      test.setAge(20);
      tx_mgr.rollback();
      assertEquals("Should still be ", 10, test.getAge());
   }

   public void testSimpleTxWithRollback3() throws Exception
   {
      log_.info("testSimpleTxWithRollback3() ....");
      Person test = new Person();
      test.setName("Ben");
      test.setAge(10);
      cache_.attach("/a", test);

      Person test1 = new Person();
      test1.setName("Irin");
      test1.setAge(30);
      Address addr = new Address();
      addr.setCity("Taipei");
      test1.setAddress(addr);
      tx_mgr.begin();
      cache_.attach("/a", test1);
      tx_mgr.rollback();

      assertEquals("Should still be ", 10, test.getAge());
      assertNull("Address should be ", test.getAddress());
   }

   public void testSimpleTxWithRollback4() throws Exception
   {
      log_.info("testSimpleTxWithRollback4() ....");
      Person test = new Person();
      test.setName("Ben");
      test.setAge(10);
      cache_.attach("/a", test);
      Address addr = new Address();
      addr.setCity("Taipei");
      test.setAddress(addr);

      tx_mgr.begin();
      addr.setCity("Tainan");
      tx_mgr.rollback();

      assertEquals("Should still be ", "Taipei", test.getAddress().getCity());
   }

   public void testSimpleTxWithRollback5() throws Exception
   {
      log_.info("testSimpleTxWithRollback5() ....");
      Person test = new Person();
      test.setName("Ben");
      test.setAge(10);
      cache_.attach("/a", test);

      ArrayList<String> lang = new ArrayList<String>();
      lang.add("English");
      test.setLanguages(lang);
      tx_mgr.begin();
      lang.add("French");
      tx_mgr.rollback();

      assertEquals("Should still be ", 1, test.getLanguages().size());
   }




}
