/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.notification.annotation.ArrayModified;
import org.jboss.cache.pojo.notification.annotation.Attached;
import org.jboss.cache.pojo.notification.annotation.Detached;
import org.jboss.cache.pojo.notification.annotation.FieldModified;
import org.jboss.cache.pojo.notification.annotation.ListModified;
import org.jboss.cache.pojo.notification.annotation.MapModified;
import org.jboss.cache.pojo.notification.annotation.PojoCacheListener;
import org.jboss.cache.pojo.notification.annotation.SetModified;
import org.jboss.cache.pojo.notification.annotation.TransactionCompleted;
import org.jboss.cache.pojo.notification.annotation.TransactionRegistered;
import org.jboss.cache.pojo.notification.event.ArrayModifiedEvent;
import org.jboss.cache.pojo.notification.event.AttachedEvent;
import org.jboss.cache.pojo.notification.event.DetachedEvent;
import org.jboss.cache.pojo.notification.event.Event;
import org.jboss.cache.pojo.notification.event.FieldModifiedEvent;
import org.jboss.cache.pojo.notification.event.ListModifiedEvent;
import org.jboss.cache.pojo.notification.event.MapModifiedEvent;
import org.jboss.cache.pojo.notification.event.SetModifiedEvent;
import org.jboss.cache.pojo.notification.event.TransactionCompletedEvent;
import org.jboss.cache.pojo.notification.event.TransactionRegisteredEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NotificationDispatcher {
    private static final Map<Class<? extends Annotation>, Class<? extends Event>> annotations = new HashMap<Class<? extends Annotation>, Class<? extends Event>>();
    private final Set<Entry> listeners = new CopyOnWriteArraySet<Entry>();
    private Set<Object> filteredListeners = new HashSet<Object>();
    private volatile boolean hasFilters;

    NotificationDispatcher() {
    }

    void add(Object listener) {
        this.listeners.add(new Entry(listener, true));
    }

    synchronized void add(Object listener, Pattern pattern) {
        this.listeners.add(new Entry(listener, true, pattern));
        this.filteredListeners.add(listener);
        this.hasFilters = true;
    }

    synchronized void remove(Object listener) {
        this.filteredListeners.remove(listener);
        if (this.filteredListeners.size() == 0) {
            this.hasFilters = false;
        }
        this.listeners.remove(new Entry(listener, false));
    }

    boolean hasFilters() {
        return this.hasFilters;
    }

    Set<Object> getListeners() {
        HashSet<Object> set = new HashSet<Object>();
        for (Entry entry : this.listeners) {
            set.add(entry.listener);
        }
        return Collections.unmodifiableSet(set);
    }

    Set<Entry> getListenerEntries(List<Fqn> fqns) {
        HashSet<Entry> set = new HashSet<Entry>();
        block0: for (Entry entry : this.listeners) {
            if (entry.pattern == null) {
                set.add(entry);
                continue;
            }
            for (Fqn fqn : fqns) {
                if (!entry.pattern.matcher(fqn.toString()).matches()) continue;
                set.add(entry);
                continue block0;
            }
        }
        return set;
    }

    boolean isEmpty() {
        return this.listeners.size() == 0;
    }

    void dispatch(Event notification) {
        for (Entry entry : this.listeners) {
            if (entry.pattern != null) continue;
            this.dispatch(notification, entry);
        }
    }

    void dispatch(Event notification, Set<Entry> listeners) {
        for (Entry listener : listeners) {
            this.dispatch(notification, listener);
        }
    }

    private void dispatch(Event notification, Entry entry) {
        List methods = (List)entry.notifiers.get(notification.getClass());
        if (methods == null) {
            return;
        }
        try {
            for (Method method : methods) {
                method.invoke(entry.listener, notification);
            }
        }
        catch (Exception e) {
            throw new PojoCacheException(e);
        }
    }

    static {
        annotations.put(Attached.class, AttachedEvent.class);
        annotations.put(Detached.class, DetachedEvent.class);
        annotations.put(FieldModified.class, FieldModifiedEvent.class);
        annotations.put(ListModified.class, ListModifiedEvent.class);
        annotations.put(MapModified.class, MapModifiedEvent.class);
        annotations.put(SetModified.class, SetModifiedEvent.class);
        annotations.put(ArrayModified.class, ArrayModifiedEvent.class);
        annotations.put(TransactionRegistered.class, TransactionRegisteredEvent.class);
        annotations.put(TransactionCompleted.class, TransactionCompletedEvent.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Entry {
        private final Object listener;
        private final Pattern pattern;
        private final Map<Class<?>, List<Method>> notifiers;

        private Entry(Object listener, boolean build) {
            this(listener, build, (Pattern)null);
        }

        private Entry(Object listener, boolean build, Pattern pattern) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener can't be null");
            }
            this.listener = listener;
            this.pattern = pattern;
            this.notifiers = build ? Entry.buildNotifiers(listener.getClass()) : null;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            return ((Entry)o).listener == this.listener;
        }

        private static Map<Class<?>, List<Method>> buildNotifiers(Class clazz) {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new IllegalArgumentException("Listener must be public! Class:" + clazz.getName());
            }
            if (!clazz.isAnnotationPresent(PojoCacheListener.class)) {
                throw new IllegalArgumentException("Not a listener, class did not contain @PojoCacheListener. Class: " + clazz.getName());
            }
            HashMap notifiers = new HashMap();
            for (Method method : clazz.getMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    Class event = (Class)annotations.get(annotation.annotationType());
                    if (event == null) continue;
                    Class<?>[] types = method.getParameterTypes();
                    if (types.length != 1 || !types[0].isAssignableFrom(event)) {
                        throw new IllegalArgumentException("Listener has invlaid method signature for annotation. Method: \"" + method.getName() + "\" " + "Annotation: \"" + annotation.annotationType().getSimpleName() + "\" " + "Expected Parameter: \"" + event.getSimpleName() + "\"");
                    }
                    ArrayList<Method> list = (ArrayList<Method>)notifiers.get(event);
                    if (list == null) {
                        list = new ArrayList<Method>();
                        notifiers.put(event, list);
                    }
                    list.add(method);
                }
            }
            return notifiers;
        }
    }
}

