/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.jcip.annotations.Immutable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.FqnComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Fqn<E>
implements Cloneable,
Externalizable,
Comparable<Fqn<?>> {
    public static final String SEPARATOR = "/";
    private static final long serialVersionUID = -5351930616956603651L;
    private static final Log log = LogFactory.getLog(Fqn.class);
    private List<E> elements;
    private transient int hash_code = 0;
    private int size = 0;
    public static final Fqn ROOT = new Fqn();
    private String cachedStringRep;

    public Fqn() {
        this.elements = Collections.emptyList();
        this.size = 0;
    }

    public Fqn(List<E> names) {
        this(names, false);
    }

    public Fqn(List<E> names, boolean safe) {
        if (names != null) {
            this.elements = safe ? names : new ArrayList(names);
            this.size = this.elements.size();
        } else {
            this.elements = Collections.emptyList();
            this.size = 0;
        }
    }

    public Fqn(E ... names) {
        this(Arrays.asList(names), true);
    }

    public Fqn(Fqn<E> base, Fqn<E> relative) {
        this(base, relative.elements);
    }

    public Fqn(Fqn<E> base, List<E> relative) {
        ArrayList<E> elements = new ArrayList<E>(base.elements.size() + relative.size());
        elements.addAll(base.elements);
        elements.addAll(relative);
        this.elements = elements;
        this.size = elements.size();
    }

    public Fqn(Fqn<E> base, E ... childNames) {
        ArrayList<E> elements = new ArrayList<E>(base.elements.size() + childNames.length);
        elements.addAll(base.elements);
        elements.addAll(Arrays.asList(childNames));
        this.elements = elements;
        this.size = elements.size();
    }

    public static Fqn<String> fromString(String stringRepresentation) {
        if (stringRepresentation == null) {
            return Fqn.root();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(stringRepresentation, SEPARATOR);
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return new Fqn<String>((List<String>)list, true);
    }

    public Fqn<E> getAncestor(int generation) {
        if (generation == 0) {
            return Fqn.root();
        }
        return this.getSubFqn(0, generation);
    }

    public Fqn<E> getSubFqn(int startIndex, int endIndex) {
        return new Fqn<E>(this.elements.subList(startIndex, endIndex), true);
    }

    public int size() {
        return this.size;
    }

    public E get(int n) {
        return this.elements.get(n);
    }

    public E getLastElement() {
        if (this.isRoot()) {
            return null;
        }
        return this.elements.get(this.size - 1);
    }

    public boolean hasElement(E element) {
        return this.elements.indexOf(element) != -1;
    }

    public Fqn<E> clone() throws CloneNotSupportedException {
        try {
            return (Fqn)super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("Unable to clone Fqn " + this), (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fqn)) {
            return false;
        }
        Fqn other = (Fqn)obj;
        return this.size == other.size() && ((Object)this.elements).equals(other.elements);
    }

    public int hashCode() {
        if (this.hash_code == 0) {
            this.hash_code = this._hashCode();
        }
        return this.hash_code;
    }

    public String toString() {
        if (this.cachedStringRep == null) {
            if (this.isRoot()) {
                this.cachedStringRep = SEPARATOR;
            } else {
                StringBuilder sb = new StringBuilder();
                for (E element : this.elements) {
                    sb.append(SEPARATOR).append(element);
                }
                this.cachedStringRep = sb.toString();
            }
        }
        return this.cachedStringRep;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.size);
        for (E element : this.elements) {
            out.writeObject(element);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readShort();
        this.elements = new ArrayList(this.size);
        for (int i = 0; i < this.size; ++i) {
            Object e = in.readObject();
            this.elements.add(e);
        }
    }

    public boolean isChildOf(Fqn<E> parentFqn) {
        return parentFqn.size() != this.size && this.isChildOrEquals(parentFqn);
    }

    public boolean isChildOrEquals(Fqn<E> parentFqn) {
        List<E> parentList = parentFqn.elements;
        if (parentList.size() > this.size) {
            return false;
        }
        for (int i = parentList.size() - 1; i >= 0; --i) {
            if (parentList.get(i).equals(this.elements.get(i))) continue;
            return false;
        }
        return true;
    }

    private int _hashCode() {
        int hashCode = 0;
        int count = 1;
        for (E element : this.elements) {
            E o = element;
            hashCode += o == null ? 0 : o.hashCode() * count++;
        }
        if (hashCode == 0) {
            hashCode = 65261;
        }
        return hashCode;
    }

    public Fqn<E> getParent() {
        switch (this.size) {
            case 0: 
            case 1: {
                return Fqn.root();
            }
        }
        return new Fqn<E>(this.elements.subList(0, this.size - 1));
    }

    public static <T> Fqn<T> root() {
        return ROOT;
    }

    public boolean isRoot() {
        return this.size == 0;
    }

    public String getLastElementAsString() {
        if (this.isRoot()) {
            return SEPARATOR;
        }
        return String.valueOf(this.getLastElement());
    }

    public List<E> peekElements() {
        return this.elements;
    }

    @Override
    public int compareTo(Fqn<?> Fqn2) {
        return FqnComparator.INSTANCE.compare(this, Fqn2);
    }
}

