/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.AbstractNode;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotValidException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.factories.annotations.CacheInjectionMethods;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.marshall.MarshalledValue;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheInjectionMethods
public class UnversionedNode<K, V>
extends AbstractNode<K, V> {
    protected static Log log = LogFactory.getLog(UnversionedNode.class);
    protected static boolean trace = log.isTraceEnabled();
    private boolean childrenLoaded = false;
    private boolean dataLoaded = true;
    private transient IdentityLock lock_ = null;
    private transient CacheSPI cache;
    private transient CacheImpl cacheImpl;
    private final Map data = new HashMap();
    private boolean lockForChildInsertRemove;
    private boolean valid = true;
    private NodeSPI delegate;

    public UnversionedNode() {
        this.fqn = Fqn.ROOT;
    }

    protected UnversionedNode(Object child_name, Fqn fqn, Map data, boolean mapSafe, CacheSPI cache) {
        this.init(child_name, fqn, cache);
        this.setInternalState(data);
    }

    public NodeSPI getDelegate() {
        return this.delegate;
    }

    public void setDelegate(NodeSPI delegate) {
        this.delegate = delegate;
    }

    @Inject
    private void injectDependencies(CacheSPI spi, CacheImpl impl) {
        this.cache = spi;
        this.cacheImpl = impl;
    }

    private void init(Object child_name, Fqn fqn, CacheSPI cache) {
        if (cache == null) {
            throw new IllegalArgumentException("no cache init for " + fqn);
        }
        this.cache = cache;
        this.fqn = fqn;
        if (!fqn.isRoot() && !child_name.equals(fqn.getLastElement())) {
            throw new IllegalArgumentException("Child " + child_name + " must be last part of " + fqn);
        }
        this.lockForChildInsertRemove = cache.getConfiguration().isLockParentForChildInsertRemove();
    }

    public NodeSPI getParent() {
        if (this.fqn.isRoot()) {
            return null;
        }
        return this.cache.peek(this.fqn.getParent(), true);
    }

    private synchronized void initLock() {
        if (this.lock_ == null) {
            this.lock_ = new IdentityLock(this.cache.getConfiguration().getIsolationLevel(), this.delegate);
        }
    }

    private synchronized Map<Object, Node<K, V>> children() {
        if (this.children == null) {
            this.children = this.getFqn().isRoot() ? new ConcurrentHashMap(64, 0.5f, 16) : new ConcurrentHashMap(4, 0.75f, 4);
        }
        return this.children;
    }

    public CacheSPI getCache() {
        return this.cache;
    }

    public boolean isChildrenLoaded() {
        return this.childrenLoaded;
    }

    public void setChildrenLoaded(boolean flag) {
        this.childrenLoaded = flag;
    }

    private void assertValid() {
        if (!this.valid) {
            throw new NodeNotValidException("Node " + this.getFqn() + " is not valid.  Perhaps it has been moved or removed.");
        }
    }

    public Object get(Object key) {
        this.assertValid();
        return this.cache.get(this.getFqn(), key);
    }

    public Object getDirect(Object key) {
        return this.data.get(key);
    }

    private boolean isReadLocked() {
        return this.lock_ != null && this.lock_.isReadLocked();
    }

    private boolean isWriteLocked() {
        return this.lock_ != null && this.lock_.isWriteLocked();
    }

    public IdentityLock getLock() {
        this.initLock();
        return this.lock_;
    }

    public Map getDataDirect() {
        if (this.data == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.data);
    }

    public Object put(Object key, Object value) {
        this.assertValid();
        return this.cache.put(this.getFqn(), key, value);
    }

    public Object putDirect(Object key, Object value) {
        return this.data.put(key, value);
    }

    public NodeSPI getOrCreateChild(Object child_name, GlobalTransaction gtx, boolean notify) {
        return this.getOrCreateChild(child_name, gtx, true, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeSPI getOrCreateChild(Object child_name, GlobalTransaction gtx, boolean createIfNotExists, boolean notify) {
        if (child_name == null) {
            throw new IllegalArgumentException("null child name");
        }
        NodeSPI child = (NodeSPI)this.children().get(child_name);
        InvocationContext ctx = this.cache.getInvocationContext();
        if (createIfNotExists && child == null) {
            Fqn<Object> child_fqn = new Fqn<Object>(this.fqn, child_name);
            NodeSPI newChild = (NodeSPI)this.cache.getConfiguration().getRuntimeConfig().getNodeFactory().createNode(child_name, this.delegate, null);
            if (newChild == null) {
                throw new IllegalStateException();
            }
            UnversionedNode unversionedNode = this;
            synchronized (unversionedNode) {
                child = (NodeSPI)this.children().get(child_name);
                if (child == null) {
                    if (notify) {
                        this.cache.getNotifier().notifyNodeCreated(child_fqn, true, ctx);
                    }
                    child = newChild;
                    this.children.put(child_name, child);
                    if (gtx != null) {
                        MethodCall undo_op = MethodCallFactory.create(5, gtx, child_fqn, false, false);
                        this.cacheImpl.addUndoOperation(gtx, undo_op);
                    }
                }
            }
            if (newChild == child) {
                if (trace) {
                    log.trace((Object)("created child: fqn=" + child_fqn));
                }
                if (notify) {
                    this.cache.getNotifier().notifyNodeCreated(child_fqn, false, ctx);
                }
            }
        }
        return child;
    }

    public Object remove(Object key) {
        this.assertValid();
        return this.cache.remove(this.getFqn(), key);
    }

    public Object removeDirect(Object key) {
        if (this.data == null) {
            return null;
        }
        return this.data.remove(key);
    }

    public void printDetails(StringBuffer sb, int indent) {
        this.printDetailsInMap(sb, indent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (!this.valid) {
            sb.append(" (INVALID!) ");
        }
        if (this.deleted) {
            sb.append(" (deleted) [ ").append(this.fqn);
        } else {
            sb.append("[ ").append(this.fqn);
        }
        if (this.data != null) {
            Map map = this.data;
            synchronized (map) {
                if (trace) {
                    sb.append(" data=").append(this.data.keySet());
                } else {
                    sb.append(" data=[");
                    Set keys = this.data.keySet();
                    int i = 0;
                    for (Object o : keys) {
                        sb.append(o);
                        if (++i == 5) {
                            int more = keys.size() - 5;
                            if (more <= 1) continue;
                            sb.append(", and ");
                            sb.append(more);
                            sb.append(" more");
                            break;
                        }
                        sb.append(", ");
                    }
                    sb.append("]");
                }
            }
        }
        if (this.children != null && !this.children.isEmpty()) {
            if (trace) {
                sb.append(" children=").append(this.getChildrenNamesDirect());
            } else {
                sb.append(" children=[");
                Set<Object> names = this.getChildrenNamesDirect();
                int i = 0;
                for (Object o : names) {
                    sb.append(o);
                    if (++i == 5) {
                        int more = names.size() - 5;
                        if (more <= 1) continue;
                        sb.append(", and ");
                        sb.append(more);
                        sb.append(" more");
                        break;
                    }
                    sb.append(", ");
                }
                sb.append("]");
            }
        }
        if (this.lock_ != null) {
            if (this.isReadLocked()) {
                sb.append(" RL");
            }
            if (this.isWriteLocked()) {
                sb.append(" WL");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildDirect(NodeSPI child) {
        if (child.getFqn().getParent().equals(this.getFqn())) {
            UnversionedNode unversionedNode = this;
            synchronized (unversionedNode) {
                this.children().put(child.getFqn().getLastElement(), child);
            }
        } else {
            throw new CacheException("Attempting to add a child [" + child.getFqn() + "] to [" + this.getFqn() + "].  Can only add direct children.");
        }
    }

    public NodeSPI addChildDirect(Fqn f) {
        return this.addChildDirect(f, true);
    }

    public NodeSPI addChildDirect(Fqn f, boolean notify) {
        if (f.size() == 1) {
            GlobalTransaction gtx = this.cache.getInvocationContext().getGlobalTransaction();
            return this.getOrCreateChild(f.getLastElement(), gtx, true, notify);
        }
        throw new UnsupportedOperationException("Cannot directly create children which aren't directly under the current node.");
    }

    public NodeSPI addChildDirect(Object childName, boolean notify) {
        GlobalTransaction gtx = this.cache.getInvocationContext().getGlobalTransaction();
        return this.getOrCreateChild(childName, gtx, true, notify);
    }

    public void clearDataDirect() {
        if (this.data != null) {
            this.data.clear();
        }
    }

    public NodeSPI getChildDirect(Fqn fqn) {
        if (fqn.size() == 1) {
            return this.getChildDirect(fqn.getLastElement());
        }
        NodeSPI currentNode = this.delegate;
        for (int i = 0; i < fqn.size(); ++i) {
            Object nextChildName = fqn.get(i);
            if ((currentNode = currentNode.getChildDirect(nextChildName)) != null) continue;
            return null;
        }
        return currentNode;
    }

    public Set<Object> getChildrenNamesDirect() {
        return this.children == null ? Collections.emptySet() : new HashSet(this.children.keySet());
    }

    public Set<Object> getKeysDirect() {
        if (this.data == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet(this.data.keySet()));
    }

    public boolean removeChildDirect(Object childName) {
        return this.children != null && this.children.remove(childName) != null;
    }

    public boolean removeChildDirect(Fqn f) {
        if (f.size() == 1) {
            return this.removeChildDirect(f.getLastElement());
        }
        NodeSPI child = this.getChildDirect(f);
        return child != null && child.getParent().removeChildDirect(f.getLastElement());
    }

    public Map<Object, Node<K, V>> getChildrenMapDirect() {
        return this.children;
    }

    public void setChildrenMapDirect(Map<Object, Node<K, V>> children) {
        this.children().clear();
        this.children.putAll(children);
    }

    public void putAll(Map data) {
        this.assertValid();
        this.cache.put(this.fqn, data);
    }

    public void putAllDirect(Map data) {
        if (data == null) {
            return;
        }
        this.data.putAll(data);
    }

    public void removeChildrenDirect() {
        if (this.children != null) {
            this.children.clear();
        }
        this.children = null;
    }

    public void setVersion(DataVersion version) {
        throw new UnsupportedOperationException("Versioning not supported");
    }

    public DataVersion getVersion() {
        throw new UnsupportedOperationException("Versioning not supported");
    }

    private void printIndent(StringBuffer sb, int indent) {
        if (sb != null) {
            for (int i = 0; i < indent; ++i) {
                sb.append(" ");
            }
        }
    }

    public void addChild(Object child_name, Node n) {
        if (child_name != null) {
            this.children().put(child_name, n);
        }
    }

    private Object getName() {
        return this.fqn.getLastElement();
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public void setFqn(Fqn fqn) {
        if (trace) {
            log.trace((Object)(this.getFqn() + " set FQN " + fqn));
        }
        this.fqn = fqn;
        if (this.children == null) {
            return;
        }
        for (Map.Entry me : this.children.entrySet()) {
            NodeSPI n = (NodeSPI)me.getValue();
            Fqn<Object> cfqn = new Fqn<Object>(fqn, me.getKey());
            n.setFqn(cfqn);
        }
    }

    public NodeSPI getChildDirect(Object childName) {
        if (childName == null) {
            return null;
        }
        return (NodeSPI)(this.children == null ? null : (Node)this.children.get(childName));
    }

    public Set<NodeSPI> getChildrenDirect() {
        if (this.children == null || this.children.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<NodeSPI> exclDeleted = new HashSet<NodeSPI>();
        for (Node n : this.children.values()) {
            NodeSPI spi = (NodeSPI)n;
            if (spi.isDeleted()) continue;
            exclDeleted.add(spi);
        }
        return Collections.unmodifiableSet(exclDeleted);
    }

    public boolean hasChildrenDirect() {
        return this.children != null && this.children.size() != 0;
    }

    public Set<NodeSPI> getChildrenDirect(boolean includeMarkedForRemoval) {
        if (includeMarkedForRemoval) {
            if (this.children != null && !this.children.isEmpty()) {
                return Collections.unmodifiableSet(new HashSet(this.children.values()));
            }
            return Collections.emptySet();
        }
        return this.getChildrenDirect();
    }

    private void printDetailsInMap(StringBuffer sb, int indent) {
        this.printIndent(sb, indent);
        indent += 2;
        if (!this.getFqn().isRoot()) {
            sb.append("/");
        }
        sb.append(this.getName());
        sb.append("  ");
        sb.append(this.data);
        if (this.children != null) {
            for (Node n : this.children.values()) {
                sb.append("\n");
                ((NodeSPI)n).printDetails(sb, indent);
            }
        }
    }

    public boolean isDataLoaded() {
        return this.dataLoaded;
    }

    public void setDataLoaded(boolean dataLoaded) {
        this.dataLoaded = dataLoaded;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid, boolean recursive) {
        this.valid = valid;
        if (trace) {
            log.trace((Object)("Marking node " + this.getFqn() + " as " + (valid ? "" : "in") + "valid"));
        }
        if (recursive) {
            for (Node<K, V> child : this.children().values()) {
                ((NodeSPI)child).setValid(valid, recursive);
            }
        }
    }

    public boolean isLockForChildInsertRemove() {
        return this.lockForChildInsertRemove;
    }

    public void setLockForChildInsertRemove(boolean lockForChildInsertRemove) {
        this.lockForChildInsertRemove = lockForChildInsertRemove;
    }

    public void setInternalState(Map state) {
        this.putAllDirect(state);
    }

    public Map getInternalState(boolean onlyInternalState) {
        if (onlyInternalState) {
            return new HashMap(0);
        }
        if (this.data == null) {
            return new HashMap(0);
        }
        return new HashMap(this.data);
    }

    public void releaseObjectReferences(boolean recursive) {
        if (recursive && this.children != null) {
            for (Node child : this.children.values()) {
                child.releaseObjectReferences(recursive);
            }
        }
        if (this.data != null) {
            for (Object key : this.data.keySet()) {
                Object value = this.data.get(key);
                if (key instanceof MarshalledValue) {
                    ((MarshalledValue)key).compact(true, true);
                }
                if (!(value instanceof MarshalledValue)) continue;
                ((MarshalledValue)value).compact(true, true);
            }
        }
    }
}

