/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.NodeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIFOQueue
implements EvictionQueue {
    private Map<Fqn, NodeEntry> nodeMap = new LinkedHashMap<Fqn, NodeEntry>();
    private int numElements = 0;

    FIFOQueue() {
    }

    @Override
    public NodeEntry getFirstNodeEntry() {
        if (this.nodeMap.size() > 0) {
            return this.nodeMap.values().iterator().next();
        }
        return null;
    }

    @Override
    public NodeEntry getNodeEntry(Fqn fqn) {
        return this.nodeMap.get(fqn);
    }

    @Override
    public NodeEntry getNodeEntry(String fqn) {
        return this.getNodeEntry(Fqn.fromString(fqn));
    }

    @Override
    public boolean containsNodeEntry(NodeEntry entry) {
        Fqn fqn = entry.getFqn();
        return this.getNodeEntry(fqn) != null;
    }

    @Override
    public void removeNodeEntry(NodeEntry entry) {
        NodeEntry e = this.nodeMap.remove(entry.getFqn());
        this.numElements -= e.getNumberOfElements();
    }

    @Override
    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            entry.queue = this;
            this.nodeMap.put(entry.getFqn(), entry);
            this.numElements += entry.getNumberOfElements();
        }
    }

    @Override
    public int getNumberOfNodes() {
        return this.nodeMap.size();
    }

    @Override
    public int getNumberOfElements() {
        return this.numElements;
    }

    @Override
    public void modifyElementCount(int difference) {
        this.numElements += difference;
    }

    @Override
    public void clear() {
        this.nodeMap.clear();
        this.numElements = 0;
    }

    @Override
    public Iterator<NodeEntry> iterate() {
        return this.nodeMap.values().iterator();
    }
}

