/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentFactory {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected ComponentRegistry componentRegistry;
    protected Configuration configuration;

    @Inject
    private void injectDependencies(Configuration configuration, ComponentRegistry componentRegistry) {
        this.configuration = configuration;
        this.componentRegistry = componentRegistry;
    }

    protected abstract <T> T construct(String var1, Class<T> var2);

    protected void assertTypeConstructable(Class requestedType, Class ... ableToConstruct) {
        boolean canConstruct = false;
        for (Class c : ableToConstruct) {
            canConstruct = canConstruct || requestedType.isAssignableFrom(c);
        }
        if (!canConstruct) {
            throw new ConfigurationException("Don't know how to construct " + requestedType);
        }
    }
}

